/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.map.Association;
import cirrus.hibernate.map.Root;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.type.EntityType;
import cirrus.hibernate.type.Type;
import cirrus.hibernate.type.TypeFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ManyToOne
extends Association {
    public ManyToOne(Node node, String path, String defaultColumnName, boolean isNullable, Table table, Root root) throws MappingException {
        super(node, path, defaultColumnName, isNullable, table, root);
    }

    protected Type typeFromXML(Node node, String path, Root root) throws MappingException {
        NamedNodeMap atts = node.getAttributes();
        Node typeNode = atts.getNamedItem("class");
        if (typeNode == null) {
            return null;
        }
        try {
            return TypeFactory.manyToOne(ReflectHelper.classForName(typeNode.getNodeValue()));
        }
        catch (Exception e) {
            throw new MappingException("Could not find class: " + typeNode.getNodeValue());
        }
    }

    public void setTypeByReflection(Class propertyClass, String propertyName) throws MappingException {
        try {
            if (this.getType() == null) {
                this.setType(TypeFactory.manyToOne(ReflectHelper.getGetter(propertyClass, propertyName).getReturnType()));
            }
        }
        catch (HibernateException he) {
            throw new MappingException("Problem trying to set association type by reflection", (Throwable)((Object)he));
        }
    }

    public void createForeignKeys(Root root, Table table) {
        this.createForeignKeyOfClass(root, table, ((EntityType)this.getType()).getPersistentClass());
    }
}

