/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.stack;

import java.io.Serializable;
import java.util.List;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.RouterStub;
import org.jgroups.tests.stack.Utilities;
import org.jgroups.util.Promise;

public class RouterStubTest
extends TestCase {
    RouterStub stub;
    RouterStub stub2;
    private static final Log log = LogFactory.getLog((Class)RouterStubTest.class);
    private static final String groupName = "TESTGROUP";
    private int routerPort = -1;
    private Random random = new Random();

    public RouterStubTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.routerPort = Utilities.startGossipRouter("127.0.0.1");
        this.stub = new RouterStub("127.0.0.1", this.routerPort);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.stub.disconnect();
        if (this.stub2 != null) {
            this.stub2.disconnect();
        }
        Utilities.stopGossipRouter();
    }

    public void testEmptyGET() throws Exception {
        log.info((Object)"running testEmptyGET");
        List mbrs = this.stub.get("nosuchgroup");
        RouterStubTest.assertNotNull((Object)mbrs);
        RouterStubTest.assertEquals((int)0, (int)mbrs.size());
    }

    public void test_CONNECT_GET() throws Exception {
        log.info((Object)"running test_CONNECT_GET");
        this.stub.connect(groupName);
        Address localAddr = this.stub.getLocalAddress();
        System.out.println("-- my address is " + localAddr);
        RouterStubTest.assertNotNull((Object)localAddr);
        List groupList = this.stub.get(groupName);
        RouterStubTest.assertEquals((int)1, (int)groupList.size());
        RouterStubTest.assertEquals((Object)localAddr, groupList.remove(0));
    }

    public void test_CONNECT_Route_To_Self() throws Exception {
        log.info((Object)"running test_CONNECT_Route_To_Self");
        this.stub.connect(groupName);
        Address localAddr = this.stub.getLocalAddress();
        String payload = "THIS IS A MESSAGE PAYLOAD " + this.random.nextLong();
        Message msg = new Message(null, localAddr, (Serializable)((Object)payload));
        this.stub.send(msg, groupName);
        Message rsp = this.stub.receive();
        RouterStubTest.assertEquals((Object)localAddr, (Object)rsp.getSrc());
        RouterStubTest.assertEquals((Object)payload, (Object)rsp.getObject());
        msg = new Message(localAddr, localAddr, (Serializable)((Object)payload));
        this.stub.send(msg, groupName);
        rsp = this.stub.receive();
        RouterStubTest.assertEquals((Object)localAddr, (Object)rsp.getSrc());
        RouterStubTest.assertEquals((Object)payload, (Object)rsp.getObject());
    }

    public void test_CONNECT_Route_To_All() throws Exception {
        log.info((Object)"running test_CONNECT_Route_To_All");
        this.stub2 = new RouterStub("127.0.0.1", this.routerPort);
        this.stub.connect(groupName);
        Address addr = this.stub.getLocalAddress();
        this.stub2.connect(groupName);
        addr = this.stub2.getLocalAddress();
        Thread.sleep(1000L);
        String payload = "THIS IS A MESSAGE PAYLOAD " + this.random.nextLong();
        Message msg = new Message(null, addr, (Serializable)((Object)payload));
        this.stub.send(msg, groupName);
        Message msgCopy = this.stub2.receive();
        RouterStubTest.assertEquals((Object)addr, (Object)msgCopy.getSrc());
        RouterStubTest.assertNull((Object)msgCopy.getDest());
        RouterStubTest.assertEquals((Object)msg.getObject(), (Object)msgCopy.getObject());
        this.stub2.disconnect();
    }

    public void test_CONNECT_Route_To_Other() throws Exception {
        log.info((Object)"running test_CONNECT_Route_To_Other");
        this.stub.connect(groupName);
        Address localAddrOne = this.stub.getLocalAddress();
        this.stub2 = new RouterStub("127.0.0.1", this.routerPort);
        this.stub2.connect(groupName);
        Address localAddrTwo = this.stub2.getLocalAddress();
        Thread.sleep(1000L);
        String payload = "THIS IS A MESSAGE PAYLOAD " + this.random.nextLong();
        Message msg = new Message(localAddrTwo, localAddrOne, (Serializable)((Object)payload));
        this.stub.send(msg, groupName);
        Message msgCopy = this.stub2.receive();
        RouterStubTest.assertEquals((Object)localAddrOne, (Object)msgCopy.getSrc());
        RouterStubTest.assertEquals((Object)localAddrTwo, (Object)msgCopy.getDest());
        RouterStubTest.assertEquals((Object)msg.getObject(), (Object)msgCopy.getObject());
        this.stub2.disconnect();
    }

    public void test_CONNECT_RouteStressAll() throws Exception {
        int i;
        log.info((Object)"running test_CONNECT_RouteStressAll, this may take a while .... ");
        this.stub.connect(groupName);
        final Address localAddrOne = this.stub.getLocalAddress();
        this.stub2 = new RouterStub("127.0.0.1", this.routerPort);
        this.stub2.connect(groupName);
        Thread.sleep(1000L);
        int count = 20000;
        int timeout = 50;
        final boolean[] received = new boolean[20000];
        for (int i2 = 0; i2 < 20000; ++i2) {
            received[i2] = false;
        }
        final Promise waitingArea = new Promise();
        long start = System.currentTimeMillis();
        new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < 20000; ++i) {
                    Message msg = new Message(null, localAddrOne, new Integer(i));
                    try {
                        RouterStubTest.this.stub.send(msg, RouterStubTest.groupName);
                        if (i % 2000 != 0) continue;
                        System.out.println("--sent " + i);
                        continue;
                    }
                    catch (Exception e) {
                        waitingArea.setResult(e);
                    }
                }
            }
        }, "Sending Thread").start();
        new Thread(new Runnable(){

            public void run() {
                int cnt = 0;
                while (cnt < 20000) {
                    try {
                        Message msg = RouterStubTest.this.stub2.receive();
                        int index = (Integer)msg.getObject();
                        received[index] = true;
                        if (++cnt % 2000 != 0) continue;
                        System.out.println("-- [stub2] received " + cnt);
                    }
                    catch (Exception e) {
                        waitingArea.setResult(e);
                    }
                }
                waitingArea.setResult(Boolean.TRUE);
            }
        }, "Receiving Thread stub2").start();
        new Thread(new Runnable(){

            public void run() {
                int cnt = 0;
                while (cnt < 20000) {
                    try {
                        Message msg = RouterStubTest.this.stub.receive();
                        int index = (Integer)msg.getObject();
                        received[index] = true;
                        if (++cnt % 2000 != 0) continue;
                        System.out.println("-- [stub] received " + cnt);
                    }
                    catch (Exception e) {
                        waitingArea.setResult(e);
                    }
                }
                waitingArea.setResult(Boolean.TRUE);
            }
        }, "Receiving Thread stub").start();
        Object result = waitingArea.getResult((long)timeout * 1000L);
        long stop = System.currentTimeMillis();
        this.stub2.disconnect();
        int messok = 0;
        for (i = 0; i < 20000; ++i) {
            if (!received[i]) continue;
            ++messok;
        }
        if (result == null) {
            RouterStubTest.fail((String)("Timeout while waiting for all messages to be received. " + messok + " messages out of " + 20000 + " received so far."));
        }
        if (result instanceof Exception) {
            throw (Exception)result;
        }
        for (i = 0; i < 20000; ++i) {
            if (received[i]) continue;
            RouterStubTest.fail((String)("At least message " + i + " NOT RECEIVED"));
        }
        System.out.println("STRESS TEST OK, 20000 messages, " + 20000000L / (stop - start) + " messages/sec");
    }

    public static Test suite() {
        return new TestSuite(RouterStubTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RouterStubTest.suite());
        System.exit(0);
    }
}

