/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.psvi.XSObjectList;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractParticleTraverser;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XSDComplexTypeTraverser
extends XSDAbstractParticleTraverser {
    private static final int GLOBAL_NUM = 10;
    private String fName = null;
    private String fTargetNamespace = null;
    private short fDerivedBy = (short)2;
    private short fFinal = 0;
    private short fBlock = 0;
    private short fContentType = 0;
    private XSTypeDecl fBaseType = null;
    private XSAttributeGroupDecl fAttrGrp = null;
    private XSSimpleType fXSSimpleType = null;
    private XSParticleDecl fParticle = null;
    private boolean fIsAbstract = false;
    private XSComplexTypeDecl fComplexTypeDecl = null;
    private Object[] fGlobalStore = null;
    private int fGlobalStorePos = 0;
    private static final boolean DEBUG = false;
    private SchemaDVFactory schemaFactory = SchemaDVFactory.getInstance();

    XSDComplexTypeTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
    }

    XSComplexTypeDecl traverseLocal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        String string = this.genAnonTypeName(element);
        this.contentBackup();
        XSComplexTypeDecl xSComplexTypeDecl = this.traverseComplexTypeDecl(element, string, objectArray, xSDocumentInfo, schemaGrammar);
        this.contentRestore();
        schemaGrammar.addComplexTypeDecl(xSComplexTypeDecl, this.fSchemaHandler.element2Locator(element));
        xSComplexTypeDecl.setIsAnonymous();
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSComplexTypeDecl;
    }

    XSComplexTypeDecl traverseGlobal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, true, xSDocumentInfo);
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        this.contentBackup();
        XSComplexTypeDecl xSComplexTypeDecl = this.traverseComplexTypeDecl(element, string, objectArray, xSDocumentInfo, schemaGrammar);
        this.contentRestore();
        if (string == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_COMPLEXTYPE, SchemaSymbols.ATT_NAME}, element);
        } else {
            schemaGrammar.addGlobalTypeDecl(xSComplexTypeDecl);
        }
        schemaGrammar.addComplexTypeDecl(xSComplexTypeDecl, this.fSchemaHandler.element2Locator(element));
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSComplexTypeDecl;
    }

    private XSComplexTypeDecl traverseComplexTypeDecl(Element element, String string, Object[] objectArray, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        this.fComplexTypeDecl = new XSComplexTypeDecl();
        this.fAttrGrp = new XSAttributeGroupDecl();
        Boolean bl = (Boolean)objectArray[XSAttributeChecker.ATTIDX_ABSTRACT];
        XInt xInt = (XInt)objectArray[XSAttributeChecker.ATTIDX_BLOCK];
        Boolean bl2 = (Boolean)objectArray[XSAttributeChecker.ATTIDX_MIXED];
        XInt xInt2 = (XInt)objectArray[XSAttributeChecker.ATTIDX_FINAL];
        this.fName = string;
        this.fComplexTypeDecl.setName(this.fName);
        this.fTargetNamespace = xSDocumentInfo.fTargetNamespace;
        this.fBlock = xInt == null ? xSDocumentInfo.fBlockDefault : xInt.shortValue();
        short s = this.fFinal = xInt2 == null ? xSDocumentInfo.fFinalDefault : xInt2.shortValue();
        if (bl != null && bl.booleanValue()) {
            this.fIsAbstract = true;
        }
        Element element2 = null;
        try {
            element2 = DOMUtil.getFirstChildElement(element);
            if (element2 != null) {
                if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
                    element2 = DOMUtil.getNextSiblingElement(element2);
                }
                if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, element2);
                }
            }
            if (element2 == null) {
                this.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(element2, bl2, false, xSDocumentInfo, schemaGrammar);
            } else if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_SIMPLECONTENT)) {
                this.traverseSimpleContent(element2, xSDocumentInfo, schemaGrammar);
                Element element3 = DOMUtil.getNextSiblingElement(element2);
                if (element3 != null) {
                    String string2 = DOMUtil.getLocalName(element3);
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, string2}, element3);
                }
            } else if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_COMPLEXCONTENT)) {
                this.traverseComplexContent(element2, bl2, xSDocumentInfo, schemaGrammar);
                Element element4 = DOMUtil.getNextSiblingElement(element2);
                if (element4 != null) {
                    String string3 = DOMUtil.getLocalName(element4);
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, string3}, element4);
                }
            } else {
                this.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(element2, bl2, false, xSDocumentInfo, schemaGrammar);
            }
        }
        catch (ComplexTypeRecoverableError complexTypeRecoverableError) {
            this.handleComplexTypeError(complexTypeRecoverableError.getMessage(), complexTypeRecoverableError.errorSubstText, complexTypeRecoverableError.errorElem);
        }
        this.fComplexTypeDecl.setValues(this.fName, this.fTargetNamespace, this.fBaseType, this.fDerivedBy, this.fFinal, this.fBlock, this.fContentType, this.fIsAbstract, this.fAttrGrp, this.fXSSimpleType, this.fParticle);
        return this.fComplexTypeDecl;
    }

    private void traverseSimpleContent(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) throws ComplexTypeRecoverableError {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        this.fContentType = 1;
        this.fParticle = null;
        Element element2 = DOMUtil.getFirstChildElement(element);
        if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (element2 == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.2", new Object[]{this.fName, SchemaSymbols.ELT_SIMPLECONTENT}, element);
        }
        String string = DOMUtil.getLocalName(element2);
        if (string.equals(SchemaSymbols.ELT_RESTRICTION)) {
            this.fDerivedBy = (short)2;
        } else if (string.equals(SchemaSymbols.ELT_EXTENSION)) {
            this.fDerivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, string}, element2);
        }
        Element element3 = DOMUtil.getNextSiblingElement(element2);
        if (element3 != null) {
            String string2 = DOMUtil.getLocalName(element3);
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, string2}, element3);
        }
        objectArray = this.fAttrChecker.checkAttributes(element2, false, xSDocumentInfo);
        QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_BASE];
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (qName == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.3", new Object[]{this.fName}, element2);
        }
        XSTypeDecl xSTypeDecl = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 7, qName, element2);
        if (xSTypeDecl == null) {
            throw new ComplexTypeRecoverableError();
        }
        this.fBaseType = xSTypeDecl;
        Object object = null;
        XSComplexTypeDecl xSComplexTypeDecl = null;
        short s = 0;
        if (xSTypeDecl.getTypeCategory() == 13) {
            xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDecl;
            if (xSComplexTypeDecl.getContentType() != 1) {
                throw new ComplexTypeRecoverableError("src-ct.2", new Object[]{this.fName}, element2);
            }
            s = xSComplexTypeDecl.getFinal();
            object = (XSSimpleType)xSComplexTypeDecl.getSimpleType();
        } else {
            object = (XSSimpleType)xSTypeDecl;
            if (this.fDerivedBy == 2) {
                throw new ComplexTypeRecoverableError("src-ct.2", new Object[]{this.fName}, element2);
            }
            s = object.getFinal();
        }
        if ((s & this.fDerivedBy) != 0) {
            String string3 = this.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(string3, new Object[]{this.fName}, element2);
        }
        if ((element2 = DOMUtil.getFirstChildElement(element2)) != null) {
            if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(element2, null, false, xSDocumentInfo);
                element2 = DOMUtil.getNextSiblingElement(element2);
            }
            if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, element2);
            }
        }
        if (this.fDerivedBy == 2) {
            Object object2;
            Object object3;
            if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                object3 = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(element2, xSDocumentInfo, schemaGrammar);
                if (object3 == null) {
                    throw new ComplexTypeRecoverableError();
                }
                if (!XSConstraints.checkSimpleDerivationOk((XSSimpleType)object3, (XSTypeDecl)object, object.getFinal())) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.1.1", new Object[]{this.fName}, element2);
                }
                object = object3;
                element2 = DOMUtil.getNextSiblingElement(element2);
            }
            object3 = null;
            XSFacets xSFacets = null;
            short s2 = 0;
            short s3 = 0;
            if (element2 != null) {
                object2 = this.traverseFacets(element2, (XSSimpleType)object, xSDocumentInfo);
                object3 = ((XSDAbstractTraverser.FacetInfo)object2).nodeAfterFacets;
                xSFacets = ((XSDAbstractTraverser.FacetInfo)object2).facetdata;
                s2 = ((XSDAbstractTraverser.FacetInfo)object2).fPresentFacets;
                s3 = ((XSDAbstractTraverser.FacetInfo)object2).fFixedFacets;
            }
            this.fXSSimpleType = this.schemaFactory.createTypeRestriction(null, xSDocumentInfo.fTargetNamespace, (short)0, (XSSimpleType)object);
            try {
                this.fValidationState.setNamespaceSupport(xSDocumentInfo.fNamespaceSupport);
                this.fXSSimpleType.applyFacets(xSFacets, s2, s3, this.fValidationState);
            }
            catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
                this.reportSchemaError(invalidDatatypeFacetException.getKey(), invalidDatatypeFacetException.getArgs(), element2);
            }
            if (object3 != null) {
                if (!this.isAttrOrAttrGroup((Element)object3)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName((Node)object3)}, (Element)object3);
                }
                object2 = this.traverseAttrsAndAttrGrps((Element)object3, this.fAttrGrp, xSDocumentInfo, schemaGrammar, this.fComplexTypeDecl);
                if (object2 != null) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName((Node)object2)}, (Element)object2);
                }
            }
            this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, this.fName, false, element);
            this.fAttrGrp.removeProhibitedAttrs();
            object2 = this.fAttrGrp.validRestrictionOf(xSComplexTypeDecl.getAttrGrp());
            if (object2 != null) {
                throw new ComplexTypeRecoverableError((String)object2, new Object[]{this.fName}, (Element)object3);
            }
        } else {
            this.fXSSimpleType = object;
            if (element2 != null) {
                Element element4 = element2;
                if (!this.isAttrOrAttrGroup(element4)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(element4)}, element4);
                }
                Element element5 = this.traverseAttrsAndAttrGrps(element4, this.fAttrGrp, xSDocumentInfo, schemaGrammar, this.fComplexTypeDecl);
                if (element5 != null) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(element5)}, element5);
                }
                this.fAttrGrp.removeProhibitedAttrs();
            }
            if (xSComplexTypeDecl != null) {
                this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, this.fName, true, element);
            }
        }
    }

    private void traverseComplexContent(Element element, boolean bl, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) throws ComplexTypeRecoverableError {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        boolean bl2 = bl;
        Boolean bl3 = (Boolean)objectArray[XSAttributeChecker.ATTIDX_MIXED];
        if (bl3 != null) {
            bl2 = bl3;
        }
        this.fXSSimpleType = null;
        Element element2 = DOMUtil.getFirstChildElement(element);
        if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (element2 == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.2", new Object[]{this.fName, SchemaSymbols.ELT_COMPLEXCONTENT}, element);
        }
        String string = DOMUtil.getLocalName(element2);
        if (string.equals(SchemaSymbols.ELT_RESTRICTION)) {
            this.fDerivedBy = (short)2;
        } else if (string.equals(SchemaSymbols.ELT_EXTENSION)) {
            this.fDerivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, string}, element2);
        }
        Element element3 = DOMUtil.getNextSiblingElement(element2);
        if (element3 != null) {
            String string2 = DOMUtil.getLocalName(element3);
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, string2}, element3);
        }
        objectArray = this.fAttrChecker.checkAttributes(element2, false, xSDocumentInfo);
        QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_BASE];
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        if (qName == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.3", new Object[]{this.fName}, element2);
        }
        XSTypeDecl xSTypeDecl = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 7, qName, element2);
        if (xSTypeDecl == null) {
            throw new ComplexTypeRecoverableError();
        }
        if (!(xSTypeDecl instanceof XSComplexTypeDecl)) {
            throw new ComplexTypeRecoverableError("src-ct.1", new Object[]{this.fName}, element2);
        }
        XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDecl;
        this.fBaseType = xSComplexTypeDecl;
        if ((xSComplexTypeDecl.getFinal() & this.fDerivedBy) != 0) {
            String string3 = this.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(string3, new Object[]{this.fName}, element2);
        }
        if ((element2 = DOMUtil.getFirstChildElement(element2)) != null) {
            if (DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(element2, null, false, xSDocumentInfo);
                element2 = DOMUtil.getNextSiblingElement(element2);
            }
            if (element2 != null && DOMUtil.getLocalName(element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, element2);
            }
        }
        this.processComplexContent(element2, bl2, true, xSDocumentInfo, schemaGrammar);
        XSParticleDecl xSParticleDecl = (XSParticleDecl)xSComplexTypeDecl.getParticle();
        if (this.fDerivedBy == 2) {
            if (this.fParticle != null && xSParticleDecl == null) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.3", new Object[]{this.fName}, element2);
            }
            this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, this.fName, false, element2);
            String string4 = this.fAttrGrp.validRestrictionOf(xSComplexTypeDecl.getAttrGrp());
            if (string4 != null) {
                throw new ComplexTypeRecoverableError(string4, new Object[]{this.fName}, element2);
            }
            this.fAttrGrp.removeProhibitedAttrs();
        } else {
            if (xSComplexTypeDecl.getContentType() != 0 && (xSComplexTypeDecl.getContentType() == 2 && bl2 || xSComplexTypeDecl.getContentType() == 3 && !bl2)) {
                throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.2.2.2.2.1", new Object[]{this.fName}, element2);
            }
            if (this.fParticle == null) {
                this.fParticle = xSParticleDecl;
            } else if (xSParticleDecl != null) {
                if (this.fParticle.fType == 3 && ((XSModelGroupImpl)this.fParticle.fValue).fCompositor == 103 || ((XSParticleDecl)xSComplexTypeDecl.getParticle()).fType == 3 && ((XSModelGroupImpl)((XSParticleDecl)xSComplexTypeDecl.getParticle()).fValue).fCompositor == 103) {
                    throw new ComplexTypeRecoverableError("cos-all-limited.1.2", null, element2);
                }
                XSModelGroupImpl xSModelGroupImpl = new XSModelGroupImpl();
                xSModelGroupImpl.fCompositor = (short)102;
                xSModelGroupImpl.fParticleCount = 2;
                xSModelGroupImpl.fParticles = new XSParticleDecl[2];
                xSModelGroupImpl.fParticles[0] = (XSParticleDecl)xSComplexTypeDecl.getParticle();
                xSModelGroupImpl.fParticles[1] = this.fParticle;
                XSParticleDecl xSParticleDecl2 = new XSParticleDecl();
                xSParticleDecl2.fType = (short)3;
                xSParticleDecl2.fValue = xSModelGroupImpl;
                this.fParticle = xSParticleDecl2;
            }
            this.fContentType = bl2 ? (short)3 : (this.fParticle == null ? (short)0 : (short)2);
            this.fAttrGrp.removeProhibitedAttrs();
            this.mergeAttributes(xSComplexTypeDecl.getAttrGrp(), this.fAttrGrp, this.fName, true, element2);
        }
    }

    private void mergeAttributes(XSAttributeGroupDecl xSAttributeGroupDecl, XSAttributeGroupDecl xSAttributeGroupDecl2, String string, boolean bl, Element element) throws ComplexTypeRecoverableError {
        XSObjectList xSObjectList = xSAttributeGroupDecl.getAttributeUses();
        Object var8_7 = null;
        int n = xSObjectList.getLength();
        int n2 = 0;
        while (n2 < n) {
            XSAttributeUseImpl xSAttributeUseImpl = (XSAttributeUseImpl)xSObjectList.getItem(n2);
            XSAttributeUseImpl xSAttributeUseImpl2 = xSAttributeGroupDecl2.getAttributeUse(xSAttributeUseImpl.fAttrDecl.getNamespace(), xSAttributeUseImpl.fAttrDecl.getName());
            if (xSAttributeUseImpl2 == null) {
                String string2 = xSAttributeGroupDecl2.addAttributeUse(xSAttributeUseImpl);
                if (string2 != null) {
                    throw new ComplexTypeRecoverableError("ct-props-correct.5", new Object[]{string, string2, xSAttributeUseImpl.fAttrDecl.getName()}, element);
                }
            } else if (bl) {
                throw new ComplexTypeRecoverableError("ct-props-correct.4", new Object[]{string, xSAttributeUseImpl2.fAttrDecl.getName()}, element);
            }
            ++n2;
        }
        if (bl) {
            if (xSAttributeGroupDecl2.fAttributeWC == null) {
                xSAttributeGroupDecl2.fAttributeWC = xSAttributeGroupDecl.fAttributeWC;
            } else if (xSAttributeGroupDecl.fAttributeWC != null) {
                xSAttributeGroupDecl2.fAttributeWC = xSAttributeGroupDecl2.fAttributeWC.performUnionWith(xSAttributeGroupDecl.fAttributeWC, xSAttributeGroupDecl2.fAttributeWC.fProcessContents);
            }
        }
    }

    private void processComplexContent(Element element, boolean bl, boolean bl2, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) throws ComplexTypeRecoverableError {
        Object object;
        Element element2 = null;
        XSParticleDecl xSParticleDecl = null;
        if (element != null) {
            object = DOMUtil.getLocalName(element);
            if (((String)object).equals(SchemaSymbols.ELT_GROUP)) {
                xSParticleDecl = this.fSchemaHandler.fGroupTraverser.traverseLocal(element, xSDocumentInfo, schemaGrammar);
                element2 = DOMUtil.getNextSiblingElement(element);
            } else if (((String)object).equals(SchemaSymbols.ELT_SEQUENCE)) {
                xSParticleDecl = this.traverseSequence(element, xSDocumentInfo, schemaGrammar, 0, this.fComplexTypeDecl);
                element2 = DOMUtil.getNextSiblingElement(element);
            } else if (((String)object).equals(SchemaSymbols.ELT_CHOICE)) {
                xSParticleDecl = this.traverseChoice(element, xSDocumentInfo, schemaGrammar, 0, this.fComplexTypeDecl);
                element2 = DOMUtil.getNextSiblingElement(element);
            } else if (((String)object).equals(SchemaSymbols.ELT_ALL)) {
                xSParticleDecl = this.traverseAll(element, xSDocumentInfo, schemaGrammar, 8, this.fComplexTypeDecl);
                element2 = DOMUtil.getNextSiblingElement(element);
            } else {
                element2 = element;
            }
        }
        this.fParticle = xSParticleDecl;
        this.fContentType = bl ? (short)3 : (this.fParticle == null ? (short)0 : (short)2);
        if (element2 != null) {
            if (!this.isAttrOrAttrGroup(element2)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName(element2)}, element2);
            }
            object = this.traverseAttrsAndAttrGrps(element2, this.fAttrGrp, xSDocumentInfo, schemaGrammar, this.fComplexTypeDecl);
            if (object != null) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{this.fName, DOMUtil.getLocalName((Node)object)}, (Element)object);
            }
            if (!bl2) {
                this.fAttrGrp.removeProhibitedAttrs();
            }
        }
    }

    private boolean isAttrOrAttrGroup(Element element) {
        String string = DOMUtil.getLocalName(element);
        return string.equals(SchemaSymbols.ELT_ATTRIBUTE) || string.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || string.equals(SchemaSymbols.ELT_ANYATTRIBUTE);
    }

    private void traverseSimpleContentDecl(Element element) {
    }

    private void traverseComplexContentDecl(Element element, boolean bl) {
    }

    private String genAnonTypeName(Element element) {
        Element element2 = DOMUtil.getParent(element);
        String string = "#AnonType_";
        while (element2 != null && element2 != DOMUtil.getRoot(DOMUtil.getDocument(element2))) {
            string = string + element2.getAttribute(SchemaSymbols.ATT_NAME);
            element2 = DOMUtil.getParent(element2);
        }
        return string;
    }

    private void handleComplexTypeError(String string, Object[] objectArray, Element element) {
        if (string != null) {
            this.reportSchemaError(string, objectArray, element);
        }
        this.fContentType = (short)3;
        this.fParticle = this.getErrorContent();
        this.fAttrGrp.fAttributeWC = this.getErrorWildcard();
    }

    private XSParticleDecl getErrorContent() {
        XSParticleDecl xSParticleDecl = new XSParticleDecl();
        xSParticleDecl.fType = (short)2;
        xSParticleDecl.fValue = this.getErrorWildcard();
        xSParticleDecl.fMinOccurs = 0;
        xSParticleDecl.fMaxOccurs = -1;
        XSModelGroupImpl xSModelGroupImpl = new XSModelGroupImpl();
        xSModelGroupImpl.fCompositor = (short)102;
        xSModelGroupImpl.fParticleCount = 1;
        xSModelGroupImpl.fParticles = new XSParticleDecl[1];
        xSModelGroupImpl.fParticles[0] = xSParticleDecl;
        XSParticleDecl xSParticleDecl2 = new XSParticleDecl();
        xSParticleDecl2.fType = (short)3;
        xSParticleDecl2.fValue = xSModelGroupImpl;
        return xSParticleDecl2;
    }

    private XSWildcardDecl getErrorWildcard() {
        XSWildcardDecl xSWildcardDecl = new XSWildcardDecl();
        xSWildcardDecl.fProcessContents = (short)2;
        return xSWildcardDecl;
    }

    private void contentBackup() {
        if (this.fGlobalStore == null) {
            this.fGlobalStore = new Object[10];
            this.fGlobalStorePos = 0;
        }
        if (this.fGlobalStorePos == this.fGlobalStore.length) {
            Object[] objectArray = new Object[this.fGlobalStorePos + 10];
            System.arraycopy(this.fGlobalStore, 0, objectArray, 0, this.fGlobalStorePos);
            this.fGlobalStore = objectArray;
        }
        this.fGlobalStore[this.fGlobalStorePos++] = this.fComplexTypeDecl;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fIsAbstract ? Boolean.TRUE : Boolean.FALSE;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fName;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fTargetNamespace;
        this.fGlobalStore[this.fGlobalStorePos++] = new Integer((this.fDerivedBy << 16) + this.fFinal);
        this.fGlobalStore[this.fGlobalStorePos++] = new Integer((this.fBlock << 16) + this.fContentType);
        this.fGlobalStore[this.fGlobalStorePos++] = this.fBaseType;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fAttrGrp;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fParticle;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fXSSimpleType;
    }

    private void contentRestore() {
        this.fXSSimpleType = (XSSimpleType)this.fGlobalStore[--this.fGlobalStorePos];
        this.fParticle = (XSParticleDecl)this.fGlobalStore[--this.fGlobalStorePos];
        this.fAttrGrp = (XSAttributeGroupDecl)this.fGlobalStore[--this.fGlobalStorePos];
        this.fBaseType = (XSTypeDecl)this.fGlobalStore[--this.fGlobalStorePos];
        int n = (Integer)this.fGlobalStore[--this.fGlobalStorePos];
        this.fBlock = (short)(n >> 16);
        this.fContentType = (short)n;
        n = (Integer)this.fGlobalStore[--this.fGlobalStorePos];
        this.fDerivedBy = (short)(n >> 16);
        this.fFinal = (short)n;
        this.fTargetNamespace = (String)this.fGlobalStore[--this.fGlobalStorePos];
        this.fName = (String)this.fGlobalStore[--this.fGlobalStorePos];
        this.fIsAbstract = (Boolean)this.fGlobalStore[--this.fGlobalStorePos];
        this.fComplexTypeDecl = (XSComplexTypeDecl)this.fGlobalStore[--this.fGlobalStorePos];
    }

    private class ComplexTypeRecoverableError
    extends Exception {
        Object[] errorSubstText = null;
        Element errorElem = null;

        ComplexTypeRecoverableError() {
        }

        ComplexTypeRecoverableError(String string, Object[] objectArray, Element element) {
            super(string);
            this.errorSubstText = objectArray;
            this.errorElem = element;
        }
    }
}

