/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

abstract class BlockStatementPrinter
extends AbstractPrinter {
    protected BlockStatementPrinter() {
    }

    public void print(AST node, NodeWriter out) throws IOException {
        if (out.last == 26 && !settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LABEL, true) && ((JavaNode)node).hasCommentsBefore()) {
            out.printNewline();
        }
        this.printCommentsBefore(node, out);
    }

    JavaNode printExpressionList(AST lparen, boolean insertBraces, NodeWriter out) throws IOException {
        JavaNode rparen;
        AST body;
        PrinterFactory.create(lparen).print(lparen, out);
        Marker marker = out.state.markers.add();
        TestNodeWriter tester = null;
        AST expr = lparen.getNextSibling();
        boolean wrapped = false;
        if (out.mode == 1) {
            ParenthesesScope scope = new ParenthesesScope(out.state.paramLevel);
            out.state.expressionList = true;
            ++out.state.paramLevel;
            out.state.parenScope.addFirst(scope);
            int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
            if (settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, false)) {
                if (!out.newline) {
                    tester = out.testers.get();
                    PrinterFactory.create(expr).print(expr, tester);
                    if (out.column + tester.length > lineLength) {
                        out.printNewline();
                        this.printIndentation(out);
                        wrapped = true;
                        if (settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false)) {
                            scope.wrap = true;
                        }
                    }
                    out.testers.release(tester);
                } else {
                    this.printIndentation(out);
                    wrapped = true;
                    if (settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false)) {
                        scope.wrap = true;
                    }
                }
                tester = out.testers.get();
                PrinterFactory.create(expr).print(expr, tester);
            }
            if (tester == null) {
                tester = out.testers.get();
                PrinterFactory.create(expr).print(expr, tester);
            }
            if (!wrapped && tester.length + out.column > lineLength) {
                if (settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false)) {
                    scope.wrap = true;
                }
                wrapped = true;
            }
            out.testers.release(tester);
        }
        out.continuation = settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_BLOCK, true);
        PrinterFactory.create(expr).print(expr, out);
        out.continuation = false;
        out.state.wrap = false;
        if (wrapped && settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_RIGHT_PAREN, false)) {
            if (!out.newline) {
                out.printNewline();
            }
            if (settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                this.printIndentation(-1, out);
            } else {
                out.print(AbstractPrinter.EMPTY_STRING, 153);
            }
        }
        boolean hasBraces = (body = (rparen = (JavaNode)expr.getNextSibling()).getNextSibling()).getType() == 11;
        boolean leftBraceNewline = settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false);
        Object pendingComment = null;
        if (!hasBraces && insertBraces && !leftBraceNewline) {
            out.pendingComment = rparen.getCommentAfter();
            if (out.pendingComment != null) {
                rparen.setHiddenAfter(null);
            }
        }
        PrinterFactory.create(rparen).print(rparen, out);
        if (out.mode == 1) {
            out.state.expressionList = false;
            --out.state.paramLevel;
            out.state.parenScope.removeFirst();
        }
        out.state.markers.remove(marker);
        return rparen;
    }
}

