/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.command.Command;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.taskmgmt.exe.TaskInstance;

public abstract class AbstractGetObjectBaseCommand
implements Command {
    static final Log log = LogFactory.getLog((Class)AbstractGetObjectBaseCommand.class);
    private boolean includeAllVariables = true;
    private String[] variablesToInclude = new String[0];
    private boolean includeLogs = true;

    public AbstractGetObjectBaseCommand() {
    }

    public AbstractGetObjectBaseCommand(boolean includeAllVariables, boolean includeLogs) {
        this.includeAllVariables = includeAllVariables;
    }

    public AbstractGetObjectBaseCommand(String[] variablesToInclude) {
        this.variablesToInclude = variablesToInclude;
    }

    public void retrieveTaskInstanceDetails(TaskInstance ti) {
        try {
            ti.getToken().getProcessInstance().getProcessDefinition().getName();
            ti.setProcessInstance(ti.getToken().getProcessInstance());
            ti.getToken().getNode().getName();
            ti.getTask().getName();
            ti.getAvailableTransitions();
            this.retrieveVariables(ti);
        }
        catch (Exception ex) {
            log.warn((Object)("exception while retrieving task instance data for task instance " + ti.getId()), (Throwable)ex);
        }
    }

    public ProcessInstance retrieveProcessInstance(ProcessInstance pi) {
        try {
            pi.getProcessDefinition().getName();
            this.retrieveToken(pi.getRootToken());
            this.retrieveVariables(pi);
            if (this.includeLogs) {
                this.retrieveLogs(pi);
            }
        }
        catch (Exception ex) {
            log.warn((Object)("exception while retrieving process instance data for process instance " + pi), (Throwable)ex);
        }
        return pi;
    }

    protected void retrieveToken(Token t) {
        t.getNode().getName();
        t.getAvailableTransitions();
        Iterator iter = t.getChildren().values().iterator();
        while (iter.hasNext()) {
            this.retrieveToken((Token)iter.next());
        }
    }

    public void retrieveVariables(ProcessInstance pi) {
        if (this.includeAllVariables) {
            pi.getContextInstance().getVariables();
        } else {
            for (int i = 0; i < this.variablesToInclude.length; ++i) {
                pi.getContextInstance().getVariable(this.variablesToInclude[i]);
            }
        }
    }

    public void retrieveVariables(TaskInstance ti) {
        if (this.includeAllVariables) {
            ti.getContextInstance().getVariables();
        } else {
            for (int i = 0; i < this.variablesToInclude.length; ++i) {
                ti.getVariable(this.variablesToInclude[i]);
            }
        }
    }

    protected void retrieveLogs(ProcessInstance pi) {
        Iterator iter = pi.getLoggingInstance().getLogs().iterator();
        while (iter.hasNext()) {
            ProcessLog pl = (ProcessLog)iter.next();
            pl.getToken().getId();
        }
    }

    public boolean isIncludeAllVariables() {
        return this.includeAllVariables;
    }

    public void setIncludeAllVariables(boolean includeAllVariables) {
        this.includeAllVariables = includeAllVariables;
    }

    public String[] getVariablesToInclude() {
        return this.variablesToInclude;
    }

    public void setVariablesToInclude(String[] variablesToInclude) {
        this.variablesToInclude = variablesToInclude;
    }

    public void setVariablesToInclude(String variableToInclude) {
        this.variablesToInclude = new String[]{variableToInclude};
    }

    public boolean isIncludeLogs() {
        return this.includeLogs;
    }

    public void setIncludeLogs(boolean includeLogs) {
        this.includeLogs = includeLogs;
    }
}

