/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.FetchInfo;
import com.sap.dbtech.jdbc.ParameterMetaDataSapDB;
import com.sap.dbtech.jdbc.Parseinfo;
import com.sap.dbtech.jdbc.ParseinfoCache;
import com.sap.dbtech.jdbc.ResultSetMetaDataSapDB;
import com.sap.dbtech.jdbc.ResultSetSapDB;
import com.sap.dbtech.jdbc.StatementSapDB;
import com.sap.dbtech.jdbc.exceptions.BatchUpdateExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.InternalJDBCError;
import com.sap.dbtech.jdbc.exceptions.InvalidColumnException;
import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.NotImplemented;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.TimeoutException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.vsp001.PartKind;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class CallableStatementSapDB
extends StatementSapDB
implements CallableStatement,
SQLParamController {
    Parseinfo parseinfo;
    boolean lastWasNull;
    StructuredMem replyMem;
    protected Object[] inputArgs;
    Vector inputLongs;
    Vector batchRows;
    short[] outPutTypes;
    byte[] outPutScale;
    FetchInfo fetchInfo;
    AbstractMap columnMap;
    private final String initialParamValue = "initParam";

    CallableStatementSapDB(ConnectionSapDB connectionSapDB, String string) throws SQLException {
        super(connectionSapDB);
        this.constructor(string);
    }

    CallableStatementSapDB(ConnectionSapDB connectionSapDB, String string, int n, int n2, int n3) throws SQLException {
        super(connectionSapDB, n, n2, n3);
        this.constructor(string);
    }

    public void addBatch() throws SQLException {
        if (this.batchItems == null) {
            this.batchItems = new Vector();
        }
        this.batchItems.addElement(this.inputArgs);
        Object[] objectArray = new Object[this.parseinfo.paramInfos.length];
        int n = 0;
        while (n < this.parseinfo.paramInfos.length) {
            objectArray[n] = this.inputArgs[n];
            ++n;
        }
        this.inputArgs = objectArray;
    }

    public void addBatch(String string) throws SQLException {
        throw new JDBCDriverException(MessageTranslator.translate("error.addbatch.preparedstatement"), this);
    }

    private int calculateInputRecord() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.parseinfo.paramInfos.length) {
            DBTechTranslator dBTechTranslator = this.parseinfo.paramInfos[n2];
            if (dBTechTranslator.isInput()) {
                int n3 = dBTechTranslator.getPhysicalLength() + dBTechTranslator.getBufpos() - 1;
                n = Math.max(n, n3);
            }
            ++n2;
        }
        return n;
    }

    public void clearParameters() throws SQLException {
        int n = 0;
        while (n < this.inputArgs.length) {
            this.inputArgs[n] = "initParam";
            ++n;
        }
    }

    private void constructor(String string) throws SQLException {
        this.parseinfo = this.doParse(string, false);
    }

    private Parseinfo doParse(String string, boolean bl) throws SQLException {
        if (string == null) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.null"), "42000");
        }
        Parseinfo parseinfo = null;
        ParseinfoCache parseinfoCache = this.connection.parseCache;
        String[] stringArray = null;
        if (string == null) {
            throw new SQLExceptionSapDB("SQL statement is null", "42000");
        }
        this.fetchInfo = null;
        if (bl) {
            parseinfo = this.parseinfo;
            parseinfo.setMassParseid(null);
        } else if (parseinfoCache != null) {
            parseinfo = parseinfoCache.findParseinfo(string);
        }
        if (parseinfo == null || bl) {
            ReplyPacket replyPacket;
            try {
                this.setWithInfo = false;
                replyPacket = this.sendSQL(string, this.resultSetType, this.resultSetConcurrency);
            }
            catch (TimeoutException timeoutException) {
                replyPacket = this.sendSQL(string, this.resultSetType, this.resultSetConcurrency);
            }
            if (!bl) {
                parseinfo = new Parseinfo(this.connection, string, replyPacket.functionCode());
            }
            PartEnumeration partEnumeration = replyPacket.partEnumeration();
            DBTechTranslator[] dBTechTranslatorArray = null;
            block9: while (partEnumeration.hasMoreElements()) {
                partEnumeration.nextElement();
                switch (partEnumeration.partKind()) {
                    case 10: {
                        int n = replyPacket.getPartDataPos();
                        parseinfo.setParseIdAndSession(replyPacket.getBytes(n, 12), replyPacket.getInt4(n));
                        break;
                    }
                    case 14: {
                        dBTechTranslatorArray = replyPacket.parseShortFields();
                        break;
                    }
                    case 13: {
                        parseinfo.setSelect(true);
                        int n = replyPacket.partLength();
                        if (n <= 0) continue block9;
                        this.cursorName = replyPacket.getString(replyPacket.getPartDataPos(), n);
                        break;
                    }
                    case 19: {
                        parseinfo.setUpdateTableName(replyPacket.getString(replyPacket.getPartDataPos(), replyPacket.partLength()));
                        break;
                    }
                    case 2: {
                        stringArray = replyPacket.parseColumnNames();
                        break;
                    }
                    default: {
                        this.addWarning(new SQLWarning(MessageTranslator.translate("warning.part.nothandled", PartKind.names[partEnumeration.partKind()])));
                    }
                }
            }
            parseinfo.setShortInfosAndColumnNames(dBTechTranslatorArray, stringArray);
            if (parseinfoCache != null && !bl) {
                parseinfoCache.addParseinfo(parseinfo);
            }
        }
        this.inputArgs = new Object[parseinfo.paramInfos.length];
        this.clearParameters();
        return parseinfo;
    }

    public boolean execute() throws SQLException {
        this.assertOpen();
        return this.execute(false);
    }

    private void reparse() throws SQLException {
        Object[] objectArray = this.inputArgs;
        this.doParse(this.parseinfo.sqlCmd, true);
        this.inputArgs = objectArray;
    }

    protected String getUpdTablename(String string) {
        return this.parseinfo.updTableName;
    }

    public boolean execute(boolean bl) throws SQLException {
        if (this.connection == null) {
            throw new InternalJDBCError(MessageTranslator.translate("error.internal.connectionnull"));
        }
        boolean bl2 = this.connection.isInTransaction();
        if (this.parseinfo.isAlreadyExecuted()) {
            this.replyMem = null;
            this.closeResultSet();
            if (this.connection == null) {
                throw new NullPointerException();
            }
            this.reparse();
            this.rowsAffected = 0;
            return false;
        }
        if (!this.parseinfo.isValid()) {
            this.reparse();
        }
        try {
            ReplyPacket replyPacket;
            int n;
            if (!this.parseinfo.isValid()) {
                this.reparse();
            }
            this.closeResultSet();
            this.replyMem = null;
            RequestPacket requestPacket = this.connection.getRequestPacket();
            requestPacket.initExecute(this.parseinfo.getParseId(), this.connection.autocommit);
            if (this.parseinfo.isSelect) {
                requestPacket.addCursorPart(this.cursorName);
            }
            if (this.parseinfo.inputCount > 0) {
                DataPart dataPart = requestPacket.newDataPart();
                n = 0;
                while (n < this.parseinfo.paramInfos.length) {
                    if (this.parseinfo.paramInfos[n].isInput() && "initParam" == this.inputArgs[n]) {
                        throw new SQLException(MessageTranslator.translate("error.missinginout", Integer.toString(n + 1)), "02000");
                    }
                    this.parseinfo.paramInfos[n].put(dataPart, this.inputArgs[n]);
                    ++n;
                }
                if (this.parseinfo.hasLongs) {
                    this.handleStreamsForExecute(dataPart, this.inputArgs);
                }
                dataPart.close();
            }
            if (this.parseinfo.isSelect && this.parseinfo.columnInfos == null && this.parseinfo.functionCode != 248) {
                requestPacket.initDbsCommand("DESCRIBE ", false, false);
                requestPacket.addParseidPart(this.parseinfo.getParseId());
            }
            try {
                replyPacket = this.connection.execute(requestPacket, this, true);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -8 && !bl) {
                    this.reparse();
                    this.resetPutvals(this.inputLongs);
                    return this.execute(true);
                }
                throw sQLException;
            }
            boolean bl3 = this.parseResult(replyPacket, null, this.parseinfo.getColumnInfos(), this.parseinfo.columnNames);
            if (!bl3) {
                n = replyPacket.returnCode();
                if (replyPacket.existsPart(5)) {
                    this.replyMem = replyPacket.getPointer(replyPacket.getPartDataPos());
                }
                if (this.parseinfo.hasLongs && n == 0) {
                    this.handleStreamsForPutval(replyPacket);
                }
            }
            return bl3;
        }
        catch (TimeoutException timeoutException) {
            if (this.connection.isInTransaction()) {
                throw timeoutException;
            }
            this.closeResultSet();
            this.reparse();
            this.resetPutvals(this.inputLongs);
            return this.execute(true);
        }
    }

    public boolean execute(String string) throws SQLException {
        return this.execute();
    }

    private void dumpInput(String string) {
        System.out.println(string);
        int n = 0;
        while (n < this.inputArgs.length) {
            System.out.println("inputArgs [" + n + "]: " + this.inputArgs[n]);
            ++n;
        }
    }

    public int[] executeBatch() throws SQLException {
        this.assertOpen();
        if (this.parseinfo != null && this.parseinfo.isSelect) {
            throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchresultset"), new int[0]);
        }
        if (this.parseinfo != null && (this.parseinfo.functionCode == 34 || this.parseinfo.functionCode == 248)) {
            int n = 0;
            while (n < this.parseinfo.paramInfos.length) {
                if (this.parseinfo.paramInfos[n].isOutput()) {
                    throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchprocout"), new int[0]);
                }
                ++n;
            }
        }
        if (this.batchItems == null) {
            return new int[0];
        }
        Vector vector = null;
        boolean bl = this.connection.isInTransaction();
        Vector vector2 = this.batchItems;
        this.batchItems = null;
        try {
            int n = vector2.size();
            ReplyPacket replyPacket = null;
            int n2 = 0;
            boolean bl2 = false;
            boolean bl3 = true;
            int n3 = 0;
            int n4 = RequestPacket.resultCountPartSize();
            int n5 = -1;
            int[] nArray = new int[n];
            this.rowsAffected = -1;
            int n6 = 0;
            while (n6 < nArray.length) {
                nArray[n6] = -2;
                ++n6;
            }
            if (this.parseinfo.getMassParseid() == null) {
                this.parseMassCmd();
            }
            if (this.parseinfo.paramInfos.length > 0) {
                n3 = this.calculateInputRecord();
            }
            while (n2 < n && bl3) {
                vector = null;
                int n7 = n2;
                RequestPacket requestPacket = this.connection.getRequestPacket();
                requestPacket.initExecute(this.parseinfo.getMassParseid(), this.connection.autocommit);
                if (n5 == -1) {
                    requestPacket.addUndefResultCount();
                } else {
                    requestPacket.addResultCount(n5);
                }
                requestPacket.addCursorPart(this.cursorName);
                if (this.parseinfo.paramInfos.length > 0) {
                    DataPart dataPart = requestPacket.newDataPart();
                    if (n5 == -1) {
                        dataPart.setFirstPart();
                    }
                    do {
                        Object[] objectArray = (Object[])vector2.elementAt(n2);
                        int n8 = 0;
                        while (n8 < this.parseinfo.paramInfos.length) {
                            if (this.parseinfo.paramInfos[n8].isInput() && "initParam" == objectArray[n8]) {
                                throw new BatchUpdateExceptionSapDB(MessageTranslator.translate("error.batchmissingin", Integer.toString(n2), Integer.toString(n8 + 1)), "0200", this.makeBatchCountArray(nArray));
                            }
                            this.parseinfo.paramInfos[n8].put(dataPart, objectArray[n8]);
                            ++n8;
                        }
                        if (this.parseinfo.hasLongs) {
                            this.handleStreamsForExecute(dataPart, objectArray);
                            if (vector == null) {
                                vector = new Vector(this.inputLongs.size());
                            }
                            vector.addAll(this.inputLongs);
                        }
                        dataPart.moveRecordBase();
                    } while (++n2 < n && dataPart.hasRoomFor(n3, n4) && this.parseinfo.isMassCmd());
                    if (n2 == n) {
                        dataPart.setLastPart();
                    }
                    dataPart.closeArrayPart(n2 - n7);
                } else {
                    ++n2;
                }
                try {
                    replyPacket = this.connection.execute(requestPacket, this, false);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == -8) {
                        this.resetPutvals(vector);
                        this.parseMassCmd();
                        n2 = n7;
                        continue;
                    }
                    SQLExceptionSapDB sQLExceptionSapDB = (SQLExceptionSapDB)sQLException;
                    if (!this.connection.getAutoCommit()) {
                        this.rowsAffected = this.rowsAffected > 0 ? (this.rowsAffected += sQLExceptionSapDB.getErrorPos() - 1) : sQLExceptionSapDB.getErrorPos() - 1;
                    }
                    throw new BatchUpdateExceptionSapDB(sQLException, this.makeBatchCountArray(nArray));
                }
                n5 = replyPacket.resultCount(false);
                if (this.parseinfo.hasLongs) {
                    this.handleStreamsForPutval(replyPacket);
                }
                if (!this.parseinfo.isMassCmd() && n5 != -1) {
                    nArray[n2 - 1] = n5;
                }
                this.rowsAffected = n5;
            }
            return nArray;
        }
        catch (TimeoutException timeoutException) {
            if (bl) {
                throw timeoutException;
            }
            this.batchItems = vector2;
            this.resetPutvals(vector);
            return this.executeBatch();
        }
    }

    private int[] makeBatchCountArray(int[] nArray) {
        int[] nArray2;
        if (this.rowsAffected > 0) {
            nArray2 = new int[this.rowsAffected];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        } else {
            nArray2 = new int[]{};
        }
        return nArray2;
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.parseinfo != null && !this.parseinfo.isSelect) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.rowcount"));
        }
        this.execute();
        return this.currentResultSet;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.executequery.preparedstatement"));
    }

    public ResultSetSapDB executeQuerySap() throws SQLException {
        if (this.parseinfo != null && !this.parseinfo.isSelect) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.rowcount"));
        }
        return (ResultSetSapDB)this.currentResultSet;
    }

    public int executeUpdate() throws SQLException {
        if (this.parseinfo != null && this.parseinfo.isSelect) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.resultset"));
        }
        this.execute();
        return this.rowsAffected;
    }

    public int executeUpdate(String string) throws SQLException {
        throw new SQLExceptionSapDB(MessageTranslator.translate("error.executeupdate.preparedstatement"));
    }

    private DBTechTranslator findColInfo(int n) throws SQLException {
        DBTechTranslator dBTechTranslator;
        try {
            dBTechTranslator = this.parseinfo.paramInfos[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new JDBCDriverException(MessageTranslator.translate("error.colindex.notfound", Integer.toString(n)), this);
        }
        return dBTechTranslator;
    }

    private DBTechTranslator findParamInfo(String string) throws SQLException {
        DBTechTranslator dBTechTranslator;
        if (!this.parseinfo.isDBProc) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.sqlstatement.noprocedure"));
        }
        if (this.columnMap == null) {
            this.columnMap = this.parseinfo.getColumnMap();
        }
        if ((dBTechTranslator = (DBTechTranslator)this.columnMap.get(string)) == null && (dBTechTranslator = (DBTechTranslator)this.columnMap.get(string.toUpperCase())) != null) {
            this.columnMap.put(string, dBTechTranslator);
        }
        if (dBTechTranslator == null) {
            throw new InvalidColumnException(string, (Object)this);
        }
        return dBTechTranslator;
    }

    public Array getArray(int n) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.array.unsupported"));
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.findColInfo(n).getBigDecimal(this, this.replyMem);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.findColInfo(n).getBigDecimal(n2, this, this.replyMem);
    }

    public Blob getBlob(int n) throws SQLException {
        return this.findColInfo(n).getBlob(this, this.replyMem, this.replyMem);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.findColInfo(n).getBoolean(this, this.replyMem);
    }

    public byte getByte(int n) throws SQLException {
        return this.findColInfo(n).getByte(this, this.replyMem);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.findColInfo(n).getBytes(this, this.replyMem);
    }

    public Clob getClob(int n) throws SQLException {
        return this.findColInfo(n).getClob(this, this.replyMem, this.replyMem);
    }

    public Date getDate(int n) throws SQLException {
        return this.findColInfo(n).getDate(this, this.replyMem);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        try {
            return new Date(simpleDateFormat.parse(string).getTime());
        }
        catch (ParseException parseException) {
            throw new SQLExceptionSapDB(parseException.getMessage());
        }
    }

    public double getDouble(int n) throws SQLException {
        return this.findColInfo(n).getDouble(this, this.replyMem);
    }

    public float getFloat(int n) throws SQLException {
        return this.findColInfo(n).getFloat(this, this.replyMem);
    }

    Object getInputParameter(int n) {
        return this.inputArgs[n - 1];
    }

    public int getInt(int n) throws SQLException {
        return this.findColInfo(n).getInt(this, this.replyMem);
    }

    public long getLong(int n) throws SQLException {
        return this.findColInfo(n).getLong(this, this.replyMem);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.fetchInfo == null) {
            if (this.parseinfo == null) {
                return null;
            }
            if (!this.parseinfo.isSelect && this.parseinfo.functionCode != 4) {
                return null;
            }
            DBTechTranslator[] dBTechTranslatorArray = this.parseinfo.getColumnInfos();
            if (dBTechTranslatorArray != null) {
                return new ResultSetMetaDataSapDB(dBTechTranslatorArray);
            }
            try {
                this.parseinfo.doDescribeParseId();
            }
            catch (Exception exception) {
                return null;
            }
            return new ResultSetMetaDataSapDB(this.getFetchInfo(this.cursorName, this.parseinfo.getColumnInfos(), this.parseinfo.columnNames).getColInfo());
        }
        return new ResultSetMetaDataSapDB(this.fetchInfo.getColInfo());
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        DBTechTranslator dBTechTranslator = this.findColInfo(n);
        if (this.outPutTypes == null) {
            boolean bl = false;
        } else {
            short s = this.outPutTypes[n];
        }
        switch (this.outPutTypes[n]) {
            case -7: {
                if (dBTechTranslator.isNull(this, this.replyMem)) break;
                object = new Boolean(dBTechTranslator.getBoolean(this, this.replyMem));
                break;
            }
            case -6: {
                if (dBTechTranslator.isNull(this, this.replyMem)) break;
                object = new Byte(dBTechTranslator.getByte(this, this.replyMem));
                break;
            }
            case 5: {
                if (dBTechTranslator.isNull(this, this.replyMem)) break;
                object = new Short(dBTechTranslator.getShort(this, this.replyMem));
                break;
            }
            case 4: {
                if (dBTechTranslator.isNull(this, this.replyMem)) break;
                object = new Integer(dBTechTranslator.getInt(this, this.replyMem));
                break;
            }
            case -5: {
                if (dBTechTranslator.isNull(this, this.replyMem)) break;
                object = new Long(dBTechTranslator.getLong(this, this.replyMem));
                break;
            }
            case 7: {
                if (dBTechTranslator.isNull(this, this.replyMem)) break;
                object = new Float(dBTechTranslator.getFloat(this, this.replyMem));
                break;
            }
            case 6: {
                if (dBTechTranslator.isNull(this, this.replyMem)) break;
                object = new Float(dBTechTranslator.getFloat(this, this.replyMem));
                break;
            }
            case 8: {
                if (dBTechTranslator.isNull(this, this.replyMem)) break;
                object = new Double(dBTechTranslator.getDouble(this, this.replyMem));
                break;
            }
            case 2: 
            case 3: {
                byte by = this.outPutScale[n];
                if (by == -1) {
                    object = dBTechTranslator.getBigDecimal(this, this.replyMem);
                    break;
                }
                object = dBTechTranslator.getBigDecimal(by, this, this.replyMem);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                object = dBTechTranslator.getString(this, this.replyMem);
                break;
            }
            case 91: {
                object = dBTechTranslator.getDate(this, this.replyMem);
                break;
            }
            case 92: {
                object = dBTechTranslator.getTime(this, this.replyMem);
                break;
            }
            case 93: {
                object = dBTechTranslator.getTimestamp(this, this.replyMem);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = dBTechTranslator.getBytes(this, this.replyMem);
                break;
            }
            case 2004: {
                object = dBTechTranslator.getBlob(this, this.replyMem, this.replyMem);
                break;
            }
            case 2005: {
                object = dBTechTranslator.getClob(this, this.replyMem, this.replyMem);
                break;
            }
            default: {
                object = dBTechTranslator.getObject(this, this.replyMem);
            }
        }
        return object;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new NotImplemented(MessageTranslator.translate("error.getobject.notimplemented"));
    }

    public Ref getRef(int n) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.ref.unsupported"));
        return null;
    }

    public StructuredMem getReplyData() {
        return this.replyMem;
    }

    public short getShort(int n) throws SQLException {
        return this.findColInfo(n).getShort(this, this.replyMem);
    }

    public String getString(int n) throws SQLException {
        return this.findColInfo(n).getString(this, this.replyMem);
    }

    public Time getTime(int n) throws SQLException {
        return this.findColInfo(n).getTime(this, this.replyMem);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSSS");
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        try {
            return new Time(simpleDateFormat.parse(string).getTime());
        }
        catch (ParseException parseException) {
            throw new SQLExceptionSapDB(parseException.getMessage());
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.findColInfo(n).getTimestamp(this, this.replyMem);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        try {
            return new Timestamp(simpleDateFormat.parse(string).getTime());
        }
        catch (ParseException parseException) {
            throw new SQLExceptionSapDB(parseException.getMessage());
        }
    }

    private void handleStreamsForExecute(DataPart dataPart, Object[] objectArray) throws SQLException {
        Putval putval;
        this.inputLongs = new Vector();
        int n = 0;
        while (n < this.parseinfo.paramInfos.length) {
            Object object = objectArray[n];
            if (object != null) {
                try {
                    putval = (Putval)object;
                    this.inputLongs.addElement(putval);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            ++n;
        }
        Enumeration enumeration = this.inputLongs.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            putval = (Putval)enumeration.nextElement();
            putval.transferStream(dataPart, n);
            ++n;
        }
    }

    private void getChangedPutvalDescriptors(ReplyPacket replyPacket) {
        byte[][] byArray = replyPacket.parseLongDescriptors();
        if (!replyPacket.existsPart(18)) {
            return;
        }
        int n = 0;
        while (n < byArray.length) {
            byte[] byArray2 = byArray[n];
            StructuredBytes structuredBytes = new StructuredBytes(byArray2);
            int n2 = structuredBytes.getInt2(28);
            Putval putval = (Putval)this.inputLongs.elementAt(n2);
            putval.setDescriptor(byArray2);
            ++n;
        }
    }

    private void handleStreamsForPutval(ReplyPacket replyPacket) throws SQLException {
        if (this.inputLongs.size() == 0) {
            return;
        }
        Putval putval = (Putval)this.inputLongs.lastElement();
        int n = 0;
        int n2 = this.inputLongs.size();
        boolean bl = false;
        while (!putval.atEnd()) {
            this.getChangedPutvalDescriptors(replyPacket);
            RequestPacket requestPacket = this.connection.getRequestPacket();
            DataPart dataPart = requestPacket.initPutval(this.connection.autocommit);
            int n3 = n;
            while (n3 < n2 && dataPart.hasRoomFor(41)) {
                Putval putval2 = (Putval)this.inputLongs.elementAt(n3);
                if (putval2.atEnd()) {
                    ++n;
                } else {
                    int n4 = dataPart.getExtent() + 1;
                    putval2.putDescriptor(dataPart, n4);
                    dataPart.addArg(n4, 41);
                    putval2.transferStream(dataPart, n3);
                    if (putval2.atEnd()) {
                        ++n;
                    }
                }
                ++n3;
            }
            if (putval.atEnd()) {
                try {
                    putval.markAsLast(dataPart);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    bl = true;
                }
            }
            dataPart.close();
            replyPacket = this.connection.execute(requestPacket, this, false);
            if (!bl) continue;
            requestPacket = this.connection.getRequestPacket();
            dataPart = requestPacket.initPutval(this.connection.autocommit);
            putval.markAsLast(dataPart);
            dataPart.close();
            this.connection.execute(requestPacket, this, false);
        }
    }

    private void parseMassCmd() throws SQLException {
        RequestPacket requestPacket = this.connection.getRequestPacket();
        requestPacket.initParseCommand(this.parseinfo.sqlCmd);
        requestPacket.setMassCommand();
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, true);
        if (replyPacket.existsPart(10)) {
            this.parseinfo.setMassParseid(replyPacket.getBytes(replyPacket.getPartDataPos(), 12));
        }
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, -1);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        if (this.outPutTypes == null) {
            this.outPutTypes = new short[this.parseinfo.paramInfos.length + 1];
            this.outPutScale = new byte[this.parseinfo.paramInfos.length + 1];
        }
        this.outPutTypes[n] = (short)n2;
        this.outPutScale[n] = (byte)n3;
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n, n2, -1);
    }

    ReplyPacket sendCommand(RequestPacket requestPacket, String string, boolean bl) throws SQLException {
        requestPacket.initParseCommand(string);
        if (this.setWithInfo) {
            requestPacket.setWithInfo();
        }
        ReplyPacket replyPacket = this.connection.execute(requestPacket, false, true, this, bl);
        return replyPacket;
    }

    public void setArray(int n, Array array) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.array.unsupported"));
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transAsciiStreamForInput(inputStream, n2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transBigDecimalForInput(bigDecimal);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transBinaryStreamForInput(inputStream, n2);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transBlobForInput(blob);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transBooleanForInput(bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transByteForInput(by);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transBytesForInput(byArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transCharacterStreamForInput(reader, n2);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transClobForInput(clob);
    }

    public void setDate(int n, Date date) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transDateForInput(date);
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setDate(n, date);
        } else {
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            this.setString(n, simpleDateFormat.format(date));
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transDoubleForInput(d);
    }

    public void setFloat(int n, float f) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transFloatForInput(f);
    }

    public void setInt(int n, int n2) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transIntForInput(n2);
    }

    public void setLastWasNull(boolean bl) {
        this.lastWasNull = bl;
    }

    public void setLong(int n, long l) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transLongForInput(l);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.inputArgs[n - 1] = null;
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    public void setObject(int n, Object object) throws SQLException {
        Object object2;
        this.inputArgs[n - 1] = object2 = this.findColInfo(n).transObjectForInput(object);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        switch (n2) {
            case 4: {
                if (object instanceof Number) {
                    Number number = (Number)object;
                    this.setInt(n, number.intValue());
                    return;
                }
            }
            case -5: {
                if (!(object instanceof Number)) break;
                Number number = (Number)object;
                this.setLong(n, number.longValue());
                return;
            }
        }
        this.setObject(n, object);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n3);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.ref.unsupported"));
    }

    public void setShort(int n, short s) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transShortForInput(s);
    }

    public void setString(int n, String string) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = string != null && this.connection.isSQLModeOracle && string.equalsIgnoreCase("") ? null : (object = this.findColInfo(n).transStringForInput(string));
    }

    public void setTime(int n, Time time) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transTimeForInput(time);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            this.setTime(n, time);
        } else {
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSSS");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            this.setString(n, simpleDateFormat.format(time));
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transTimestampForInput(timestamp);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            this.setTimestamp(n, null);
        } else {
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            this.setString(n, simpleDateFormat.format(timestamp));
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object;
        this.inputArgs[n - 1] = object = this.findColInfo(n).transUnicodeStreamForInput(inputStream);
    }

    public boolean wasNull() throws SQLException {
        return this.lastWasNull;
    }

    protected FetchInfo getFetchInfo(String string, DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        if (this.fetchInfo == null) {
            this.fetchInfo = new FetchInfo(this.connection, string, dBTechTranslatorArray, stringArray);
        } else if (!this.fetchInfo.getCursorName().equals(string)) {
            this.fetchInfo = new FetchInfo(this.connection, string, dBTechTranslatorArray, stringArray);
        }
        return this.fetchInfo;
    }

    protected void updateFetchInfo(DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        this.parseinfo.setMetaData(dBTechTranslatorArray, stringArray);
    }

    public void close() throws SQLException {
        if (this.connection != null && !this.parseinfo.cached) {
            this.connection.dropParseid(this.parseinfo.getParseId());
            this.parseinfo.setParseIdAndSession(null, -1);
            this.connection.dropParseid(this.parseinfo.getMassParseid());
            this.parseinfo.setMassParseid(null);
        }
        super.close();
    }

    protected void resetPutvals(Vector vector) {
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Putval putval = (Putval)enumeration.nextElement();
                putval.reset();
            }
        }
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(string, n, -1);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.registerOutParameter(this.findParamInfo(string).getColIndex() + 1, n, n2);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.registerOutParameter(string, n, -1);
    }

    public URL getURL(int n) throws SQLException {
        this.throwNotSupported("Type URL");
        return null;
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.throwNotSupported("Type URL");
    }

    public void setNull(String string, int n) throws SQLException {
        this.setNull(this.findParamInfo(string).getColIndex() + 1, n);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.findParamInfo(string).getColIndex() + 1, bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        this.setByte(this.findParamInfo(string).getColIndex() + 1, by);
    }

    public void setShort(String string, short s) throws SQLException {
        this.setShort(this.findParamInfo(string).getColIndex() + 1, s);
    }

    public void setInt(String string, int n) throws SQLException {
        this.setInt(this.findParamInfo(string).getColIndex() + 1, n);
    }

    public void setLong(String string, long l) throws SQLException {
        this.setLong(this.findParamInfo(string).getColIndex() + 1, l);
    }

    public void setFloat(String string, float f) throws SQLException {
        this.setFloat(this.findParamInfo(string).getColIndex() + 1, f);
    }

    public void setDouble(String string, double d) throws SQLException {
        this.setDouble(this.findParamInfo(string).getColIndex() + 1, d);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.findParamInfo(string).getColIndex() + 1, bigDecimal);
    }

    public void setString(String string, String string2) throws SQLException {
        this.setString(this.findParamInfo(string).getColIndex() + 1, string2);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.findParamInfo(string).getColIndex() + 1, byArray);
    }

    public void setDate(String string, Date date) throws SQLException {
        this.setDate(this.findParamInfo(string).getColIndex() + 1, date);
    }

    public void setTime(String string, Time time) throws SQLException {
        this.setTime(this.findParamInfo(string).getColIndex() + 1, time);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.findParamInfo(string).getColIndex() + 1, timestamp);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.findParamInfo(string).getColIndex() + 1, inputStream, n);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.findParamInfo(string).getColIndex() + 1, inputStream, n);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.setObject(this.findParamInfo(string).getColIndex() + 1, object, n, n2);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(this.findParamInfo(string).getColIndex() + 1, object, n);
    }

    public void setObject(String string, Object object) throws SQLException {
        this.setObject(this.findParamInfo(string).getColIndex() + 1, object);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.findParamInfo(string).getColIndex() + 1, reader, n);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.findParamInfo(string).getColIndex() + 1, date, calendar);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.findParamInfo(string).getColIndex() + 1, time, calendar);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.findParamInfo(string).getColIndex() + 1, timestamp, calendar);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.setNull(this.findParamInfo(string).getColIndex() + 1, n, string2);
    }

    public String getString(String string) throws SQLException {
        return this.findParamInfo(string).getString(this, this.replyMem);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.findParamInfo(string).getBoolean(this, this.replyMem);
    }

    public byte getByte(String string) throws SQLException {
        return this.findParamInfo(string).getByte(this, this.replyMem);
    }

    public short getShort(String string) throws SQLException {
        return this.findParamInfo(string).getShort(this, this.replyMem);
    }

    public int getInt(String string) throws SQLException {
        return this.findParamInfo(string).getInt(this, this.replyMem);
    }

    public long getLong(String string) throws SQLException {
        return this.findParamInfo(string).getLong(this, this.replyMem);
    }

    public float getFloat(String string) throws SQLException {
        return this.findParamInfo(string).getFloat(this, this.replyMem);
    }

    public double getDouble(String string) throws SQLException {
        return this.findParamInfo(string).getDouble(this, this.replyMem);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.findParamInfo(string).getBytes(this, this.replyMem);
    }

    public Date getDate(String string) throws SQLException {
        return this.findParamInfo(string).getDate(this, this.replyMem);
    }

    public Time getTime(String string) throws SQLException {
        return this.findParamInfo(string).getTime(this, this.replyMem);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.findParamInfo(string).getTimestamp(this, this.replyMem);
    }

    public Object getObject(String string) throws SQLException {
        return this.findParamInfo(string).getObject(this, this.replyMem);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.findParamInfo(string).getBigDecimal(this, this.replyMem);
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new NotImplemented();
    }

    public Ref getRef(String string) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.ref.unsupported"));
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        return this.findParamInfo(string).getBlob(this, this.replyMem, this.replyMem);
    }

    public Clob getClob(String string) throws SQLException {
        return this.findParamInfo(string).getClob(this, this.replyMem, this.replyMem);
    }

    public Array getArray(String string) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.array.unsupported"));
        return null;
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findParamInfo(string).getColIndex() + 1, calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findParamInfo(string).getColIndex() + 1, calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findParamInfo(string).getColIndex() + 1, calendar);
    }

    public URL getURL(String string) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.url.unsupported"));
        return null;
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.throwNotSupported(MessageTranslator.translate("error.url.unsupported"));
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ParameterMetaDataSapDB.createParameterMetaDataSapDB(this.parseinfo.getParamInfo());
    }
}

