/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.PersistenceManager;
import org.jboss.messaging.core.impl.IDCounter;
import org.jboss.messaging.core.impl.tx.Transaction;

public class NullPersistenceManager
implements PersistenceManager {
    private static final int MAX_PEER_ID = 65535;
    private ConcurrentMap<String, IDCounter> counters = new ConcurrentHashMap<String, IDCounter>();
    private int peerID;
    private long timeMark;

    public void addReference(long channelID, MessageReference ref, Transaction tx) throws Exception {
    }

    public List getMessageChannelPairAcksForTx(long transactionId) throws Exception {
        return Collections.EMPTY_LIST;
    }

    public List getMessageChannelPairRefsForTx(long transactionId) throws Exception {
        return Collections.EMPTY_LIST;
    }

    public List getMessages(List messageIds) throws Exception {
        return Collections.EMPTY_LIST;
    }

    public List getPagedReferenceInfos(long channelID, long orderStart, int number) throws Exception {
        return Collections.EMPTY_LIST;
    }

    public boolean idExists(String messageID) throws Exception {
        return false;
    }

    public PersistenceManager.InitialLoadInfo loadFromStart(long channelID, int fullSize) throws Exception {
        return new PersistenceManager.InitialLoadInfo(null, null, Collections.EMPTY_LIST);
    }

    public PersistenceManager.InitialLoadInfo mergeAndLoad(long fromChannelID, long toChannelID, int numberToLoad, long firstPagingOrder, long nextPagingOrder) throws Exception {
        return new PersistenceManager.InitialLoadInfo(null, null, Collections.EMPTY_LIST);
    }

    public void mergeTransactions(int fromNodeID, int toNodeID) throws Exception {
    }

    public void moveReference(long sourceChannelID, long destChannelID, MessageReference ref) throws Exception {
    }

    public void pageReferences(long channelID, List references, boolean paged) throws Exception {
    }

    public void removeDepagedReferences(long channelID, List refs) throws Exception {
    }

    public void removeReference(long channelID, MessageReference ref, Transaction tx) throws Exception {
    }

    public void addTransaction(Transaction tx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reserveIDBlock(String counterName, int size) throws Exception {
        this.checkServerID();
        IDCounter counter = (IDCounter)this.counters.get(counterName);
        if (counter == null) {
            ConcurrentMap<String, IDCounter> concurrentMap = this.counters;
            synchronized (concurrentMap) {
                counter = (IDCounter)this.counters.get(counterName);
                if (counter == null) {
                    counter = new IDCounter(this);
                    this.counters.put(counterName, counter);
                }
            }
        }
        long idStart = counter.reserveAndGetNextId(size);
        return idStart;
    }

    private void checkServerID() throws Exception {
        if (this.peerID > 65535) {
            throw new Exception("ServerPeerID " + this.peerID + " exceeding " + 65535);
        }
        if (this.peerID < 0) {
            throw new Exception("ServerPeerID cannot have negative values");
        }
    }

    public List retrievePreparedTransactions() throws Exception {
        return Collections.EMPTY_LIST;
    }

    public void updateDeliveryCount(long channelID, MessageReference ref) throws Exception {
    }

    public void updatePageOrder(long channelID, List references) throws Exception {
    }

    public void updateReferencesNotPagedInRange(long channelID, long orderStart, long orderEnd, long num) throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void initCounter(int serverPeerID, long serverStartTime) {
        this.setPeerID(serverPeerID);
        this.setTimeMark(serverStartTime);
    }

    public void setPeerID(int peerID) {
        this.peerID = peerID;
    }

    public int getPeerID() {
        return this.peerID;
    }

    public void setTimeMark(long timeMark) {
        this.timeMark = timeMark;
    }

    public long getTimeMark() {
        return this.timeMark;
    }
}

