/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.command;

import com.icesoft.faces.util.DOMUtils;
import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.Macro;
import com.icesoft.faces.webapp.command.NOOP;
import com.icesoft.faces.webapp.command.Pong;
import com.icesoft.faces.webapp.command.Redirect;
import com.icesoft.faces.webapp.command.Reload;
import com.icesoft.faces.webapp.command.SessionExpired;
import com.icesoft.faces.webapp.command.SetCookie;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class UpdateElements
implements Command {
    private static final Pattern START_CDATA = Pattern.compile("<\\!\\[CDATA\\[");
    private static final Pattern END_CDATA = Pattern.compile("\\]\\]>");
    private Element[] updates;

    public UpdateElements(Element[] updates) {
        this.updates = updates;
    }

    public Command coalesceWith(UpdateElements updateElementsCommand) {
        HashSet<Element> coallescedUpdates = new HashSet<Element>();
        Element[] previousUpdates = updateElementsCommand.updates;
        for (int i = 0; i < previousUpdates.length; ++i) {
            Element previousUpdate;
            Element selectedUpdate = previousUpdate = previousUpdates[i];
            for (int j = 0; j < this.updates.length; ++j) {
                Element update = this.updates[j];
                if (!update.getAttribute("id").equals(previousUpdate.getAttribute("id"))) continue;
                selectedUpdate = update;
                break;
            }
            coallescedUpdates.add(selectedUpdate);
        }
        coallescedUpdates.addAll(Arrays.asList(this.updates));
        return new UpdateElements(coallescedUpdates.toArray(new Element[coallescedUpdates.size()]));
    }

    public Command coalesceWith(Command command) {
        return command.coalesceWith(this);
    }

    public Command coalesceWith(Macro macro) {
        return new Macro(macro, this);
    }

    public Command coalesceWith(Redirect redirect) {
        return new Macro(redirect, this);
    }

    public Command coalesceWith(Reload reload) {
        return new Macro(reload, this);
    }

    public Command coalesceWith(SessionExpired sessionExpired) {
        return sessionExpired;
    }

    public Command coalesceWith(SetCookie setCookie) {
        return new Macro(setCookie, this);
    }

    public Command coalesceWith(Pong pong) {
        return new Macro(pong, this);
    }

    public Command coalesceWith(NOOP noop) {
        return this;
    }

    public void serializeTo(Writer writer) throws IOException {
        writer.write("<updates>");
        for (int i = 0; i < this.updates.length; ++i) {
            Element update = this.updates[i];
            if (update == null) continue;
            writer.write("<update address=\"");
            writer.write(update.getAttribute("id"));
            writer.write("\" tag=\"" + update.getTagName() + "\">");
            NamedNodeMap attributes = update.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Attr attribute = (Attr)attributes.item(j);
                writer.write("<attribute name=\"");
                writer.write(attribute.getName());
                String value = attribute.getValue();
                if ("".equals(value)) {
                    writer.write("\"/>");
                    continue;
                }
                writer.write("\"><![CDATA[");
                writer.write(DOMUtils.escapeAnsi(value));
                writer.write("]]></attribute>");
            }
            String content = DOMUtils.childrenToString(update);
            if ("".equals(content)) {
                writer.write("<content/>");
            } else {
                writer.write("<content><![CDATA[");
                content = START_CDATA.matcher(content).replaceAll("<!#cdata#");
                content = END_CDATA.matcher(content).replaceAll("##>");
                writer.write(content);
                writer.write("]]></content>");
            }
            writer.write("</update>");
        }
        writer.write("</updates>");
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.serializeTo(writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

