/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import org.hsqldb.Channel;
import org.hsqldb.Database;
import org.hsqldb.Embedded_Server;
import org.hsqldb.Result;

class Embedded_ServerConnection
extends Thread {
    private Database mDatabase;
    private Socket mSocket;
    private Embedded_Server mServer;
    private DataInputStream mInput;
    private DataOutputStream mOutput;
    private static int mCurrentThread = 0;
    private int mThread;

    Embedded_ServerConnection(Socket socket, Embedded_Server server) {
        this.mSocket = socket;
        this.mDatabase = server.mDatabase;
        this.mServer = server;
        Embedded_ServerConnection embedded_ServerConnection = this;
        synchronized (embedded_ServerConnection) {
            this.mThread = mCurrentThread++;
        }
    }

    private Channel init() {
        try {
            this.mSocket.setTcpNoDelay(true);
            this.mInput = new DataInputStream(new BufferedInputStream(this.mSocket.getInputStream()));
            this.mOutput = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            String user = this.mInput.readUTF();
            String password = this.mInput.readUTF();
            try {
                this.mServer.trace(this.mThread + ":trying to connect user " + user);
                return this.mDatabase.connect(user, password);
            }
            catch (SQLException e) {
                this.write(new Result(e.getMessage()).getBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void run() {
        Channel c = this.init();
        boolean bRun = true;
        if (c != null) {
            try {
                while (bRun) {
                    String sql = this.mInput.readUTF();
                    this.mServer.trace(this.mThread + ":" + sql);
                    if (sql != null) {
                        this.write(this.mDatabase.execute(sql, c).getBytes());
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            this.mSocket.close();
        }
        catch (IOException e) {
            System.out.println("************** A exeption in hsqldb.Embedded_ServerConnection.mSocket.close() *****");
        }
        if (this.mDatabase.isShutdown()) {
            if (this.mServer.getEmbedded()) {
                System.out.println("The database is closed as Embbeded");
                this.mServer.closeServerSocket();
            } else {
                System.out.println("The database is shutdown");
                System.exit(0);
            }
        }
    }

    void write(byte[] b) throws IOException {
        this.mOutput.writeInt(b.length);
        this.mOutput.write(b);
        this.mOutput.flush();
    }
}

