/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.engine.bufferedengine;

import com.octo.captcha.Captcha;
import com.octo.captcha.CaptchaException;
import com.octo.captcha.CaptchaFactory;
import com.octo.captcha.engine.CaptchaEngine;
import com.octo.captcha.engine.CaptchaEngineException;
import com.octo.captcha.engine.bufferedengine.ContainerConfiguration;
import com.octo.captcha.engine.bufferedengine.buffer.CaptchaBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BufferedEngineContainer
implements CaptchaEngine {
    private static final Log log = LogFactory.getLog((String)BufferedEngineContainer.class.getName());
    protected CaptchaBuffer persistentBuffer = null;
    protected CaptchaBuffer volatileBuffer = null;
    protected CaptchaEngine engine = null;
    protected ContainerConfiguration config = null;
    protected int volatileMemoryHits = 0;
    protected int persistentMemoryHits = 0;
    protected int persistentToVolatileSwaps = 0;
    protected int persistentFeedings = 0;
    private boolean shutdownCalled = false;

    public BufferedEngineContainer(CaptchaEngine engine, CaptchaBuffer volatileBuffer, CaptchaBuffer persistentBuffer, ContainerConfiguration containerConfiguration) {
        this.engine = engine;
        if (engine == null) {
            throw new CaptchaEngineException("impossible to build a BufferedEngineContainer with a null engine");
        }
        this.volatileBuffer = volatileBuffer;
        if (persistentBuffer == null) {
            throw new CaptchaEngineException("impossible to build a BufferedEngineContainer with a null volatileBuffer");
        }
        this.persistentBuffer = persistentBuffer;
        if (persistentBuffer == null) {
            throw new CaptchaEngineException("impossible to build a BufferedEngineContainer with a null persistentBuffer");
        }
        this.config = containerConfiguration;
        if (this.config == null) {
            throw new CaptchaEngineException("impossible to build a BufferedEngineContainer with a null configuration");
        }
        Shutdown sh = new Shutdown();
        Runtime.getRuntime().addShutdownHook(sh);
    }

    public Captcha getNextCaptcha() {
        log.debug((Object)"entering getNextCaptcha()");
        return this.getNextCaptcha(this.config.getDefaultLocale());
    }

    public Captcha getNextCaptcha(Locale locale) {
        log.debug((Object)"entering getNextCaptcha(Locale locale)");
        Captcha captcha = null;
        locale = this.resolveLocale(locale);
        try {
            captcha = this.volatileBuffer.removeCaptcha(locale);
        }
        catch (NoSuchElementException e) {
            log.debug((Object)"no captcha under this locale", (Throwable)e);
        }
        if (captcha == null) {
            captcha = this.engine.getNextCaptcha(locale);
            log.debug((Object)"get captcha from engine");
            if (this.config.isServeOnlyConfiguredLocales()) {
                log.warn((Object)"captcha is directly built from engine, try to increase the swap frequency or the persistant buffer size");
            }
        } else {
            log.debug((Object)"get captcha from memory");
            ++this.volatileMemoryHits;
        }
        return captcha;
    }

    public CaptchaFactory[] getFactories() {
        return this.engine.getFactories();
    }

    public void setFactories(CaptchaFactory[] factories) {
        this.engine.setFactories(factories);
    }

    private Locale resolveLocale(Locale locale) {
        if (!this.config.isServeOnlyConfiguredLocales()) {
            return locale;
        }
        if (this.config.getLocaleRatio().containsKey((Object)locale)) {
            return locale;
        }
        if (this.config.getLocaleRatio().containsKey((Object)locale.getLanguage())) {
            return new Locale(locale.getLanguage());
        }
        return this.config.getDefaultLocale();
    }

    public void swapCaptchasFromPersistentToVolatileMemory() {
        log.debug((Object)"entering swapCaptchasFromDiskBufferToMemoryBuffer()");
        MapIterator it = this.config.getLocaleRatio().mapIterator();
        HashedMap captchasRatios = new HashedMap();
        while (it.hasNext()) {
            Locale locale = (Locale)it.next();
            double ratio = (Double)it.getValue();
            int ratioCount = (int)Math.round((double)this.config.getSwapSize().intValue() * ratio);
            int diff = (int)Math.round((double)(this.config.getMaxVolatileMemorySize() - this.volatileBuffer.size()) * ratio);
            diff = diff < 0 ? 0 : diff;
            int toSwap = diff < ratioCount ? diff : ratioCount;
            captchasRatios.put((Object)locale, (Object)new Integer(toSwap));
        }
        MapIterator captchasRatiosit = captchasRatios.mapIterator();
        while (captchasRatiosit.hasNext() && !this.shutdownCalled) {
            Locale locale = (Locale)captchasRatiosit.next();
            int swap = (Integer)captchasRatios.get((Object)locale);
            if (log.isDebugEnabled()) {
                log.debug((Object)("try to swap  " + swap + " Captchas from persistent to volatile memory with locale : " + locale.toString()));
            }
            Collection temp = this.persistentBuffer.removeCaptcha(swap, locale);
            this.volatileBuffer.putAllCaptcha(temp, locale);
            if (log.isDebugEnabled()) {
                log.debug((Object)("swaped  " + temp.size() + " Captchas from persistent to volatile memory with locale : " + locale.toString()));
            }
            this.persistentMemoryHits += temp.size();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("new volatil Buffer size : " + this.volatileBuffer.size()));
        }
        ++this.persistentToVolatileSwaps;
    }

    public void feedPersistentBuffer() {
        log.debug((Object)"entering feedPersistentBuffer()");
        int freePersistentBufferSize = this.config.getMaxPersistentMemorySize() - this.persistentBuffer.size();
        freePersistentBufferSize = freePersistentBufferSize > 0 ? freePersistentBufferSize : 0;
        int totalFeedsize = freePersistentBufferSize > this.config.getFeedSize() ? this.config.getFeedSize() : freePersistentBufferSize;
        log.info((Object)("Starting feed. Total feed size = " + totalFeedsize));
        MapIterator it = this.config.getLocaleRatio().mapIterator();
        while (it.hasNext() && !this.shutdownCalled) {
            int builded;
            Locale locale = (Locale)it.next();
            double ratio = (Double)it.getValue();
            int ratioCount = (int)Math.round((double)totalFeedsize * ratio);
            if (log.isDebugEnabled()) {
                log.debug((Object)("construct " + ratioCount + " captchas for locale " + locale.toString()));
            }
            for (int toBuild = ratioCount; toBuild > 0 && !this.shutdownCalled; toBuild -= builded) {
                int batch = toBuild > this.config.getFeedBatchSize() ? this.config.getFeedBatchSize() : toBuild;
                ArrayList<Captcha> captchas = new ArrayList<Captcha>(batch);
                builded = 0;
                for (int i = 0; i < batch; ++i) {
                    try {
                        captchas.add(this.engine.getNextCaptcha(locale));
                        ++builded;
                        continue;
                    }
                    catch (CaptchaException e) {
                        log.warn((Object)"Error during captcha construction, skip this one : ", (Throwable)e);
                    }
                }
                this.persistentBuffer.putAllCaptcha(captchas, locale);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("feeded persistent buffer with  " + builded + " captchas for locale " + locale));
            }
        }
        log.info((Object)("Stopping feed : feeded persitentBuffer with : " + totalFeedsize + " captchas"));
        log.info((Object)("Stopping feed : resulting persitentBuffer size : " + this.persistentBuffer.size()));
        ++this.persistentFeedings;
    }

    public ContainerConfiguration getConfig() {
        return this.config;
    }

    public CaptchaBuffer getPersistentBuffer() {
        return this.persistentBuffer;
    }

    public Integer getPersistentFeedings() {
        return new Integer(this.persistentFeedings);
    }

    public Integer getPersistentMemoryHits() {
        return new Integer(this.persistentMemoryHits);
    }

    public Integer getPersistentToVolatileSwaps() {
        return new Integer(this.persistentToVolatileSwaps);
    }

    public CaptchaBuffer getVolatileBuffer() {
        return this.volatileBuffer;
    }

    public Integer getVolatileMemoryHits() {
        return new Integer(this.volatileMemoryHits);
    }

    public void closeBuffers() {
        this.persistentBuffer.dispose();
        this.volatileBuffer.dispose();
        log.info((Object)"Buffers disposed");
    }

    class Shutdown
    extends Thread {
        public void run() {
            log.info((Object)"Buffered engine shutdown thread started");
            BufferedEngineContainer.this.shutdownCalled = true;
            try {
                BufferedEngineContainer.this.closeBuffers();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }
}

