/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class PutMethod
extends HttpMethodBase {
    private byte[] data = null;
    private File file = null;
    private URL url = null;
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.methods.PutMethod");

    public PutMethod() {
    }

    public PutMethod(String path) {
        super(path);
    }

    public String getName() {
        return "PUT";
    }

    public void setRequestBody(File file) throws IOException {
        this.checkNotUsed();
        this.file = file;
    }

    public void setRequestBody(URL url) throws IOException {
        this.checkNotUsed();
        this.url = url;
    }

    public void setRequestBody(byte[] bodydata) {
        this.checkNotUsed();
        this.data = bodydata;
    }

    public void setRequestBody(String bodydata) {
        this.checkNotUsed();
        this.setRequestBody(bodydata.getBytes());
    }

    public void setRequestBody(InputStream is) throws IOException {
        this.checkNotUsed();
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int nb = 0;
        while ((nb = is.read(buffer)) != -1) {
            os.write(buffer, 0, nb);
        }
        this.data = os.toByteArray();
    }

    protected void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        super.addRequestHeaders(state, conn);
        if (this.isHttp11() && null == this.getRequestHeader("expect")) {
            this.setRequestHeader("Expect", "100-continue");
        }
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (null != this.getRequestHeader("expect") && this.getStatusCode() != 100) {
            return false;
        }
        OutputStream out = conn.getRequestOutputStream(this.isHttp11() && null == this.getRequestHeader("Content-Length"));
        InputStream inputStream = null;
        if (this.file != null && this.file.exists()) {
            inputStream = new FileInputStream(this.file);
        } else if (this.url != null) {
            inputStream = this.url.openConnection().getInputStream();
        } else if (this.data != null) {
            inputStream = new ByteArrayInputStream(this.data);
        } else {
            return true;
        }
        byte[] buffer = new byte[4096];
        int nb = 0;
        while ((nb = inputStream.read(buffer)) != -1) {
            out.write(buffer, 0, nb);
        }
        inputStream.close();
        out.close();
        return true;
    }

    protected int getRequestContentLength() {
        if (null != this.data) {
            return this.data.length;
        }
        if (null != this.file && this.file.exists()) {
            return (int)this.file.length();
        }
        if (this.url != null) {
            return -1;
        }
        return 0;
    }

    public void recycle() {
        super.recycle();
        this.data = null;
        this.url = null;
        this.file = null;
    }
}

