/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp1224;

import org.jboss.annotation.ejb.Service;
import org.jboss.logging.Logger;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
@Service(xmbean="resource:META-INF/defaulted-service-xmbean.xml")
public class DefaultedServiceBean implements DefaultedServiceRemote
{
   private static final Logger log = Logger.getLogger(DefaultedServiceBean.class);
   
   private String configParam;
   
   public String getConfigParam()
   {
      return configParam;
   }
   
   public void setConfigParam(String configParam)
   {
      log.info("configParam = " + configParam);
      this.configParam = configParam;
   }
   
   public void start()
   {
      log.info("configParam = " + configParam);
   }
   
   public void stop()
   {
      
   }
}
