/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.bridge;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMP2xFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMP2xVersionFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.ejb.plugins.keygenerator.KeyGenerator;
import org.jboss.ejb.plugins.keygenerator.KeyGeneratorFactory;

public class JDBCKeyGenVersionFieldBridge
extends JDBCCMP2xVersionFieldBridge {
    private final KeyGenerator keyGenerator;

    public JDBCKeyGenVersionFieldBridge(JDBCStoreManager manager, JDBCCMPFieldMetaData metadata, String keygenFactoryName) throws DeploymentException {
        super(manager, metadata);
        this.keyGenerator = this.initKeyGenerator(keygenFactoryName);
    }

    public JDBCKeyGenVersionFieldBridge(JDBCCMP2xFieldBridge cmpField, String keygenFactoryName) throws DeploymentException {
        super(cmpField);
        this.keyGenerator = this.initKeyGenerator(keygenFactoryName);
    }

    private KeyGenerator initKeyGenerator(String keygenFactoryName) throws DeploymentException {
        try {
            InitialContext ctx = new InitialContext();
            KeyGeneratorFactory keygenFactory = (KeyGeneratorFactory)ctx.lookup(keygenFactoryName);
            return keygenFactory.getKeyGenerator();
        }
        catch (NamingException e) {
            throw new DeploymentException("Could not lookup key generator factory: " + keygenFactoryName, e);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not create KeyGenerator instance.", e);
        }
    }

    public void setFirstVersion(EntityEnterpriseContext ctx) {
        Object version = this.keyGenerator.generateKey();
        this.setInstanceValue(ctx, version);
    }

    public Object updateVersion(EntityEnterpriseContext ctx) {
        Object next = this.keyGenerator.generateKey();
        this.setInstanceValue(ctx, next);
        return next;
    }
}

