/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.ParserError;
import org.drools.lang.RuleParser;
import org.drools.lang.RuleParserLexer;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.dsl.DefaultExpanderResolver;

public class DrlParser {
    private final List results = new ArrayList();

    public PackageDescr parse(String string) throws DroolsParserException {
        RuleParser ruleParser = this.getParser(string);
        this.compile(ruleParser);
        return ruleParser.getPackageDescr();
    }

    private void compile(RuleParser ruleParser) throws DroolsParserException {
        try {
            ruleParser.compilation_unit();
            this.makeErrorList(ruleParser);
        }
        catch (RecognitionException recognitionException) {
            throw new DroolsParserException(recognitionException);
        }
    }

    private void makeErrorList(RuleParser ruleParser) {
        Iterator iterator = ruleParser.getErrors().iterator();
        while (iterator.hasNext()) {
            RecognitionException recognitionException = (RecognitionException)((Object)iterator.next());
            ParserError parserError = new ParserError(ruleParser.createErrorMessage(recognitionException), recognitionException.line, recognitionException.charPositionInLine);
            this.results.add(parserError);
        }
    }

    private RuleParser getParser(String string) {
        return new RuleParser((TokenStream)new CommonTokenStream((TokenSource)new RuleParserLexer((CharStream)new ANTLRStringStream(string))));
    }

    public PackageDescr parse(Reader reader) throws IOException, DroolsParserException {
        StringBuffer stringBuffer = this.getDRLText(reader);
        return this.parse(stringBuffer.toString());
    }

    public PackageDescr parse(Reader reader, Reader reader2) throws DroolsParserException, IOException {
        StringBuffer stringBuffer = this.getDRLText(reader);
        return this.parse(stringBuffer.toString(), reader2);
    }

    public PackageDescr parse(String string, Reader reader) throws DroolsParserException {
        DefaultExpanderResolver defaultExpanderResolver = new DefaultExpanderResolver(reader);
        RuleParser ruleParser = this.getParser(string);
        ruleParser.setExpanderResolver(defaultExpanderResolver);
        this.compile(ruleParser);
        return ruleParser.getPackageDescr();
    }

    private StringBuffer getDRLText(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        int n = 0;
        while ((n = reader.read(cArray)) >= 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer;
    }

    public boolean hasErrors() {
        return this.results.size() > 0;
    }

    public List getErrors() {
        return this.results;
    }
}

