/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.admin;

import java.util.Properties;
import org.jboss.util.NestedRuntimeException;
import org.objectweb.jtests.jms.admin.Admin;

public class AdminFactory {
    private static final String PROP_NAME = "jms.provider.admin.class";

    protected static String getAdminClassName(Properties props) {
        String adminClassName = props.getProperty(PROP_NAME);
        return adminClassName;
    }

    public static Admin getAdmin(Properties props) {
        String adminClassName = AdminFactory.getAdminClassName(props);
        Admin admin = null;
        if (adminClassName == null) {
            throw new NestedRuntimeException("Property jms.provider.admin.class has not been found in input props");
        }
        try {
            Class<?> adminClass = Class.forName(adminClassName);
            admin = (Admin)adminClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new NestedRuntimeException("Class " + adminClassName + " not found.", (Throwable)e);
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        return admin;
    }
}

