/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.ajax4jsf.framework.ajax.AjaxContainer;
import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.ajax.AjaxListener;
import org.ajax4jsf.framework.ajax.AjaxRegionBrige;
import org.ajax4jsf.framework.ajax.AjaxSingleException;
import org.ajax4jsf.framework.ajax.InvokerCallback;
import org.ajax4jsf.framework.ajax.ViewIdHolder;
import org.ajax4jsf.framework.renderer.AjaxContainerRenderer;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.UnboundedFifoBuffer;

public class AjaxViewRoot
extends UIViewRoot
implements AjaxContainer {
    public static final String ROOT_ID = "_viewRoot";
    private AjaxRegionBrige _brige;
    private Buffer[] events;
    private Buffer ajaxEvents = new UnboundedFifoBuffer();
    private InvokerCallback _decodeInvoker = new InvokerCallback(){

        public void invoke(FacesContext context, UIComponent component) {
            component.processDecodes(context);
        }

        public void invokeRoot(FacesContext context) {
            AjaxViewRoot.super.processDecodes(context);
        }
    };
    private UIComponent singleComponent = null;
    private InvokerCallback _updatesInvoker = new InvokerCallback(){

        public void invoke(FacesContext context, UIComponent component) {
            component.processUpdates(context);
        }

        public void invokeRoot(FacesContext context) {
            AjaxViewRoot.super.processUpdates(context);
        }
    };
    private InvokerCallback _validatorsInvoker = new InvokerCallback(){

        public void invoke(FacesContext context, UIComponent component) {
            component.processValidators(context);
        }

        public void invokeRoot(FacesContext context) {
            AjaxViewRoot.super.processValidators(context);
        }
    };
    private InvokerCallback _ajaxInvoker = new InvokerCallback(){

        public void invoke(FacesContext context, UIComponent component) {
            try {
                if (component instanceof AjaxContainer) {
                    AjaxContainer ajax = (AjaxContainer)component;
                    ajax.encodeAjax(context);
                } else {
                    AjaxViewRoot.this.encodeAjax(context);
                }
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }

        public void invokeRoot(FacesContext context) {
            try {
                AjaxViewRoot.this.encodeAjax(context);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
    };

    public AjaxViewRoot() {
        super.setId(ROOT_ID);
        this._brige = new AjaxRegionBrige((UIComponent)this);
    }

    public String getRendererType() {
        return "javax.faces.ViewRoot";
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        this.getBrige().broadcast(event);
    }

    public MethodBinding getAjaxListener() {
        return this.getBrige().getAjaxListener();
    }

    public boolean isImmediate() {
        return this.getBrige().isImmediate();
    }

    public boolean isSubmitted() {
        return this.getBrige().isSubmitted();
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException(Messages.getMessage("NULL_EVENT_SUBMITTED_ERROR"));
        }
        if (event.getPhaseId().compareTo((Object)PhaseId.RENDER_RESPONSE) == 0) {
            this.getAjaxEventsQueue(this.getFacesContext()).add((Object)event);
        } else {
            this.getEventsQueue(this.getFacesContext(), event.getPhaseId()).add((Object)event);
        }
    }

    void broadcastEvents(FacesContext context, PhaseId phaseId) {
        Buffer[] events = this.getEvents(context);
        Buffer anyPhaseEvents = events[PhaseId.ANY_PHASE.getOrdinal()];
        Buffer phaseEvents = events[phaseId.getOrdinal()];
        if (phaseEvents.isEmpty() && anyPhaseEvents.isEmpty()) {
            return;
        }
        boolean haveAnyPhaseEvents = !anyPhaseEvents.isEmpty();
        boolean havePhaseEvents = !phaseEvents.isEmpty();
        do {
            this.processEvents(anyPhaseEvents, haveAnyPhaseEvents);
            this.processEvents(phaseEvents, havePhaseEvents);
            haveAnyPhaseEvents = !anyPhaseEvents.isEmpty();
            boolean bl = havePhaseEvents = !phaseEvents.isEmpty();
        } while (haveAnyPhaseEvents || havePhaseEvents);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents(context);
        }
    }

    public void processEvents(Buffer phaseEventsQueue, boolean havePhaseEvents) {
        while (havePhaseEvents) {
            try {
                FacesEvent event = (FacesEvent)phaseEventsQueue.remove();
                UIComponent source = event.getComponent();
                try {
                    source.broadcast(event);
                }
                catch (AbortProcessingException e) {
                }
            }
            catch (BufferUnderflowException e) {
                havePhaseEvents = false;
            }
        }
    }

    public void broadcastAjaxEvents(FacesContext context) {
        Buffer queue;
        this.processEvents(queue, !(queue = this.getAjaxEventsQueue(context)).isEmpty());
    }

    protected Buffer getEventsQueue(FacesContext context, PhaseId phase) {
        return this.getEvents(context)[phase.getOrdinal()];
    }

    protected Buffer[] getEvents(FacesContext context) {
        if (this.events == null) {
            this.clearEvents(context);
        }
        return this.events;
    }

    protected Buffer getAjaxEventsQueue(FacesContext context) {
        return this.ajaxEvents;
    }

    public void clearEvents(FacesContext context) {
        int len = PhaseId.VALUES.size();
        this.events = new Buffer[len];
        for (int i = 0; i < len; ++i) {
            this.events[i] = new UnboundedFifoBuffer();
        }
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.singleComponent = null;
        AjaxContext.invokeOnRegionOrRoot(this, context, this._decodeInvoker);
        try {
            this.broadcastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
        }
        catch (AjaxSingleException e) {
            this.singleComponent = e.getComponent();
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (null == this.singleComponent) {
            AjaxContext.invokeOnRegionOrRoot(this, context, this._updatesInvoker);
        } else {
            this.singleComponent.processUpdates(context);
        }
        this.broadcastEvents(context, PhaseId.UPDATE_MODEL_VALUES);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (null == this.singleComponent) {
            AjaxContext.invokeOnRegionOrRoot(this, context, this._validatorsInvoker);
        } else {
            this.singleComponent.processValidators(context);
        }
        this.broadcastEvents(context, PhaseId.PROCESS_VALIDATIONS);
    }

    public void processApplication(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.broadcastEvents(context, PhaseId.INVOKE_APPLICATION);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!this.isHavePage() && AjaxContext.getCurrentInstance(context).isAjaxRequest(context)) {
            AjaxContext.invokeOnRegionOrRoot(this, context, this._ajaxInvoker);
        } else {
            super.encodeChildren(context);
        }
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] mystate = (Object[])state;
        super.restoreState(context, mystate[0]);
        this.getBrige().restoreState(context, mystate[1]);
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.getBrige().saveState(context)};
        return state;
    }

    public String getViewId() {
        ViewIdHolder viewIdHolder = AjaxContext.getCurrentInstance().getViewIdHolder();
        String viewId = null != viewIdHolder ? viewIdHolder.getViewId() : super.getViewId();
        return viewId;
    }

    public void setAjaxListener(MethodBinding ajaxListener) {
        this.getBrige().setAjaxListener(ajaxListener);
    }

    public void setImmediate(boolean immediate) {
        this.getBrige().setImmediate(immediate);
    }

    public void setSubmitted(boolean submitted) {
        this.getBrige().setSubmitted(submitted);
    }

    public void addAjaxListener(AjaxListener listener) {
        this.addFacesListener(listener);
    }

    public AjaxListener[] getAjaxListeners() {
        return (AjaxListener[])this.getFacesListeners(AjaxListener.class);
    }

    public void removeAjaxListener(AjaxListener listener) {
        this.removeFacesListener(listener);
    }

    public boolean isSelfRendered() {
        return false;
    }

    public void setSelfRendered(boolean selfRendered) {
    }

    public boolean isHavePage() {
        return this.getChildCount() == 1 && this.getChildren().get(0) instanceof AjaxContainer;
    }

    public boolean getRendersChildren() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!AjaxContext.getCurrentInstance(context).isAjaxRequest(context)) {
            return false;
        }
        return !this.isHavePage();
    }

    public boolean isRenderRegionOnly() {
        return false;
    }

    public void setRenderRegionOnly(boolean reRenderPage) {
    }

    public void encodeAjax(FacesContext context) throws IOException {
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            ((AjaxContainerRenderer)this.getRenderer(context)).encodeAjax(context, (UIComponent)this);
        }
    }

    protected AjaxRegionBrige getBrige() {
        return this._brige;
    }
}

