/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation.util;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;

public class FindAnnotations {
    public static ClassPool pool;

    public static void main(String[] args) throws Exception {
        pool = ClassPool.getDefault();
        pool.appendSystemPath();
        pool.insertClassPath(".");
        CtClass clazz = pool.get(args[0]);
        clazz.getClassFile2().getConstPool().print();
        FindAnnotations.printClassAttributes(clazz);
    }

    public static void printAnnotations(Annotation[] annotations) {
        for (int i = 0; i < annotations.length; ++i) {
            FindAnnotations.printAnnotation(annotations[i]);
        }
    }

    public static void printClassAttributes(CtClass clazz) throws Exception {
        AnnotationsAttribute visible;
        ClassFile cf = clazz.getClassFile();
        AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        if (invisible != null) {
            System.out.println("** invisible class annotations **");
            Annotation[] annotations = invisible.getAnnotations();
            FindAnnotations.printAnnotations(annotations);
        }
        if ((visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations")) != null) {
            System.out.println("** visible class annotations **");
            Annotation[] annotations = visible.getAnnotations();
            FindAnnotations.printAnnotations(annotations);
        }
        System.out.println("**** method annotations ****");
        List methods = cf.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            Annotation[] annotations;
            MethodInfo mi = (MethodInfo)methods.get(i);
            System.out.println("method: " + mi.getName());
            System.out.println("CONST POOL: ");
            mi.getConstPool().print();
            System.out.println("-------------");
            invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible != null) {
                System.out.println("** invisible method annotations **");
                annotations = invisible.getAnnotations();
                FindAnnotations.printAnnotations(annotations);
            }
            if ((visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations")) != null) {
                System.out.println("** visible method annotations **");
                annotations = visible.getAnnotations();
                FindAnnotations.printAnnotations(annotations);
            }
            System.out.println("----");
        }
        System.out.println("**** field annotations ****");
        List fields = cf.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Annotation[] annotations;
            FieldInfo mi = (FieldInfo)fields.get(i);
            System.out.println("field: " + mi.getName());
            System.out.println("CONST POOL: ");
            mi.getConstPool().print();
            System.out.println("field: " + mi.getName());
            invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible != null) {
                System.out.println("** invisible method annotations **");
                annotations = invisible.getAnnotations();
                FindAnnotations.printAnnotations(annotations);
            }
            if ((visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations")) != null) {
                System.out.println("** visible method annotations **");
                annotations = visible.getAnnotations();
                FindAnnotations.printAnnotations(annotations);
            }
            System.out.println("----");
        }
    }

    public static void printAnnotation(Annotation info) {
        System.out.print("@" + info.getTypeName());
        Set members = info.getMemberNames();
        if (members != null) {
            System.out.print("(");
            Iterator mit = members.iterator();
            while (mit.hasNext()) {
                String name = (String)mit.next();
                System.out.print(name + "=" + info.getMemberValue(name).toString());
                if (!mit.hasNext()) continue;
                System.out.print(", ");
            }
            System.out.print(")");
        }
        System.out.println("");
    }
}

