/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.util.Util;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;

public class AnimationPanel
extends JPanel
implements Runnable,
ImageObserver {
    private Image _imArray = null;
    private String _sImage = null;
    private int _size = -1;
    private int _images = 0;
    private int _nextImage = 0;
    private long _lSleep = 1000L;
    private Thread _pThread = null;
    private boolean _bStop = false;

    public AnimationPanel(String sFileName_) {
        this(sFileName_, 1000L);
    }

    public AnimationPanel(String sFileName_, long lSleep_) {
        this(Toolkit.getDefaultToolkit().getImage(sFileName_), lSleep_);
    }

    public AnimationPanel(Image image_, long lSleep_) {
        this._lSleep = lSleep_;
        this._imArray = image_;
        this._waitWhileImageIsLoading(this._imArray);
        if (this._imArray != null) {
            int width = this._imArray.getWidth(this);
            int height = this._imArray.getHeight(this);
            this._size = Math.min(width, height);
            int max = Math.max(width, height);
            if (this._size != 0) {
                this._images = max / this._size;
            }
        }
    }

    private synchronized void _waitWhileImageIsLoading(Image pImage_) {
        while (pImage_.getWidth(this) == -1 && pImage_.getHeight(this) == -1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void update(Graphics pGraphics_) {
        if (this._size > 0 && this._images > 0) {
            pGraphics_.clipRect(0, 0, this._size, this._size);
            pGraphics_.drawImage(this._imArray, -(this._nextImage * this._size), 0, this);
        }
    }

    public void paint(Graphics pGraphics_) {
        Util.debug("AnimationPanel.paint(..)");
        this.update(pGraphics_);
    }

    public synchronized boolean imageUpdate(Image pImage_, int flags_, int x_, int y_, int w_, int h_) {
        this.notifyAll();
        return true;
    }

    public void run() {
        this._bStop = false;
        Thread.currentThread().setPriority(10);
        if (this._imArray != null) {
            Util.debug("AnimationPanel.<init>._size: " + this._size);
            Util.debug("AnimationPanel.<init>._images: " + this._images);
            while (!this._bStop && this._pThread != null) {
                this.repaint();
                try {
                    Thread.sleep(this._lSleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this._nextImage;
                if (this._nextImage != this._images) continue;
                this._nextImage = 0;
            }
        }
    }

    public void start() {
        if (this._pThread == null) {
            this._pThread = new Thread(this);
            this._pThread.start();
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(Math.max(this._size, 32), Math.max(this._size, 32));
    }

    public void stop() {
        if (this._pThread != null && this._pThread.isAlive()) {
            this._bStop = true;
            this._pThread.interrupt();
        }
        this._pThread = null;
    }
}

