/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;

public class OptionsMethod
extends HttpMethodBase {
    private Vector methodsAllowed = new Vector();

    public OptionsMethod() {
    }

    public OptionsMethod(String path) {
        super(path);
    }

    public String getName() {
        return "OPTIONS";
    }

    public boolean isAllowed(String method) {
        this.checkUsed();
        return this.methodsAllowed.contains(method);
    }

    public Enumeration getAllowedMethods() {
        this.checkUsed();
        return this.methodsAllowed.elements();
    }

    protected void processResponseHeaders(HttpState state, HttpConnection conn) {
        Header allowHeader = this.getResponseHeader("allow");
        if (allowHeader != null) {
            String allowHeaderValue = allowHeader.getValue();
            StringTokenizer tokenizer = new StringTokenizer(allowHeaderValue, ",");
            while (tokenizer.hasMoreElements()) {
                String methodAllowed = tokenizer.nextToken().trim().toUpperCase();
                this.methodsAllowed.addElement(methodAllowed);
            }
        }
    }

    public boolean needContentLength() {
        return false;
    }
}

