/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PropertiesParser {
    Properties props = null;

    public PropertiesParser(Properties props) {
        this.props = props;
    }

    public Properties getUnderlyingProperties() {
        return this.props;
    }

    public String getStringProperty(String name) {
        String val = this.props.getProperty(name);
        if (val == null) {
            return null;
        }
        return val.trim();
    }

    public String getStringProperty(String name, String def) {
        String val = this.props.getProperty(name, def);
        if (val == null) {
            return def;
        }
        if ((val = val.trim()).length() == 0) {
            return def;
        }
        return val;
    }

    public String[] getStringArrayProperty(String name) {
        return this.getStringArrayProperty(name, null);
    }

    public String[] getStringArrayProperty(String name, String[] def) {
        String vals = this.getStringProperty(name);
        if (vals == null) {
            return def;
        }
        if (vals != null && !vals.trim().equals("")) {
            StringTokenizer stok = new StringTokenizer(vals, ",");
            Vector<String> strs = new Vector<String>();
            try {
                while (stok.hasMoreTokens()) {
                    strs.addElement(stok.nextToken());
                }
                String[] outStrs = new String[strs.size()];
                for (int i = 0; i < strs.size(); ++i) {
                    outStrs[i] = (String)strs.elementAt(i);
                }
                return outStrs;
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    public boolean getBooleanProperty(String name) {
        String val = this.getStringProperty(name);
        if (val == null) {
            return false;
        }
        return new Boolean(val);
    }

    public boolean getBooleanProperty(String name, boolean def) {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        return new Boolean(val);
    }

    public byte getByteProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Byte.parseByte(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public byte getByteProperty(String name, byte def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Byte.parseByte(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public char getCharProperty(String name) {
        String param = this.getStringProperty(name);
        if (param == null) {
            return '\u0000';
        }
        if (param.length() == 0) {
            return '\u0000';
        }
        return param.charAt(0);
    }

    public char getCharProperty(String name, char def) {
        String param = this.getStringProperty(name);
        if (param == null) {
            return def;
        }
        if (param.length() == 0) {
            return def;
        }
        return param.charAt(0);
    }

    public double getDoubleProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public double getDoubleProperty(String name, double def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public float getFloatProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public float getFloatProperty(String name, float def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public int getIntProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public int getIntProperty(String name, int def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public int[] getIntArrayProperty(String name) throws NumberFormatException {
        return this.getIntArrayProperty(name, null);
    }

    public int[] getIntArrayProperty(String name, int[] def) throws NumberFormatException {
        String vals = this.getStringProperty(name);
        if (vals == null) {
            return def;
        }
        if (vals != null && !vals.trim().equals("")) {
            StringTokenizer stok = new StringTokenizer(vals, ",");
            Vector<Integer> ints = new Vector<Integer>();
            try {
                while (stok.hasMoreTokens()) {
                    try {
                        ints.addElement(new Integer(stok.nextToken()));
                    }
                    catch (NumberFormatException nfe) {
                        throw new NumberFormatException(" '" + vals + "'");
                    }
                }
                int[] outInts = new int[ints.size()];
                for (int i = 0; i < ints.size(); ++i) {
                    outInts[i] = (Integer)ints.elementAt(i);
                }
                return outInts;
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    public long getLongProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public long getLongProperty(String name, long def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public short getShortProperty(String name) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Short.parseShort(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public short getShortProperty(String name, short def) throws NumberFormatException {
        String val = this.getStringProperty(name);
        if (val == null) {
            return def;
        }
        try {
            return Short.parseShort(val);
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException(" '" + val + "'");
        }
    }

    public String[] getPropertyGroups(String prefix) {
        Enumeration<?> keys = this.props.propertyNames();
        HashMap<String, String> groups = new HashMap<String, String>(10);
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(prefix)) continue;
            String groupName = key.substring(prefix.length(), key.indexOf(46, prefix.length()));
            groups.put(groupName, groupName);
        }
        return groups.values().toArray(new String[groups.size()]);
    }

    public Properties getPropertyGroup(String prefix) {
        return this.getPropertyGroup(prefix, false);
    }

    public Properties getPropertyGroup(String prefix, boolean stripPrefix) {
        Enumeration<?> keys = this.props.propertyNames();
        Properties group = new Properties();
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(prefix)) continue;
            if (stripPrefix) {
                group.put(key.substring(prefix.length()), this.props.getProperty(key));
                continue;
            }
            group.put(key, this.props.getProperty(key));
        }
        return group;
    }
}

