/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import org.drools.RuntimeDroolsException;
import org.drools.base.SalienceInteger;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.GroupElement;
import org.drools.rule.Pattern;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.spi.Salience;

public class RuleBuilder {
    public void build(RuleBuildContext context) {
        Pattern prefixPattern;
        RuleDescr ruleDescr = context.getRuleDescr();
        RuleConditionBuilder builder = context.getDialect().getBuilder(ruleDescr.getLhs().getClass());
        if (builder != null) {
            prefixPattern = null;
            if (context.getRuleDescr() instanceof QueryDescr) {
                prefixPattern = context.getDialect().getQueryBuilder().build(context, (QueryDescr)context.getRuleDescr());
            }
        } else {
            throw new RuntimeDroolsException("BUG: builder not found for descriptor class " + ruleDescr.getLhs().getClass());
        }
        GroupElement ce = (GroupElement)builder.build(context, ruleDescr.getLhs(), prefixPattern);
        context.getRule().setLhs(ce);
        if (!(ruleDescr instanceof QueryDescr)) {
            context.getDialect().getConsequenceBuilder().build(context);
        }
        String salienceText = context.getRuleDescr().getSalience();
        try {
            if (salienceText != null && !salienceText.equals("")) {
                SalienceInteger salience = new SalienceInteger(Integer.parseInt(salienceText));
                context.getRule().setSalience((Salience)salience);
            }
        }
        catch (Exception e) {
            context.getDialect().getSalienceBuilder().build(context);
        }
        RuleClassBuilder classBuilder = context.getDialect().getRuleClassBuilder();
        if (classBuilder != null) {
            classBuilder.buildRule(context);
        }
    }
}

