/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;
import org.drools.util.FactEntry;
import org.drools.util.Iterator;

public class JoinNode
extends BetaNode {
    private static final long serialVersionUID = 400L;

    public JoinNode(int id, TupleSource leftInput, ObjectSource rightInput, BetaConstraints binder, BuildContext context) {
        super(id, leftInput, rightInput, binder);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void assertTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (this.tupleMemoryEnabled) {
            memory.getTupleMemory().add(leftTuple);
        }
        Iterator it = memory.getFactHandleMemory().iterator(leftTuple);
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        FactEntry entry = (FactEntry)it.next();
        while (entry != null) {
            InternalFactHandle handle = entry.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(memory.getContext(), handle.getObject())) {
                this.sink.propagateAssertTuple(leftTuple, handle, context, workingMemory);
            }
            entry = (FactEntry)it.next();
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getFactHandleMemory().add(handle);
        if (!this.tupleMemoryEnabled) {
            return;
        }
        Iterator it = memory.getTupleMemory().iterator(handle);
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, handle);
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            if (this.constraints.isAllowedCachedRight(memory.getContext(), tuple)) {
                this.sink.propagateAssertTuple(tuple, handle, context, workingMemory);
            }
            tuple = (ReteTuple)it.next();
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        if (!memory.getFactHandleMemory().remove(handle)) {
            return;
        }
        Iterator it = memory.getTupleMemory().iterator(handle);
        this.constraints.updateFromFactHandle(memory.getContext(), workingMemory, handle);
        ReteTuple tuple = (ReteTuple)it.next();
        while (tuple != null) {
            if (this.constraints.isAllowedCachedRight(memory.getContext(), tuple)) {
                this.sink.propagateRetractTuple(tuple, handle, context, workingMemory);
            }
            tuple = (ReteTuple)it.next();
        }
        this.constraints.resetFactHandle(memory.getContext());
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        ReteTuple tuple = memory.getTupleMemory().remove(leftTuple);
        if (tuple == null) {
            return;
        }
        Iterator it = memory.getFactHandleMemory().iterator(leftTuple);
        this.constraints.updateFromTuple(memory.getContext(), workingMemory, leftTuple);
        FactEntry entry = (FactEntry)it.next();
        while (entry != null) {
            InternalFactHandle handle = entry.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(memory.getContext(), handle.getObject())) {
                this.sink.propagateRetractTuple(leftTuple, handle, context, workingMemory);
            }
            entry = (FactEntry)it.next();
        }
        this.constraints.resetTuple(memory.getContext());
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        Iterator tupleIter = memory.getTupleMemory().iterator();
        ReteTuple tuple = (ReteTuple)tupleIter.next();
        while (tuple != null) {
            Iterator objectIter = memory.getFactHandleMemory().iterator(tuple);
            this.constraints.updateFromTuple(memory.getContext(), workingMemory, tuple);
            FactEntry entry = (FactEntry)objectIter.next();
            while (entry != null) {
                InternalFactHandle handle = entry.getFactHandle();
                if (this.constraints.isAllowedCachedLeft(memory.getContext(), handle.getObject())) {
                    sink.assertTuple(new ReteTuple(tuple, handle), context, workingMemory);
                }
                entry = (FactEntry)objectIter.next();
            }
            this.constraints.resetTuple(memory.getContext());
            tuple = (ReteTuple)tupleIter.next();
        }
    }

    public String toString() {
        ObjectSource source = this.rightInput;
        while (!(source instanceof ObjectTypeNode)) {
            source = source.objectSource;
        }
        return "[JoinNode - " + ((ObjectTypeNode)source).getObjectType() + "]";
    }
}

