/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.ser.SerializableUtils;
import com.mchange.v2.ser.UnsupportedVersionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public abstract class WrapperConnectionPoolDataSource
implements ConnectionPoolDataSource,
Referenceable {
    static final Coalescer IMMUTABLES_COALESCER = CoalescerFactory.createCoalescer(true, true);
    transient DataSource nestedDataSource;
    transient int maxStatements = C3P0Defaults.maxStatements();
    transient int initialPoolSize = C3P0Defaults.initialPoolSize();
    transient int minPoolSize = C3P0Defaults.minPoolSize();
    transient int maxPoolSize = C3P0Defaults.maxPoolSize();
    transient int maxIdleTime = C3P0Defaults.maxIdleTime();
    transient int propertyCycle = C3P0Defaults.propertyCycle();
    transient int acquireIncrement = C3P0Defaults.acquireIncrement();
    transient String connectionTesterClassName = C3P0Defaults.connectionTester().getClass().getName();
    transient boolean testConnectionOnCheckout = C3P0Defaults.testConnectionOnCheckout();
    transient String factoryClassLocation;
    transient ConnectionTester connectionTester = C3P0Defaults.connectionTester();
    transient DbAuth auth = null;
    static final String REFADDR_VERSION = "version";
    static final String REFADDR_nestedDataSource = "nestedDataSource";
    static final String REFADDR_maxStatements = "maxStatements";
    static final String REFADDR_initialPoolSize = "initialPoolSize";
    static final String REFADDR_minPoolSize = "minPoolSize";
    static final String REFADDR_maxPoolSize = "maxPoolSize";
    static final String REFADDR_maxIdleTime = "maxIdleTime";
    static final String REFADDR_propertyCycle = "propertyCycle";
    static final String REFADDR_acquireIncrement = "acquireIncrement";
    static final String REFADDR_connectionTesterClassName = "connectionTesterClassName";
    static final String REFADDR_testConnectionOnCheckout = "testConnectionOnCheckout";
    static final int CURRENT_VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$ObjectFactory;

    DataSource getNestedDataSource() {
        return this.nestedDataSource;
    }

    int getMaxStatements() {
        return this.maxStatements;
    }

    int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    int getMinPoolSize() {
        return this.minPoolSize;
    }

    int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    int getPropertyCycle() {
        return this.propertyCycle;
    }

    int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    String getConnectionTesterClassName() {
        return this.connectionTesterClassName;
    }

    boolean isTestConnectionOnCheckout() {
        return this.testConnectionOnCheckout;
    }

    String getUser() {
        return this.auth.getUser();
    }

    String getPassword() {
        return this.auth.getPassword();
    }

    String getFactoryClassLocation() {
        return this.factoryClassLocation;
    }

    void setNestedDataSource(DataSource dataSource) {
        this.nestedDataSource = dataSource;
        this._findAuth();
    }

    void setMaxStatements(int n) {
        this.maxStatements = n;
    }

    void setInitialPoolSize(int n) {
        this.initialPoolSize = n;
    }

    void setMinPoolSize(int n) {
        this.minPoolSize = n;
    }

    void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    void setMaxIdleTime(int n) {
        this.maxIdleTime = n;
    }

    void setPropertyCycle(int n) {
        this.propertyCycle = n;
    }

    void setAcquireIncrement(int n) {
        this.acquireIncrement = n;
    }

    void setConnectionTesterClassName(String string) {
        this.connectionTesterClassName = string;
        this._instantiateConnectionTester();
    }

    void setTestConnectionOnCheckout(boolean bl) {
        this.testConnectionOnCheckout = bl;
    }

    void setFactoryClassLocation(String string) {
        this.factoryClassLocation = string;
    }

    public Immutable asImmutable() {
        return Immutable.find(this.nestedDataSource, this.maxStatements, this.initialPoolSize, this.minPoolSize, this.maxPoolSize, this.maxIdleTime, this.propertyCycle, this.acquireIncrement, this.connectionTesterClassName, this.testConnectionOnCheckout, this.factoryClassLocation);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return new C3P0PooledConnection(this.nestedDataSource.getConnection());
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        return new C3P0PooledConnection(this.nestedDataSource.getConnection(string, string2));
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.nestedDataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.nestedDataSource.setLogWriter(printWriter);
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.nestedDataSource.setLoginTimeout(n);
    }

    public int getLoginTimeout() throws SQLException {
        return this.nestedDataSource.getLoginTimeout();
    }

    void _instantiateConnectionTester() {
        try {
            this.connectionTester = (ConnectionTester)Class.forName(this.connectionTesterClassName).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("Could not instantiate specified connection tester class: " + this.connectionTesterClassName);
        }
    }

    void _findAuth() {
        try {
            this.auth = C3P0ImplUtils.findAuth(this.nestedDataSource);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.auth = C3P0ImplUtils.NULL_AUTH;
        }
    }

    private static boolean parseBoolean(String string) {
        return Boolean.valueOf(string);
    }

    private static char firstChar(String string) {
        return string.charAt(0);
    }

    public final Reference getReference() throws NamingException {
        try {
            Reference reference = new Reference((class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable = WrapperConnectionPoolDataSource.class$("com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable).getName(), (class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$ObjectFactory == null ? (class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$ObjectFactory = WrapperConnectionPoolDataSource.class$("com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSource$ObjectFactory")) : class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$ObjectFactory).getName(), this.factoryClassLocation);
            reference.add(new StringRefAddr(REFADDR_VERSION, String.valueOf(1)));
            reference.add(new BinaryRefAddr(REFADDR_nestedDataSource, SerializableUtils.toByteArray(this.nestedDataSource)));
            reference.add(new StringRefAddr(REFADDR_maxStatements, String.valueOf(this.maxStatements)));
            reference.add(new StringRefAddr(REFADDR_initialPoolSize, String.valueOf(this.initialPoolSize)));
            reference.add(new StringRefAddr(REFADDR_minPoolSize, String.valueOf(this.minPoolSize)));
            reference.add(new StringRefAddr(REFADDR_maxPoolSize, String.valueOf(this.maxPoolSize)));
            reference.add(new StringRefAddr(REFADDR_maxIdleTime, String.valueOf(this.maxIdleTime)));
            reference.add(new StringRefAddr(REFADDR_propertyCycle, String.valueOf(this.propertyCycle)));
            reference.add(new StringRefAddr(REFADDR_acquireIncrement, String.valueOf(this.acquireIncrement)));
            reference.add(new StringRefAddr(REFADDR_connectionTesterClassName, this.connectionTesterClassName));
            reference.add(new StringRefAddr(REFADDR_testConnectionOnCheckout, String.valueOf(this.testConnectionOnCheckout)));
            return reference;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new NamingException("Nested Exception: " + exception.toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Mutable
    extends WrapperConnectionPoolDataSource
    implements Serializable {
        public synchronized DataSource getNestedDataSource() {
            return super.getNestedDataSource();
        }

        public synchronized int getMaxStatements() {
            return super.getMaxStatements();
        }

        public synchronized int getInitialPoolSize() {
            return super.getInitialPoolSize();
        }

        public synchronized int getMinPoolSize() {
            return super.getMinPoolSize();
        }

        public synchronized int getMaxPoolSize() {
            return super.getMaxPoolSize();
        }

        public synchronized int getMaxIdleTime() {
            return super.getMaxIdleTime();
        }

        public synchronized int getPropertyCycle() {
            return super.getPropertyCycle();
        }

        public synchronized int getAcquireIncrement() {
            return super.getAcquireIncrement();
        }

        public synchronized String getConnectionTesterClassName() {
            return super.getConnectionTesterClassName();
        }

        public synchronized boolean isTestConnectionOnCheckout() {
            return super.isTestConnectionOnCheckout();
        }

        public synchronized String getUser() {
            return super.getUser();
        }

        public synchronized String getPassword() {
            return super.getPassword();
        }

        public synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public synchronized void setNestedDataSource(DataSource dataSource) {
            super.setNestedDataSource(dataSource);
        }

        public synchronized void setMaxStatements(int n) {
            super.setMaxStatements(n);
        }

        public synchronized void setInitialPoolSize(int n) {
            super.setInitialPoolSize(n);
        }

        public synchronized void setMinPoolSize(int n) {
            super.setMinPoolSize(n);
        }

        public synchronized void setMaxPoolSize(int n) {
            super.setMaxPoolSize(n);
        }

        public synchronized void setMaxIdleTime(int n) {
            super.setMaxIdleTime(n);
        }

        public synchronized void setPropertyCycle(int n) {
            super.setPropertyCycle(n);
        }

        public synchronized void setAcquireIncrement(int n) {
            super.setAcquireIncrement(n);
        }

        public synchronized void setConnectionTesterClassName(String string) {
            super.setConnectionTesterClassName(string);
        }

        public synchronized void setTestConnectionOnCheckout(boolean bl) {
            super.setTestConnectionOnCheckout(bl);
        }

        public synchronized void setFactoryClassLocation(String string) {
            super.setFactoryClassLocation(string);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of WrapperConnectionPoolDataSource");
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            throw new IOException("We should not be finding this mutable version of WrapperConnectionPoolDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static abstract class Base
    extends WrapperConnectionPoolDataSource
    implements Serializable {
        protected synchronized DataSource getNestedDataSource() {
            return super.getNestedDataSource();
        }

        protected synchronized int getMaxStatements() {
            return super.getMaxStatements();
        }

        protected synchronized int getInitialPoolSize() {
            return super.getInitialPoolSize();
        }

        protected synchronized int getMinPoolSize() {
            return super.getMinPoolSize();
        }

        protected synchronized int getMaxPoolSize() {
            return super.getMaxPoolSize();
        }

        protected synchronized int getMaxIdleTime() {
            return super.getMaxIdleTime();
        }

        protected synchronized int getPropertyCycle() {
            return super.getPropertyCycle();
        }

        protected synchronized int getAcquireIncrement() {
            return super.getAcquireIncrement();
        }

        protected synchronized String getConnectionTesterClassName() {
            return super.getConnectionTesterClassName();
        }

        protected synchronized boolean isTestConnectionOnCheckout() {
            return super.isTestConnectionOnCheckout();
        }

        protected synchronized String getUser() {
            return super.getUser();
        }

        protected synchronized String getPassword() {
            return super.getPassword();
        }

        protected synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        protected synchronized void setNestedDataSource(DataSource dataSource) {
            super.setNestedDataSource(dataSource);
        }

        protected synchronized void setMaxStatements(int n) {
            super.setMaxStatements(n);
        }

        protected synchronized void setInitialPoolSize(int n) {
            super.setInitialPoolSize(n);
        }

        protected synchronized void setMinPoolSize(int n) {
            super.setMinPoolSize(n);
        }

        protected synchronized void setMaxPoolSize(int n) {
            super.setMaxPoolSize(n);
        }

        protected synchronized void setMaxIdleTime(int n) {
            super.setMaxIdleTime(n);
        }

        protected synchronized void setPropertyCycle(int n) {
            super.setPropertyCycle(n);
        }

        protected synchronized void setAcquireIncrement(int n) {
            super.setAcquireIncrement(n);
        }

        protected synchronized void setConnectionTesterClassName(String string) {
            super.setConnectionTesterClassName(string);
        }

        protected synchronized void setTestConnectionOnCheckout(boolean bl) {
            super.setTestConnectionOnCheckout(bl);
        }

        protected synchronized void setFactoryClassLocation(String string) {
            super.setFactoryClassLocation(string);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of WrapperConnectionPoolDataSource");
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            throw new IOException("We should not be finding this mutable version of WrapperConnectionPoolDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static final class Immutable
    extends WrapperConnectionPoolDataSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final short VERSION = 1;

        public static Immutable find(DataSource dataSource, int n, int n2, int n3, int n4, int n5, int n6, int n7, String string, boolean bl, String string2) {
            Immutable immutable = new Immutable();
            immutable.nestedDataSource = dataSource;
            immutable._findAuth();
            immutable.maxStatements = n;
            immutable.initialPoolSize = n2;
            immutable.minPoolSize = n3;
            immutable.maxPoolSize = n4;
            immutable.maxIdleTime = n5;
            immutable.propertyCycle = n6;
            immutable.acquireIncrement = n7;
            immutable.connectionTesterClassName = string;
            immutable._instantiateConnectionTester();
            immutable.testConnectionOnCheckout = bl;
            immutable.factoryClassLocation = string2;
            return (Immutable)IMMUTABLES_COALESCER.coalesce(immutable);
        }

        private Immutable() {
        }

        public DataSource getNestedDataSource() {
            return super.getNestedDataSource();
        }

        public int getMaxStatements() {
            return super.getMaxStatements();
        }

        public int getInitialPoolSize() {
            return super.getInitialPoolSize();
        }

        public int getMinPoolSize() {
            return super.getMinPoolSize();
        }

        public int getMaxPoolSize() {
            return super.getMaxPoolSize();
        }

        public int getMaxIdleTime() {
            return super.getMaxIdleTime();
        }

        public int getPropertyCycle() {
            return super.getPropertyCycle();
        }

        public int getAcquireIncrement() {
            return super.getAcquireIncrement();
        }

        public String getConnectionTesterClassName() {
            return super.getConnectionTesterClassName();
        }

        public boolean isTestConnectionOnCheckout() {
            return super.isTestConnectionOnCheckout();
        }

        public String getUser() {
            return super.getUser();
        }

        public String getPassword() {
            return super.getPassword();
        }

        public String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public Immutable asImmutable() {
            return this;
        }

        public boolean equals(Object object) {
            if (object instanceof Immutable) {
                Immutable immutable = (Immutable)object;
                return ObjectUtils.eqOrBothNull(this.nestedDataSource, immutable.nestedDataSource) && this.maxStatements == immutable.maxStatements && this.initialPoolSize == immutable.initialPoolSize && this.minPoolSize == immutable.minPoolSize && this.maxPoolSize == immutable.maxPoolSize && this.maxIdleTime == immutable.maxIdleTime && this.propertyCycle == immutable.propertyCycle && this.acquireIncrement == immutable.acquireIncrement && ObjectUtils.eqOrBothNull(this.connectionTesterClassName, immutable.connectionTesterClassName) && this.testConnectionOnCheckout == immutable.testConnectionOnCheckout && ObjectUtils.eqOrBothNull(this.factoryClassLocation, immutable.factoryClassLocation);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtils.hashOrZero(this.nestedDataSource) ^ this.maxStatements ^ this.initialPoolSize ^ this.minPoolSize ^ this.maxPoolSize ^ this.maxIdleTime ^ this.propertyCycle ^ this.acquireIncrement ^ ObjectUtils.hashOrZero(this.connectionTesterClassName) ^ (this.testConnectionOnCheckout ? 1 : 0) ^ ObjectUtils.hashOrZero(this.factoryClassLocation);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeShort(1);
            objectOutputStream.writeObject(this.nestedDataSource);
            objectOutputStream.writeInt(this.maxStatements);
            objectOutputStream.writeInt(this.initialPoolSize);
            objectOutputStream.writeInt(this.minPoolSize);
            objectOutputStream.writeInt(this.maxPoolSize);
            objectOutputStream.writeInt(this.maxIdleTime);
            objectOutputStream.writeInt(this.propertyCycle);
            objectOutputStream.writeInt(this.acquireIncrement);
            objectOutputStream.writeObject(this.connectionTesterClassName);
            objectOutputStream.writeBoolean(this.testConnectionOnCheckout);
            objectOutputStream.writeObject(this.factoryClassLocation);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            short s = objectInputStream.readShort();
            switch (s) {
                case 1: {
                    this.nestedDataSource = (DataSource)objectInputStream.readObject();
                    this._findAuth();
                    this.maxStatements = objectInputStream.readInt();
                    this.initialPoolSize = objectInputStream.readInt();
                    this.minPoolSize = objectInputStream.readInt();
                    this.maxPoolSize = objectInputStream.readInt();
                    this.maxIdleTime = objectInputStream.readInt();
                    this.propertyCycle = objectInputStream.readInt();
                    this.acquireIncrement = objectInputStream.readInt();
                    this.connectionTesterClassName = (String)objectInputStream.readObject();
                    this._instantiateConnectionTester();
                    this.testConnectionOnCheckout = objectInputStream.readBoolean();
                    this.factoryClassLocation = (String)objectInputStream.readObject();
                    break;
                }
                default: {
                    throw new UnsupportedVersionException(this, s);
                }
            }
        }
    }

    public static class ObjectFactory
    implements javax.naming.spi.ObjectFactory {
        static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable;

        public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
            Reference reference;
            String string = (class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable = ObjectFactory.class$("com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$WrapperConnectionPoolDataSource$Immutable).getName();
            if (object instanceof Reference && (reference = (Reference)object).getClassName().equals(string)) {
                int n = Integer.parseInt((String)reference.get(WrapperConnectionPoolDataSource.REFADDR_VERSION).getContent());
                if (n == 1) {
                    DataSource dataSource = (DataSource)SerializableUtils.fromByteArray((byte[])reference.get(WrapperConnectionPoolDataSource.REFADDR_nestedDataSource).getContent());
                    int n2 = Integer.parseInt((String)reference.get(WrapperConnectionPoolDataSource.REFADDR_maxStatements).getContent());
                    int n3 = Integer.parseInt((String)reference.get(WrapperConnectionPoolDataSource.REFADDR_initialPoolSize).getContent());
                    int n4 = Integer.parseInt((String)reference.get(WrapperConnectionPoolDataSource.REFADDR_minPoolSize).getContent());
                    int n5 = Integer.parseInt((String)reference.get(WrapperConnectionPoolDataSource.REFADDR_maxPoolSize).getContent());
                    int n6 = Integer.parseInt((String)reference.get(WrapperConnectionPoolDataSource.REFADDR_maxIdleTime).getContent());
                    int n7 = Integer.parseInt((String)reference.get(WrapperConnectionPoolDataSource.REFADDR_propertyCycle).getContent());
                    int n8 = Integer.parseInt((String)reference.get(WrapperConnectionPoolDataSource.REFADDR_acquireIncrement).getContent());
                    String string2 = (String)reference.get(WrapperConnectionPoolDataSource.REFADDR_connectionTesterClassName).getContent();
                    boolean bl = WrapperConnectionPoolDataSource.parseBoolean((String)reference.get(WrapperConnectionPoolDataSource.REFADDR_testConnectionOnCheckout).getContent());
                    return Immutable.find(dataSource, n2, n3, n4, n5, n6, n7, n8, string2, bl, reference.getFactoryClassLocation());
                }
                throw new NamingException("Cannot resolve reference (version " + n + " unknown.");
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

