/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.persistence.Entity;
import org.jboss.annotation.ejb.Consumer;
import org.jboss.annotation.ejb.Depends;
import org.jboss.annotation.ejb.Service;
import org.jboss.aop.AspectManager;
import org.jboss.aop.DomainDefinition;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.Ejb3Handler;
import org.jboss.ejb3.mdb.ConsumerContainer;
import org.jboss.ejb3.mdb.ConsumerManager;
import org.jboss.ejb3.mdb.MDB;
import org.jboss.ejb3.mdb.MessageDrivenManager;
import org.jboss.ejb3.plugins.inflow.JBossMessageEndpointFactory;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.ejb3.service.ServiceManager;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulManager;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.ejb3.stateless.StatelessManager;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3AnnotationHandler
implements Ejb3Handler {
    private static final Logger log = Logger.getLogger(Ejb3AnnotationHandler.class);
    protected DeploymentUnit di;
    protected ClassFile cf;
    protected List<String> ejbNames = new ArrayList<String>();
    protected Class ejbClass;
    protected String className;
    protected EJB_TYPE ejbType;
    protected Annotation annotation;
    protected AnnotationsAttribute visible;
    protected Hashtable ctxProperties;
    protected String defaultSLSBDomain;
    protected String defaultSFSBDomain;
    protected String defaultMDBDomain;
    protected String defaultMessagingInflowDrivenBeanDomain;
    protected String defaultServiceDomain;
    protected String defaultConsumerDomain;
    protected Ejb3Deployment deployment;

    public Ejb3AnnotationHandler(Ejb3Deployment deployment, ClassFile cf) {
        this.deployment = deployment;
        this.di = deployment.getDeploymentUnit();
        this.cf = cf;
        this.className = cf.getName();
        this.visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        this.defaultSLSBDomain = deployment.getDefaultSLSBDomain();
        this.defaultSFSBDomain = deployment.getDefaultSFSBDomain();
        this.defaultMDBDomain = deployment.getDefaultMDBDomain();
        this.defaultServiceDomain = deployment.getDefaultServiceDomain();
        this.defaultConsumerDomain = deployment.getDefaultConsumerDomain();
        this.defaultMessagingInflowDrivenBeanDomain = deployment.getDefaultMessageInflowDrivenBeanDomain();
    }

    @Override
    public void setCtxProperties(Hashtable ctxProperties) {
        this.ctxProperties = ctxProperties;
    }

    private String getJaccContextId() {
        return this.di.getShortName();
    }

    @Override
    public boolean isEjb() {
        if (this.visible == null) {
            return false;
        }
        if (EJB3Util.isStateless(this.visible)) {
            return true;
        }
        if (EJB3Util.isMessageDriven(this.visible)) {
            return true;
        }
        return EJB3Util.isStatefulSession(this.visible);
    }

    @Override
    public boolean isJBossBeanType() {
        if (this.visible == null) {
            return false;
        }
        if (EJB3Util.isService(this.visible)) {
            return true;
        }
        return EJB3Util.isConsumer(this.visible);
    }

    public List getContainers(ClassFile cf, Ejb3Deployment deployment) throws Exception {
        ArrayList<StatelessManager> containers = new ArrayList<StatelessManager>();
        ServiceMBeanSupport manager = null;
        this.populateBaseInfo();
        for (int ejbIndex = 0; ejbIndex < this.ejbNames.size(); ++ejbIndex) {
            EJBContainer container;
            String ejbName = this.ejbNames.get(ejbIndex);
            if (this.ejbType == EJB_TYPE.STATELESS) {
                container = this.getStatelessContainer(ejbIndex);
                container.setDefaultClientBinding(deployment.getDefaultClientBinding());
                manager = new StatelessManager((StatelessContainer)container, this.getJaccContextId());
                containers.add((StatelessManager)manager);
            } else if (this.ejbType == EJB_TYPE.STATEFUL) {
                container = this.getStatefulContainer(ejbIndex);
                container.setDefaultClientBinding(deployment.getDefaultClientBinding());
                manager = new StatefulManager((StatefulContainer)container, this.getJaccContextId());
                containers.add((StatelessManager)manager);
            } else if (this.ejbType == EJB_TYPE.MESSAGE_DRIVEN) {
                container = this.getMDB(ejbIndex);
                manager = new MessageDrivenManager((MDB)container, this.getJaccContextId());
                containers.add((StatelessManager)manager);
            } else if (this.ejbType == EJB_TYPE.SERVICE) {
                container = this.getServiceContainer(ejbIndex);
                manager = new ServiceManager((ServiceContainer)container, this.getJaccContextId());
                containers.add((StatelessManager)manager);
            } else if (this.ejbType == EJB_TYPE.CONSUMER) {
                container = this.getConsumerContainer(ejbIndex);
                manager = new ConsumerManager((ConsumerContainer)container, this.getJaccContextId());
                containers.add((StatelessManager)manager);
            }
            log.info((Object)("found EJB3: ejbName=" + ejbName + ", class=" + this.className + ", type=" + (Object)((Object)this.ejbType)));
        }
        return containers;
    }

    protected ServiceContainer getServiceContainer(int ejbIndex) throws Exception {
        String containerName = EJB3Util.getAspectDomain(this.visible, this.defaultServiceDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        ServiceContainer container = new ServiceContainer(this.deployment.getMbeanServer(), this.di.getClassLoader(), this.cf.getName(), this.ejbNames.get(ejbIndex), domain.getManager(), this.ctxProperties, this.di.getInterceptorInfoRepository());
        container.setDeployment(this.deployment);
        return container;
    }

    protected ConsumerContainer getConsumerContainer(int ejbIndex) throws Exception {
        String containerName = EJB3Util.getAspectDomain(this.visible, this.defaultConsumerDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        ConsumerContainer container = new ConsumerContainer(this.ejbNames.get(ejbIndex), domain.getManager(), this.di.getClassLoader(), this.cf.getName(), this.ctxProperties, this.di.getInterceptorInfoRepository());
        container.setDeployment(this.deployment);
        return container;
    }

    protected StatefulContainer getStatefulContainer(int ejbIndex) throws Exception {
        String containerName = EJB3Util.getAspectDomain(this.visible, this.defaultSFSBDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        StatefulContainer container = new StatefulContainer(this.di.getClassLoader(), this.cf.getName(), this.ejbNames.get(ejbIndex), domain.getManager(), this.ctxProperties, this.di.getInterceptorInfoRepository());
        container.setDeployment(this.deployment);
        return container;
    }

    protected StatelessContainer getStatelessContainer(int ejbIndex) throws Exception {
        String containerName = EJB3Util.getAspectDomain(this.visible, this.defaultSLSBDomain);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        StatelessContainer container = new StatelessContainer(this.di.getClassLoader(), this.cf.getName(), this.ejbNames.get(ejbIndex), domain.getManager(), this.ctxProperties, this.di.getInterceptorInfoRepository());
        container.setDeployment(this.deployment);
        return container;
    }

    protected String getMDBDomainName(int ejbIndex) {
        String domainName = this.defaultMDBDomain;
        MessageDriven annotation = this.ejbClass.getAnnotation(MessageDriven.class);
        if (annotation != null) {
            for (ActivationConfigProperty property : annotation.activateConfig()) {
                if (!property.propertyName().equals("resourceAdaptorName")) continue;
                domainName = this.defaultMessagingInflowDrivenBeanDomain;
            }
        }
        return domainName;
    }

    protected void createProxyFactories() {
    }

    protected MDB getMDB(int ejbIndex) throws Exception {
        String domainName = this.getMDBDomainName(ejbIndex);
        String containerName = EJB3Util.getAspectDomain(this.visible, domainName);
        DomainDefinition domain = AspectManager.instance().getContainer(containerName);
        if (domain == null) {
            throw new RuntimeException("No container configured with name '" + containerName + "''");
        }
        MDB container = new MDB(this.ejbNames.get(ejbIndex), domain.getManager(), this.di.getClassLoader(), this.cf.getName(), this.ctxProperties, this.di.getInterceptorInfoRepository());
        container.setDeployment(this.deployment);
        if (domainName.equals(this.defaultMessagingInflowDrivenBeanDomain)) {
            JBossMessageEndpointFactory factory = (JBossMessageEndpointFactory)this.di.getClassLoader().loadClass("org.jboss.ejb3.plugins.inflow.JBossMessageEndpointFactory").newInstance();
            factory.setContainer(container);
            container.setProxyFactory(factory);
        }
        return container;
    }

    protected void populateBaseInfo() throws Exception {
        String ejbName = null;
        this.ejbClass = this.di.getClassLoader().loadClass(this.className);
        this.visible = (AnnotationsAttribute)this.cf.getAttribute("RuntimeVisibleAnnotations");
        if (this.visible != null) {
            this.annotation = this.visible.getAnnotation(Stateless.class.getName());
            if (this.annotation != null) {
                this.ejbType = EJB_TYPE.STATELESS;
            } else {
                this.annotation = this.visible.getAnnotation(Stateful.class.getName());
                if (this.annotation != null) {
                    this.ejbType = EJB_TYPE.STATEFUL;
                } else {
                    this.annotation = this.visible.getAnnotation(Entity.class.getName());
                    if (this.annotation != null) {
                        this.ejbType = EJB_TYPE.ENTITY;
                    } else {
                        this.annotation = this.visible.getAnnotation(MessageDriven.class.getName());
                        if (this.annotation != null) {
                            this.ejbType = EJB_TYPE.MESSAGE_DRIVEN;
                        } else {
                            this.annotation = this.visible.getAnnotation(Service.class.getName());
                            if (this.annotation != null) {
                                this.ejbType = EJB_TYPE.SERVICE;
                            } else {
                                this.annotation = this.visible.getAnnotation(Consumer.class.getName());
                                if (this.annotation != null) {
                                    this.ejbType = EJB_TYPE.CONSUMER;
                                }
                            }
                        }
                    }
                }
            }
            if (this.annotation != null) {
                StringMemberValue mv = (StringMemberValue)this.annotation.getMemberValue("name");
                ejbName = mv != null ? mv.getValue() : this.cf.getName();
            }
        }
        if (ejbName != null) {
            this.ejbNames.add(ejbName);
        }
    }

    @Override
    public List<Collection> getAllDepends() {
        ArrayList<Collection> dependsList = new ArrayList<Collection>();
        ArrayList depends = new ArrayList();
        if (this.visible != null) {
            Annotation binfo;
            AnnotationsAttribute mgroup;
            Annotation annotation = this.visible.getAnnotation(Depends.class.getName());
            depends = this.getDependsValues(depends, annotation);
            for (MethodInfo minfo : this.cf.getMethods()) {
                mgroup = (AnnotationsAttribute)minfo.getAttribute("RuntimeVisibleAnnotations");
                if (mgroup == null) continue;
                binfo = mgroup.getAnnotation(Depends.class.getName());
                depends = this.getDependsValues(depends, binfo);
            }
            for (FieldInfo finfo : this.cf.getFields()) {
                mgroup = (AnnotationsAttribute)finfo.getAttribute("RuntimeVisibleAnnotations");
                if (mgroup == null) continue;
                binfo = mgroup.getAnnotation(Depends.class.getName());
                depends = this.getDependsValues(depends, binfo);
            }
            dependsList.add(depends);
        }
        return dependsList;
    }

    private ArrayList getDependsValues(ArrayList depends, Annotation info) {
        if (info == null) {
            return depends;
        }
        ArrayMemberValue amv = (ArrayMemberValue)info.getMemberValue("value");
        MemberValue[] values = amv.getValue();
        for (int i = 0; i < values.length; ++i) {
            StringMemberValue sv = (StringMemberValue)values[i];
            try {
                ObjectName on = new ObjectName(sv.getValue());
                if (depends == null) {
                    depends = new ArrayList<ObjectName>();
                }
                depends.add(on);
                continue;
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException("'" + sv.getValue() + "' is not a valid object name");
            }
        }
        return depends;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum EJB_TYPE {
        STATELESS,
        STATEFUL,
        MESSAGE_DRIVEN,
        ENTITY,
        SERVICE,
        CONSUMER;

    }
}

