/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.webapp.command.NOOP;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.FixedXMLContentHandler;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.util.MonitorRunner;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class SendUpdatedViews
implements Server,
Runnable {
    private static final NOOP NOOPCommand = new NOOP();
    private static final Runnable NOOP = new Runnable(){

        public void run() {
        }
    };
    private static final ResponseHandler NOOPResponse = new FixedXMLContentHandler(){

        public void writeTo(Writer writer) throws IOException {
            NOOPCommand.serializeTo(writer);
        }
    };
    private static final ResponseHandler CloseResponse = new ResponseHandler(){

        public void respond(Response response) throws Exception {
            response.setHeader("X-Connection", "close");
            response.setHeader("Content-Length", 0);
        }
    };
    private static final Server AfterShutdown = new Server(){

        public void service(Request request) throws Exception {
            request.respondWith(CloseResponse);
        }

        public void shutdown() {
        }
    };
    private final BlockingQueue pendingRequest = new LinkedBlockingQueue(1);
    private final ViewQueue allUpdatedViews;
    private final Collection synchronouslyUpdatedViews;
    private final String sessionID;
    private final long timeoutInterval;
    private long responseTimeoutTime;
    private Server server;

    public SendUpdatedViews(String sessionID, Collection synchronouslyUpdatedViews, final ViewQueue allUpdatedViews, final MonitorRunner monitorRunner, Configuration configuration) {
        this.timeoutInterval = configuration.getAttributeAsLong("blockingConnectionTimeout", 90000L);
        this.sessionID = sessionID;
        this.allUpdatedViews = allUpdatedViews;
        this.synchronouslyUpdatedViews = synchronouslyUpdatedViews;
        this.allUpdatedViews.onPut(new Runnable(){

            public void run() {
                SendUpdatedViews.this.respondIfViewsAvailable();
            }
        });
        monitorRunner.registerMonitor(this);
        this.server = new Server(){

            public void service(Request request) throws Exception {
                SendUpdatedViews.this.responseTimeoutTime = System.currentTimeMillis() + SendUpdatedViews.this.timeoutInterval;
                SendUpdatedViews.this.respondIfPendingRequest(CloseResponse);
                SendUpdatedViews.this.pendingRequest.put((Object)request);
                SendUpdatedViews.this.respondIfViewsAvailable();
            }

            public void shutdown() {
                monitorRunner.unregisterMonitor(SendUpdatedViews.this);
                allUpdatedViews.onPut(NOOP);
                SendUpdatedViews.this.server = AfterShutdown;
                SendUpdatedViews.this.respondIfPendingRequest(CloseResponse);
            }
        };
    }

    public void service(Request request) throws Exception {
        this.server.service(request);
    }

    public void shutdown() {
        this.server.shutdown();
    }

    public void run() {
        if (System.currentTimeMillis() > this.responseTimeoutTime && !this.pendingRequest.isEmpty()) {
            this.respondIfPendingRequest(NOOPResponse);
        }
    }

    private void respondIfViewsAvailable() {
        try {
            Request request;
            this.allUpdatedViews.removeAll(this.synchronouslyUpdatedViews);
            this.synchronouslyUpdatedViews.clear();
            if (!this.allUpdatedViews.isEmpty() && (request = (Request)this.pendingRequest.poll()) != null) {
                request.respondWith(new FixedXMLContentHandler(){

                    public void writeTo(Writer writer) throws IOException {
                        writer.write("<updated-views>");
                        Iterator i = new HashSet(SendUpdatedViews.this.allUpdatedViews).iterator();
                        while (i.hasNext()) {
                            writer.write(SendUpdatedViews.this.sessionID);
                            writer.write(":");
                            writer.write((String)i.next());
                            writer.write(32);
                        }
                        writer.write("</updated-views>");
                        SendUpdatedViews.this.allUpdatedViews.clear();
                    }
                });
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void respondIfPendingRequest(ResponseHandler handler) {
        Request previousRequest = (Request)this.pendingRequest.poll();
        if (previousRequest != null) {
            try {
                previousRequest.respondWith(handler);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

