/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.cluster.web.notification;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;

import org.jboss.test.cluster.web.notification.MockHttpSessionBindingListener.Type;

/**
 * @author Brian Stansberry
 *
 */
public class MockHttpSessionAttributeListener implements HttpSessionAttributeListener
{
   public enum Type { ADDED, REMOVED, REPLACED };
   
   public final List<Type> invocations = new ArrayList<Type>();

   /* (non-Javadoc)
    * @see javax.servlet.http.HttpSessionAttributeListener#attributeAdded(javax.servlet.http.HttpSessionBindingEvent)
    */
   public void attributeAdded(HttpSessionBindingEvent arg0)
   {
      invocations.add(Type.ADDED);
   }

   /* (non-Javadoc)
    * @see javax.servlet.http.HttpSessionAttributeListener#attributeRemoved(javax.servlet.http.HttpSessionBindingEvent)
    */
   public void attributeRemoved(HttpSessionBindingEvent arg0)
   {
      invocations.add(Type.REMOVED);
   }

   /* (non-Javadoc)
    * @see javax.servlet.http.HttpSessionAttributeListener#attributeReplaced(javax.servlet.http.HttpSessionBindingEvent)
    */
   public void attributeReplaced(HttpSessionBindingEvent arg0)
   {
      invocations.add(Type.REPLACED);
   }

}
