/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.CircularRedirectException;
import org.apache.commons.httpclient.ConnectMethod;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.RedirectException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthChallengeException;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthChallengeProcessor;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.AuthState;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HttpMethodDirector {
    public static final String WWW_AUTH_CHALLENGE = "WWW-Authenticate";
    public static final String WWW_AUTH_RESP = "Authorization";
    public static final String PROXY_AUTH_CHALLENGE = "Proxy-Authenticate";
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";
    private static final Log LOG = LogFactory.getLog(HttpMethodDirector.class);
    private ConnectMethod connectMethod;
    private HttpState state;
    private HostConfiguration hostConfiguration;
    private HttpConnectionManager connectionManager;
    private HttpClientParams params;
    private HttpConnection conn;
    private boolean releaseConnection = false;
    private AuthChallengeProcessor authProcessor = null;
    private Set redirectLocations = null;

    public HttpMethodDirector(HttpConnectionManager httpConnectionManager, HostConfiguration hostConfiguration, HttpClientParams httpClientParams, HttpState httpState) {
        this.connectionManager = httpConnectionManager;
        this.hostConfiguration = hostConfiguration;
        this.params = httpClientParams;
        this.state = httpState;
        this.authProcessor = new AuthChallengeProcessor(this.params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMethod(HttpMethod httpMethod) throws IOException, HttpException {
        if (httpMethod == null) {
            throw new IllegalArgumentException("Method may not be null");
        }
        this.hostConfiguration.getParams().setDefaults(this.params);
        httpMethod.getParams().setDefaults(this.hostConfiguration.getParams());
        Collection collection = (Collection)this.hostConfiguration.getParams().getParameter("http.default-headers");
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                httpMethod.addRequestHeader((Header)iterator.next());
            }
        }
        try {
            int n = this.params.getIntParameter("http.protocol.max-redirects", 100);
            int n2 = 0;
            while (true) {
                if (this.conn != null && !this.hostConfiguration.hostEquals(this.conn)) {
                    this.conn.setLocked(false);
                    this.conn.releaseConnection();
                    this.conn = null;
                }
                if (this.conn == null) {
                    this.conn = this.connectionManager.getConnectionWithTimeout(this.hostConfiguration, this.params.getConnectionManagerTimeout());
                    this.conn.setLocked(true);
                    if (this.params.isAuthenticationPreemptive() || this.state.isAuthenticationPreemptive()) {
                        LOG.debug((Object)"Preemptively sending default basic credentials");
                        httpMethod.getHostAuthState().setPreemptive();
                        httpMethod.getHostAuthState().setAuthAttempted(true);
                        if (this.conn.isProxied() && !this.conn.isSecure()) {
                            httpMethod.getProxyAuthState().setPreemptive();
                            httpMethod.getProxyAuthState().setAuthAttempted(true);
                        }
                    }
                }
                this.authenticate(httpMethod);
                this.executeWithRetry(httpMethod);
                if (this.connectMethod != null) {
                    this.fakeResponse(httpMethod);
                    break;
                }
                boolean bl = false;
                if (this.isRedirectNeeded(httpMethod) && this.processRedirectResponse(httpMethod)) {
                    bl = true;
                    if (++n2 >= n) {
                        LOG.error((Object)"Narrowly avoided an infinite loop in execute");
                        throw new RedirectException("Maximum redirects (" + n + ") exceeded");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Execute redirect " + n2 + " of " + n));
                    }
                }
                if (this.isAuthenticationNeeded(httpMethod) && this.processAuthenticationResponse(httpMethod)) {
                    LOG.debug((Object)"Retry authentication");
                    bl = true;
                }
                if (!bl) {
                    break;
                }
                if (httpMethod.getResponseBodyAsStream() == null) continue;
                httpMethod.getResponseBodyAsStream().close();
            }
        }
        finally {
            if (this.conn != null) {
                this.conn.setLocked(false);
            }
            if ((this.releaseConnection || httpMethod.getResponseBodyAsStream() == null) && this.conn != null) {
                this.conn.releaseConnection();
            }
        }
    }

    private void authenticate(HttpMethod httpMethod) {
        try {
            if (this.conn.isProxied() && !this.conn.isSecure()) {
                this.authenticateProxy(httpMethod);
            }
            this.authenticateHost(httpMethod);
        }
        catch (AuthenticationException authenticationException) {
            LOG.error((Object)authenticationException.getMessage(), (Throwable)authenticationException);
        }
    }

    private boolean cleanAuthHeaders(HttpMethod httpMethod, String string) {
        Header[] headerArray = httpMethod.getRequestHeaders(string);
        boolean bl = true;
        for (int i = 0; i < headerArray.length; ++i) {
            Header header = headerArray[i];
            if (header.isAutogenerated()) {
                httpMethod.removeRequestHeader(header);
                continue;
            }
            bl = false;
        }
        return bl;
    }

    private void authenticateHost(HttpMethod httpMethod) throws AuthenticationException {
        if (!this.cleanAuthHeaders(httpMethod, WWW_AUTH_RESP)) {
            return;
        }
        AuthState authState = httpMethod.getHostAuthState();
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null) {
            return;
        }
        if (authState.isAuthRequested() || !authScheme.isConnectionBased()) {
            Credentials credentials;
            String string = httpMethod.getParams().getVirtualHost();
            if (string == null) {
                string = this.conn.getHost();
            }
            int n = this.conn.getPort();
            AuthScope authScope = new AuthScope(string, n, authScheme.getRealm(), authScheme.getSchemeName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Authenticating with " + authScope));
            }
            if ((credentials = this.state.getCredentials(authScope)) != null) {
                String string2 = authScheme.authenticate(credentials, httpMethod);
                if (string2 != null) {
                    httpMethod.addRequestHeader(new Header(WWW_AUTH_RESP, string2, true));
                }
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Required credentials not available for " + authScope));
                if (httpMethod.getHostAuthState().isPreemptive()) {
                    LOG.warn((Object)"Preemptive authentication requested but no default credentials available");
                }
            }
        }
    }

    private void authenticateProxy(HttpMethod httpMethod) throws AuthenticationException {
        if (!this.cleanAuthHeaders(httpMethod, PROXY_AUTH_RESP)) {
            return;
        }
        AuthState authState = httpMethod.getProxyAuthState();
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null) {
            return;
        }
        if (authState.isAuthRequested() || !authScheme.isConnectionBased()) {
            Credentials credentials;
            AuthScope authScope = new AuthScope(this.conn.getProxyHost(), this.conn.getProxyPort(), authScheme.getRealm(), authScheme.getSchemeName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Authenticating with " + authScope));
            }
            if ((credentials = this.state.getProxyCredentials(authScope)) != null) {
                String string = authScheme.authenticate(credentials, httpMethod);
                if (string != null) {
                    httpMethod.addRequestHeader(new Header(PROXY_AUTH_RESP, string, true));
                }
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Required proxy credentials not available for " + authScope));
                if (httpMethod.getProxyAuthState().isPreemptive()) {
                    LOG.warn((Object)"Preemptive authentication requested but no default proxy credentials available");
                }
            }
        }
    }

    private void applyConnectionParams(HttpMethod httpMethod) throws IOException {
        int n = 0;
        Object object = httpMethod.getParams().getParameter("http.socket.timeout");
        if (object == null) {
            object = this.conn.getParams().getParameter("http.socket.timeout");
        }
        if (object != null) {
            n = (Integer)object;
        }
        this.conn.setSocketTimeout(n);
    }

    private void executeWithRetry(HttpMethod httpMethod) throws IOException, HttpException {
        int n = 0;
        try {
            while (true) {
                ++n;
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Attempt number " + n + " to process request"));
                    }
                    if (this.conn.getParams().isStaleCheckingEnabled()) {
                        this.conn.closeIfStale();
                    }
                    if (!this.conn.isOpen()) {
                        this.conn.open();
                        if (this.conn.isProxied() && this.conn.isSecure() && !(httpMethod instanceof ConnectMethod) && !this.executeConnect()) {
                            return;
                        }
                    }
                    this.applyConnectionParams(httpMethod);
                    httpMethod.execute(this.state, this.conn);
                }
                catch (HttpException httpException) {
                    throw httpException;
                }
                catch (IOException iOException) {
                    Object object;
                    LOG.debug((Object)"Closing the connection.");
                    this.conn.close();
                    if (httpMethod instanceof HttpMethodBase && (object = ((HttpMethodBase)httpMethod).getMethodRetryHandler()) != null && !object.retryMethod(httpMethod, this.conn, new HttpRecoverableException(iOException.getMessage()), n, httpMethod.isRequestSent())) {
                        LOG.debug((Object)"Method retry handler returned false. Automatic recovery will not be attempted");
                        throw iOException;
                    }
                    object = (HttpMethodRetryHandler)httpMethod.getParams().getParameter("http.method.retry-handler");
                    if (object == null) {
                        object = new DefaultHttpMethodRetryHandler();
                    }
                    if (!object.retryMethod(httpMethod, iOException, n)) {
                        LOG.debug((Object)"Method retry handler returned false. Automatic recovery will not be attempted");
                        throw iOException;
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("I/O exception (" + iOException.getClass().getName() + ") caught when processing request: " + iOException.getMessage()));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)iOException.getMessage(), (Throwable)iOException);
                    }
                    LOG.info((Object)"Retrying request");
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            if (this.conn.isOpen()) {
                LOG.debug((Object)"Closing the connection.");
                this.conn.close();
            }
            this.releaseConnection = true;
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            if (this.conn.isOpen) {
                LOG.debug((Object)"Closing the connection.");
                this.conn.close();
            }
            this.releaseConnection = true;
            throw runtimeException;
        }
    }

    private boolean executeConnect() throws IOException, HttpException {
        int n;
        this.connectMethod = new ConnectMethod();
        this.connectMethod.getParams().setDefaults(this.hostConfiguration.getParams());
        while (true) {
            if (!this.conn.isOpen()) {
                this.conn.open();
            }
            if (this.params.isAuthenticationPreemptive() || this.state.isAuthenticationPreemptive()) {
                LOG.debug((Object)"Preemptively sending default basic credentials");
                this.connectMethod.getProxyAuthState().setPreemptive();
                this.connectMethod.getProxyAuthState().setAuthAttempted(true);
            }
            try {
                this.authenticateProxy(this.connectMethod);
            }
            catch (AuthenticationException authenticationException) {
                LOG.error((Object)authenticationException.getMessage(), (Throwable)authenticationException);
            }
            this.applyConnectionParams(this.connectMethod);
            this.connectMethod.execute(this.state, this.conn);
            n = this.connectMethod.getStatusCode();
            boolean bl = false;
            AuthState authState = this.connectMethod.getProxyAuthState();
            authState.setAuthRequested(n == 407);
            if (authState.isAuthRequested() && this.processAuthenticationResponse(this.connectMethod)) {
                bl = true;
            }
            if (!bl) break;
            if (this.connectMethod.getResponseBodyAsStream() == null) continue;
            this.connectMethod.getResponseBodyAsStream().close();
        }
        if (n >= 200 && n < 300) {
            this.conn.tunnelCreated();
            this.connectMethod = null;
            return true;
        }
        return false;
    }

    private void fakeResponse(HttpMethod httpMethod) throws IOException, HttpException {
        LOG.debug((Object)"CONNECT failed, fake the response for the original method");
        if (httpMethod instanceof HttpMethodBase) {
            ((HttpMethodBase)httpMethod).fakeResponse(this.connectMethod.getStatusLine(), this.connectMethod.getResponseHeaderGroup(), this.connectMethod.getResponseBodyAsStream());
            httpMethod.getProxyAuthState().setAuthScheme(this.connectMethod.getProxyAuthState().getAuthScheme());
            this.connectMethod = null;
        } else {
            this.releaseConnection = true;
            LOG.warn((Object)"Unable to fake response on method as it is not derived from HttpMethodBase.");
        }
    }

    private boolean processRedirectResponse(HttpMethod httpMethod) throws RedirectException {
        Header header = httpMethod.getResponseHeader("location");
        if (header == null) {
            LOG.error((Object)("Received redirect response " + httpMethod.getStatusCode() + " but no location header"));
            return false;
        }
        String string = header.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirect requested to location '" + string + "'"));
        }
        URI uRI = null;
        URI uRI2 = null;
        try {
            uRI2 = new URI(this.conn.getProtocol().getScheme(), null, this.conn.getHost(), this.conn.getPort(), httpMethod.getPath());
            uRI = new URI(string, true);
            if (uRI.isRelativeURI()) {
                if (this.params.isParameterTrue("http.protocol.reject-relative-redirect")) {
                    LOG.warn((Object)("Relative redirect location '" + string + "' not allowed"));
                    return false;
                }
                LOG.debug((Object)"Redirect URI is not absolute - parsing as relative");
                uRI = new URI(uRI2, uRI);
            } else {
                httpMethod.getParams().setDefaults(this.params);
            }
            httpMethod.setURI(uRI);
            this.hostConfiguration.setHost(uRI);
        }
        catch (URIException uRIException) {
            LOG.warn((Object)("Redirected location '" + string + "' is malformed"));
            return false;
        }
        if (this.params.isParameterFalse("http.protocol.allow-circular-redirects")) {
            if (this.redirectLocations == null) {
                this.redirectLocations = new HashSet();
            }
            this.redirectLocations.add(uRI2);
            try {
                if (uRI.hasQuery()) {
                    uRI.setQuery(null);
                }
            }
            catch (URIException uRIException) {
                return false;
            }
            if (this.redirectLocations.contains(uRI)) {
                throw new CircularRedirectException("Circular redirect to '" + uRI + "'");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirecting from '" + uRI2.getEscapedURI() + "' to '" + uRI.getEscapedURI()));
        }
        httpMethod.getHostAuthState().invalidate();
        return true;
    }

    private boolean processAuthenticationResponse(HttpMethod httpMethod) {
        LOG.trace((Object)"enter HttpMethodBase.processAuthenticationResponse(HttpState, HttpConnection)");
        try {
            switch (httpMethod.getStatusCode()) {
                case 401: {
                    return this.processWWWAuthChallenge(httpMethod);
                }
                case 407: {
                    return this.processProxyAuthChallenge(httpMethod);
                }
            }
            return false;
        }
        catch (Exception exception) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)exception.getMessage(), (Throwable)exception);
            }
            return false;
        }
    }

    private boolean processWWWAuthChallenge(HttpMethod httpMethod) throws MalformedChallengeException, AuthenticationException {
        AuthScheme authScheme;
        AuthState authState;
        block12: {
            authState = httpMethod.getHostAuthState();
            Map map = AuthChallengeParser.parseChallenges(httpMethod.getResponseHeaders(WWW_AUTH_CHALLENGE));
            if (map.isEmpty()) {
                LOG.debug((Object)"Authentication challenge(s) not found");
                return false;
            }
            authScheme = null;
            try {
                authScheme = this.authProcessor.processChallenge(authState, map);
            }
            catch (AuthChallengeException authChallengeException) {
                if (!LOG.isWarnEnabled()) break block12;
                LOG.warn((Object)authChallengeException.getMessage());
            }
        }
        if (authScheme == null) {
            return false;
        }
        String string = httpMethod.getParams().getVirtualHost();
        if (string == null) {
            string = this.conn.getHost();
        }
        int n = this.conn.getPort();
        AuthScope authScope = new AuthScope(string, n, authScheme.getRealm(), authScheme.getSchemeName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Authentication scope: " + authScope));
        }
        if (authState.isAuthAttempted() && authScheme.isComplete()) {
            Credentials credentials = this.promptForCredentials(authScheme, httpMethod.getParams(), authScope);
            if (credentials == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Failure authenticating with " + authScope));
                }
                return false;
            }
            return true;
        }
        authState.setAuthAttempted(true);
        Credentials credentials = this.state.getCredentials(authScope);
        if (credentials == null) {
            credentials = this.promptForCredentials(authScheme, httpMethod.getParams(), authScope);
        }
        if (credentials == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No credentials available for " + authScope));
            }
            return false;
        }
        return true;
    }

    private boolean processProxyAuthChallenge(HttpMethod httpMethod) throws MalformedChallengeException, AuthenticationException {
        AuthScheme authScheme;
        AuthState authState;
        block11: {
            authState = httpMethod.getProxyAuthState();
            Map map = AuthChallengeParser.parseChallenges(httpMethod.getResponseHeaders(PROXY_AUTH_CHALLENGE));
            if (map.isEmpty()) {
                LOG.debug((Object)"Proxy authentication challenge(s) not found");
                return false;
            }
            authScheme = null;
            try {
                authScheme = this.authProcessor.processChallenge(authState, map);
            }
            catch (AuthChallengeException authChallengeException) {
                if (!LOG.isWarnEnabled()) break block11;
                LOG.warn((Object)authChallengeException.getMessage());
            }
        }
        if (authScheme == null) {
            return false;
        }
        AuthScope authScope = new AuthScope(this.conn.getProxyHost(), this.conn.getProxyPort(), authScheme.getRealm(), authScheme.getSchemeName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Proxy authentication scope: " + authScope));
        }
        if (authState.isAuthAttempted() && authScheme.isComplete()) {
            Credentials credentials = this.promptForProxyCredentials(authScheme, httpMethod.getParams(), authScope);
            if (credentials == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Failure authenticating with " + authScope));
                }
                return false;
            }
            return true;
        }
        authState.setAuthAttempted(true);
        Credentials credentials = this.state.getProxyCredentials(authScope);
        if (credentials == null) {
            credentials = this.promptForProxyCredentials(authScheme, httpMethod.getParams(), authScope);
        }
        if (credentials == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No credentials available for " + authScope));
            }
            return false;
        }
        return true;
    }

    private boolean isRedirectNeeded(HttpMethod httpMethod) {
        switch (httpMethod.getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                LOG.debug((Object)"Redirect required");
                if (httpMethod.getFollowRedirects()) {
                    return true;
                }
                LOG.info((Object)"Redirect requested but followRedirects is disabled");
                return false;
            }
        }
        return false;
    }

    private boolean isAuthenticationNeeded(HttpMethod httpMethod) {
        httpMethod.getHostAuthState().setAuthRequested(httpMethod.getStatusCode() == 401);
        httpMethod.getProxyAuthState().setAuthRequested(httpMethod.getStatusCode() == 407);
        if (httpMethod.getHostAuthState().isAuthRequested() || httpMethod.getProxyAuthState().isAuthRequested()) {
            LOG.debug((Object)"Authorization required");
            if (httpMethod.getDoAuthentication()) {
                return true;
            }
            LOG.info((Object)"Authentication requested but doAuthentication is disabled");
            return false;
        }
        return false;
    }

    private Credentials promptForCredentials(AuthScheme authScheme, HttpParams httpParams, AuthScope authScope) {
        LOG.debug((Object)"Credentials required");
        Credentials credentials = null;
        CredentialsProvider credentialsProvider = (CredentialsProvider)httpParams.getParameter("http.authentication.credential-provider");
        if (credentialsProvider != null) {
            try {
                credentials = credentialsProvider.getCredentials(authScheme, authScope.getHost(), authScope.getPort(), false);
            }
            catch (CredentialsNotAvailableException credentialsNotAvailableException) {
                LOG.warn((Object)credentialsNotAvailableException.getMessage());
            }
            if (credentials != null) {
                this.state.setCredentials(authScope, credentials);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(authScope + " new credentials given"));
                }
            }
        } else {
            LOG.debug((Object)"Credentials provider not available");
        }
        return credentials;
    }

    private Credentials promptForProxyCredentials(AuthScheme authScheme, HttpParams httpParams, AuthScope authScope) {
        LOG.debug((Object)"Proxy credentials required");
        Credentials credentials = null;
        CredentialsProvider credentialsProvider = (CredentialsProvider)httpParams.getParameter("http.authentication.credential-provider");
        if (credentialsProvider != null) {
            try {
                credentials = credentialsProvider.getCredentials(authScheme, authScope.getHost(), authScope.getPort(), true);
            }
            catch (CredentialsNotAvailableException credentialsNotAvailableException) {
                LOG.warn((Object)credentialsNotAvailableException.getMessage());
            }
            if (credentials != null) {
                this.state.setProxyCredentials(authScope, credentials);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(authScope + " new credentials given"));
                }
            }
        } else {
            LOG.debug((Object)"Proxy credentials provider not available");
        }
        return credentials;
    }

    public HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public HttpState getState() {
        return this.state;
    }

    public HttpConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public HttpParams getParams() {
        return this.params;
    }
}

