/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public interface DSLMappingEntry {
    public static final Section KEYWORD = new KeywordSection();
    public static final Section CONDITION = new ConditionSection();
    public static final Section CONSEQUENCE = new ConsequenceSection();
    public static final Section ANY = new AnySection();
    public static final MetaData EMPTY_METADATA = new DefaultDSLEntryMetaData("");

    public Section getSection();

    public MetaData getMetaData();

    public String getMappingKey();

    public String getMappingValue();

    public Pattern getKeyPattern();

    public String getValuePattern();

    public Map getVariables();

    public void setMappingKey(String var1);

    public void setSection(Section var1);

    public void setMappingValue(String var1);

    public void setMetaData(MetaData var1);

    public List getErrors();

    public static class DefaultDSLEntryMetaData
    implements MetaData {
        private String metadata;

        public DefaultDSLEntryMetaData(String metadata) {
            this.metadata = metadata;
        }

        public String getMetaData() {
            return this.metadata;
        }

        public String toString() {
            return this.metadata == null ? "" : this.metadata;
        }

        public int compareTo(Object arg0) {
            return this.toString().compareTo(arg0.toString());
        }
    }

    public static class AnySection
    implements Section {
        private static final String symbol = "[*]";

        private AnySection() {
        }

        public String getSymbol() {
            return symbol;
        }

        public String toString() {
            return symbol;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (symbol == null ? 0 : symbol.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeywordSection other = (KeywordSection)obj;
            return !(symbol == null ? other.getSymbol() != null : !symbol.equals(other.getSymbol()));
        }

        public int compareTo(Object arg0) {
            return this.toString().compareTo(arg0.toString());
        }
    }

    public static class ConsequenceSection
    implements Section {
        private static final String symbol = "[consequence]";

        private ConsequenceSection() {
        }

        public String getSymbol() {
            return symbol;
        }

        public String toString() {
            return symbol;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (symbol == null ? 0 : symbol.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeywordSection other = (KeywordSection)obj;
            return !(symbol == null ? other.getSymbol() != null : !symbol.equals(other.getSymbol()));
        }

        public int compareTo(Object arg0) {
            return this.toString().compareTo(arg0.toString());
        }
    }

    public static class ConditionSection
    implements Section {
        private static final String symbol = "[condition]";

        private ConditionSection() {
        }

        public String getSymbol() {
            return symbol;
        }

        public String toString() {
            return symbol;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (symbol == null ? 0 : symbol.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeywordSection other = (KeywordSection)obj;
            return !(symbol == null ? other.getSymbol() != null : !symbol.equals(other.getSymbol()));
        }

        public int compareTo(Object arg0) {
            return this.toString().compareTo(arg0.toString());
        }
    }

    public static class KeywordSection
    implements Section {
        private static final String symbol = "[keyword]";

        private KeywordSection() {
        }

        public String getSymbol() {
            return symbol;
        }

        public String toString() {
            return symbol;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (symbol == null ? 0 : symbol.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeywordSection other = (KeywordSection)obj;
            return !(symbol == null ? other.getSymbol() != null : !symbol.equals(other.getSymbol()));
        }

        public int compareTo(Object arg0) {
            return this.toString().compareTo(arg0.toString());
        }
    }

    public static interface MetaData
    extends Comparable {
        public String toString();

        public String getMetaData();
    }

    public static interface Section
    extends Comparable {
        public String getSymbol();
    }
}

