/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RandomIter;

public class RandomIterFallback
implements RandomIter {
    protected RenderedImage im;
    protected Rectangle boundsRect;
    protected SampleModel sampleModel;
    protected int xID;
    protected int yID;
    protected int sampleModelTranslateX;
    protected int sampleModelTranslateY;
    protected DataBuffer dataBuffer = null;
    protected int boundsX;
    protected int boundsY;
    protected int[] xTiles;
    protected int[] yTiles;

    public RandomIterFallback(RenderedImage renderedImage, Rectangle rectangle) {
        this.im = renderedImage;
        Rectangle rectangle2 = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        this.boundsRect = rectangle2.intersection(rectangle);
        this.sampleModel = renderedImage.getSampleModel();
        int n = this.boundsRect.x;
        int n2 = this.boundsRect.y;
        int n3 = this.boundsRect.width;
        int n4 = this.boundsRect.height;
        this.boundsX = this.boundsRect.x;
        this.boundsY = this.boundsRect.y;
        this.xTiles = new int[n3];
        this.yTiles = new int[n4];
        int n5 = renderedImage.getTileWidth();
        int n6 = renderedImage.getTileGridXOffset();
        int n7 = PlanarImage.XToTileX(n, n6, n5);
        int n8 = n - PlanarImage.tileXToX(n7, n6, n5);
        int n9 = n7;
        int n10 = 0;
        while (n10 < n3) {
            this.xTiles[n10] = n9++;
            if (++n8 == n5) {
                n8 = 0;
            }
            ++n10;
        }
        int n11 = renderedImage.getTileHeight();
        int n12 = renderedImage.getTileGridYOffset();
        int n13 = PlanarImage.YToTileY(n2, n12, n11);
        int n14 = n2 - PlanarImage.tileYToY(n13, n12, n11);
        int n15 = n13;
        int n16 = 0;
        while (n16 < n4) {
            this.yTiles[n16] = n15++;
            if (++n14 == n11) {
                n14 = 0;
            }
            ++n16;
        }
    }

    private void makeCurrent(int n, int n2) {
        int n3 = this.xTiles[n];
        int n4 = this.yTiles[n2];
        if (n3 != this.xID || n4 != this.yID || this.dataBuffer == null) {
            this.xID = n3;
            this.yID = n4;
            Raster raster = this.im.getTile(this.xID, this.yID);
            this.dataBuffer = raster.getDataBuffer();
            this.sampleModelTranslateX = raster.getSampleModelTranslateX();
            this.sampleModelTranslateY = raster.getSampleModelTranslateY();
        }
    }

    public int getSample(int n, int n2, int n3) {
        this.makeCurrent(n - this.boundsX, n2 - this.boundsY);
        return this.sampleModel.getSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public float getSampleFloat(int n, int n2, int n3) {
        this.makeCurrent(n - this.boundsX, n2 - this.boundsY);
        return this.sampleModel.getSampleFloat(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public double getSampleDouble(int n, int n2, int n3) {
        this.makeCurrent(n - this.boundsX, n2 - this.boundsY);
        return this.sampleModel.getSampleDouble(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public int[] getPixel(int n, int n2, int[] nArray) {
        this.makeCurrent(n - this.boundsX, n2 - this.boundsY);
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, nArray, this.dataBuffer);
    }

    public float[] getPixel(int n, int n2, float[] fArray) {
        this.makeCurrent(n - this.boundsX, n2 - this.boundsY);
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public double[] getPixel(int n, int n2, double[] dArray) {
        this.makeCurrent(n - this.boundsX, n2 - this.boundsY);
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public void done() {
        this.xTiles = null;
        this.yTiles = null;
        this.dataBuffer = null;
    }
}

