/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.impl;

import cirrus.hibernate.Datastore;
import cirrus.hibernate.Environment;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.Interceptor;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.SessionFactory;
import cirrus.hibernate.engine.Mapping;
import cirrus.hibernate.helpers.ArrayHelper;
import cirrus.hibernate.helpers.XMLHelper;
import cirrus.hibernate.id.PersistentIdentifierGenerator;
import cirrus.hibernate.impl.SessionFactoryImpl;
import cirrus.hibernate.map.Collection;
import cirrus.hibernate.map.ForeignKey;
import cirrus.hibernate.map.Index;
import cirrus.hibernate.map.PersistentClass;
import cirrus.hibernate.map.Root;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.sql.Dialect;
import cirrus.hibernate.tools.updater.JdbcDatabaseInfo;
import cirrus.hibernate.tools.updater.JdbcTableInfo;
import cirrus.hibernate.type.Type;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class DatastoreImpl
implements Datastore,
Mapping {
    private HashMap classes = new HashMap();
    private HashMap collections = new HashMap();
    private HashMap tables = new HashMap();
    private HashMap generators = new HashMap();
    private HashMap namedQueries = new HashMap();
    private static Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$impl$DatastoreImpl == null ? (class$cirrus$hibernate$impl$DatastoreImpl = DatastoreImpl.class$("cirrus.hibernate.impl.DatastoreImpl")) : class$cirrus$hibernate$impl$DatastoreImpl));
    private static final Interceptor EMPTY_INTERCEPTOR = new EmptyInterceptor();
    static /* synthetic */ Class class$cirrus$hibernate$impl$DatastoreImpl;

    public Type getIdentifierType(Class persistentClass) throws MappingException {
        return ((PersistentClass)this.classes.get(persistentClass)).getIdentifier().getType();
    }

    public Type getCollectionKeyType(String role) throws MappingException {
        return ((Collection)this.collections.get(role)).getKey().getType();
    }

    public Iterator getClassMaps() {
        return this.classes.values().iterator();
    }

    public Iterator getCollectionMaps() {
        return this.collections.values().iterator();
    }

    public Iterator getTableMaps() {
        return this.tables.values().iterator();
    }

    public PersistentClass getPersistentClass(Class persistentClass) {
        return (PersistentClass)this.classes.get(persistentClass);
    }

    public Datastore storeFile(String xmlFile) throws MappingException {
        log.info((Object)("Mapping file: " + xmlFile));
        try {
            this.store(XMLHelper.parseFile(xmlFile));
        }
        catch (Exception e) {
            log.error((Object)("Could not configure datastore from file: " + xmlFile), (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Datastore storeXML(String xml) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping XML:\n" + xml));
        }
        try {
            this.store(XMLHelper.parseString(xml));
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from XML", (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    public Datastore storeDocument(Document doc) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping XML:\n" + doc));
        }
        try {
            this.store(doc);
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from XML document", (Throwable)e);
            throw new MappingException(e);
        }
        return this;
    }

    private void store(Document doc) throws Exception {
        try {
            new Root(doc, this.classes, this.collections, this.tables, this.generators, this.namedQueries);
        }
        catch (MappingException me) {
            log.error((Object)"Could not compile the mapping document", (Throwable)((Object)me));
            throw me;
        }
    }

    public Datastore storeInputStream(InputStream xmlInputStream) throws MappingException {
        try {
            this.store(XMLHelper.parseInputSource(new InputSource(xmlInputStream)));
            return this;
        }
        catch (MappingException me) {
            throw me;
        }
        catch (Exception e) {
            log.error((Object)"Could not configure datastore from input stream", (Throwable)e);
            throw new MappingException(e);
        }
    }

    public Datastore storeResource(String path, ClassLoader classLoader) throws MappingException {
        log.info((Object)("Mapping resource: " + path));
        InputStream rsrc = classLoader.getResourceAsStream(path);
        if (rsrc == null) {
            throw new MappingException("Resource: " + path + " not found");
        }
        return this.storeInputStream(rsrc);
    }

    public Datastore storeClass(Class persistentClass) throws MappingException {
        String fileName = persistentClass.getName().replace('.', '/') + ".hbm.xml";
        log.info((Object)("Mapping resource: " + fileName));
        InputStream rsrc = persistentClass.getClassLoader().getResourceAsStream(fileName);
        if (rsrc == null) {
            throw new MappingException("Resource: " + fileName + " not found");
        }
        return this.storeInputStream(rsrc);
    }

    public Datastore storeJar(String resource) throws MappingException {
        JarFile jarFile;
        log.info((Object)("Searching for mapping documents in jar: " + resource));
        try {
            jarFile = new JarFile(Thread.currentThread().getContextClassLoader().getResource(resource).getFile());
        }
        catch (IOException ioe) {
            log.error((Object)"Could not configure datastore from jar", (Throwable)ioe);
            throw new MappingException(ioe);
        }
        if (jarFile == null) {
            throw new MappingException("Resource: " + resource + " not found");
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry z = enumeration.nextElement();
            if (!z.getName().endsWith(".hbm.xml")) continue;
            log.info((Object)("Found mapping documents in jar: " + z.getName()));
            try {
                this.storeInputStream(jarFile.getInputStream(z));
            }
            catch (MappingException me) {
                throw me;
            }
            catch (Exception e) {
                log.error((Object)"Could not configure datastore from jar", (Throwable)e);
                throw new MappingException(e);
            }
        }
        return this;
    }

    public String[] generateDropSchemaScript(Dialect dialect) throws HibernateException {
        Iterator iter;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        if (dialect.dropConstraints()) {
            iter = this.getTableMaps();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                Iterator subIter = table.foreignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    script.add(fk.sqlDropString(dialect));
                }
            }
        }
        iter = this.getTableMaps();
        while (iter.hasNext()) {
            script.add(((Table)iter.next()).sqlDropString(dialect));
        }
        iter = this.generators.values().iterator();
        while (iter.hasNext()) {
            String dropString = ((PersistentIdentifierGenerator)iter.next()).sqlDropString(dialect);
            if (dropString == null) continue;
            script.add(dropString);
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaCreationScript(Dialect dialect) throws HibernateException {
        Table table;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator iter = this.getTableMaps();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            script.add(table.sqlCreateString(dialect, this));
        }
        iter = this.getTableMaps();
        while (iter.hasNext()) {
            Iterator subIter;
            table = (Table)iter.next();
            if (dialect.hasAlterTable()) {
                subIter = table.foreignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    script.add(fk.sqlCreateString(dialect, this));
                }
            }
            subIter = table.indexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                script.add(index.sqlCreateString(dialect, this));
            }
        }
        iter = this.generators.values().iterator();
        while (iter.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)iter.next()).sqlCreateStrings(dialect);
            int i = 0;
            while (i < lines.length) {
                script.add(lines[i]);
                ++i;
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaUpdateScript(Dialect dialect, JdbcDatabaseInfo databaseInfo) throws HibernateException {
        JdbcTableInfo tableInfo;
        Table table;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator iter = this.getTableMaps();
        while (iter.hasNext()) {
            table = (Table)iter.next();
            tableInfo = databaseInfo.getTableInfo(table.getName());
            if (tableInfo == null) {
                script.add(table.sqlCreateString(dialect, this));
                continue;
            }
            String sql = table.sqlAlterString(dialect, this, tableInfo);
            if (sql == null) continue;
            script.add(sql);
        }
        iter = this.getTableMaps();
        while (iter.hasNext()) {
            Iterator subIter;
            table = (Table)iter.next();
            tableInfo = databaseInfo.getTableInfo(table.getName());
            if (dialect.hasAlterTable()) {
                subIter = table.foreignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (tableInfo != null && tableInfo.getForeignKeyInfo(fk.getName()) != null) continue;
                    script.add(fk.sqlCreateString(dialect, this));
                }
            }
            subIter = table.indexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                if (tableInfo != null && tableInfo.getIndexInfo(index.getName()) != null) continue;
                script.add(index.sqlCreateString(dialect, this));
            }
        }
        iter = this.generators.values().iterator();
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            if (databaseInfo.isSequence(generator.generatorKey())) continue;
            String[] lines = generator.sqlCreateStrings(dialect);
            int i = 0;
            while (i < lines.length) {
                script.add(lines[i]);
                ++i;
            }
        }
        return ArrayHelper.toStringArray(script);
    }

    private void secondPassCompile() throws MappingException {
        Iterator iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            ((Collection)iter.next()).secondPassCompile(this.classes);
        }
        iter = this.getTableMaps();
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            Iterator subIter = table.foreignKeyIterator();
            while (subIter.hasNext()) {
                ForeignKey fk = (ForeignKey)subIter.next();
                if (fk.getReferencedTable() != null) continue;
                PersistentClass referencedClass = (PersistentClass)this.classes.get(fk.getReferencedClass());
                if (referencedClass == null) {
                    throw new MappingException("An association refers to an unmapped class: " + fk.getReferencedClass().getName());
                }
                fk.setReferencedTable(referencedClass.getTable());
            }
        }
    }

    public Map getNamedQueries() {
        return this.namedQueries;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        return this.buildSessionFactory(EMPTY_INTERCEPTOR);
    }

    public SessionFactory buildSessionFactory(Properties connectionProps) throws HibernateException {
        return this.buildSessionFactory(connectionProps, EMPTY_INTERCEPTOR);
    }

    public SessionFactory buildSessionFactory(Interceptor interceptor) throws HibernateException {
        this.secondPassCompile();
        return new SessionFactoryImpl(this, Environment.getProperties(), interceptor);
    }

    public SessionFactory buildSessionFactory(Properties connectionProps, Interceptor interceptor) throws HibernateException {
        this.secondPassCompile();
        Environment.verifyProperties(connectionProps);
        return new SessionFactoryImpl(this, connectionProps, interceptor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class EmptyInterceptor
    implements Interceptor,
    Serializable {
        public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        }

        public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
            return false;
        }

        public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            return false;
        }

        public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
            return false;
        }

        public void onPostFlush(Object entity, Serializable id, Object[] currentState, String[] propertyNames, Type[] types) {
        }

        public void postFlush(Iterator entities) {
        }

        public void preFlush(Iterator entities) {
        }
    }
}

