/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.tools.updater;

import cirrus.hibernate.tools.updater.JdbcColumnInfo;
import cirrus.hibernate.tools.updater.JdbcForeignKeyInfo;
import cirrus.hibernate.tools.updater.JdbcIndexInfo;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class JdbcTableInfo {
    private final String _schema;
    private final String _name;
    private final Map _columns = new HashMap();
    private final Map _foreignKeys = new HashMap();
    private final Map _indexes = new HashMap();

    public JdbcTableInfo(ResultSet rs) throws SQLException {
        this._schema = rs.getString("TABLE_SCHEM");
        this._name = rs.getString("TABLE_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initForeignKeys(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = null;
        try {
            rs = meta.getImportedKeys(null, this._schema, this._name);
            while (rs.next()) {
                this.addForeignKey(rs);
            }
            Object var4_3 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initIndexes(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = null;
        try {
            rs = meta.getIndexInfo(null, this._schema, this._name, false, true);
            while (rs.next()) {
                if (rs.getShort("TYPE") == 0) continue;
                this.addIndex(rs);
            }
            Object var4_3 = null;
            if (rs == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (rs == null) throw throwable;
            rs.close();
            throw throwable;
        }
        rs.close();
    }

    public JdbcColumnInfo getColumnInfo(String name) {
        return (JdbcColumnInfo)this._columns.get(name.toLowerCase());
    }

    public void addColumn(ResultSet rs) throws SQLException {
        String name = rs.getString("COLUMN_NAME");
        if (name == null) {
            return;
        }
        if (this.getColumnInfo(name) == null) {
            JdbcColumnInfo info = new JdbcColumnInfo(rs);
            this._columns.put(info.getName().toLowerCase(), info);
        }
    }

    public JdbcForeignKeyInfo getForeignKeyInfo(String name) {
        return (JdbcForeignKeyInfo)this._foreignKeys.get(name.toUpperCase());
    }

    private void addForeignKey(ResultSet rs) throws SQLException {
        String name = rs.getString("FK_NAME");
        if (name == null) {
            return;
        }
        JdbcForeignKeyInfo info = this.getForeignKeyInfo(name);
        if (info == null) {
            info = new JdbcForeignKeyInfo(rs);
            this._foreignKeys.put(info.getName().toUpperCase(), info);
        }
        info.addColumn(this.getColumnInfo("FKCOLUMN_NAME"));
    }

    public JdbcIndexInfo getIndexInfo(String name) {
        return (JdbcIndexInfo)this._indexes.get(name.toUpperCase());
    }

    private void addIndex(ResultSet rs) throws SQLException {
        String name = rs.getString("INDEX_NAME");
        if (name == null) {
            return;
        }
        JdbcIndexInfo info = this.getIndexInfo(name);
        if (info == null) {
            info = new JdbcIndexInfo(rs);
            this._indexes.put(info.getName().toUpperCase(), info);
        }
        info.addColumn(this.getColumnInfo("COLUMN_NAME"));
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }
}

