/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import java.text.MessageFormat;
import org.eclipse.jdt.internal.compiler.codegen.VerificationTypeInfo;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class StackMapFrame
implements Cloneable {
    public static final int USED = 1;
    public static final int SAME_FRAME = 0;
    public static final int CHOP_FRAME = 1;
    public static final int APPEND_FRAME = 2;
    public static final int SAME_FRAME_EXTENDED = 3;
    public static final int FULL_FRAME = 4;
    public static final int SAME_LOCALS_1_STACK_ITEMS = 5;
    public static final int SAME_LOCALS_1_STACK_ITEMS_EXTENDED = 6;
    public int pc;
    public int numberOfStackItems;
    private int numberOfLocals = -1;
    public int localIndex;
    public VerificationTypeInfo[] locals;
    public VerificationTypeInfo[] stackItems;
    public StackMapFrame nextFrame;
    public StackMapFrame prevFrame;
    private int numberOfDifferentLocals = -1;
    public int tagBits;

    public int getFrameType() {
        int offsetDelta = this.getOffsetDelta();
        switch (this.numberOfStackItems) {
            case 0: {
                switch (this.numberOfDifferentLocals()) {
                    case 0: {
                        return offsetDelta <= 63 ? 0 : 3;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        return 2;
                    }
                    case -3: 
                    case -2: 
                    case -1: {
                        return 1;
                    }
                }
                break;
            }
            case 1: {
                switch (this.numberOfDifferentLocals()) {
                    case 0: {
                        return offsetDelta <= 63 ? 5 : 6;
                    }
                }
            }
        }
        return 4;
    }

    public void addLocal(int resolvedPosition, VerificationTypeInfo info) {
        if (this.locals == null) {
            this.locals = new VerificationTypeInfo[resolvedPosition + 1];
            this.locals[resolvedPosition] = info;
        } else {
            int length = this.locals.length;
            if (resolvedPosition >= length) {
                this.locals = new VerificationTypeInfo[resolvedPosition + 1];
                System.arraycopy(this.locals, 0, this.locals, 0, length);
            }
            this.locals[resolvedPosition] = info;
        }
    }

    public void addStackItem(VerificationTypeInfo info) {
        if (this.stackItems == null) {
            this.stackItems = new VerificationTypeInfo[1];
            this.stackItems[0] = info;
            this.numberOfStackItems = 1;
        } else {
            int length = this.stackItems.length;
            if (this.numberOfStackItems == length) {
                this.stackItems = new VerificationTypeInfo[length + 1];
                System.arraycopy(this.stackItems, 0, this.stackItems, 0, length);
            }
            this.stackItems[this.numberOfStackItems++] = info;
        }
    }

    public void addStackItem(TypeBinding binding) {
        this.addStackItem(new VerificationTypeInfo(binding));
    }

    public Object clone() throws CloneNotSupportedException {
        int i;
        int length;
        StackMapFrame result = new StackMapFrame();
        result.pc = this.pc;
        result.numberOfStackItems = this.numberOfStackItems;
        int n = length = this.locals == null ? 0 : this.locals.length;
        if (length != 0) {
            result.locals = new VerificationTypeInfo[length];
            i = 0;
            while (i < length) {
                VerificationTypeInfo verificationTypeInfo = this.locals[i];
                if (verificationTypeInfo != null) {
                    result.locals[i] = (VerificationTypeInfo)verificationTypeInfo.clone();
                }
                ++i;
            }
        }
        if ((length = this.numberOfStackItems) != 0) {
            result.stackItems = new VerificationTypeInfo[length];
            i = 0;
            while (i < length) {
                result.stackItems[i] = (VerificationTypeInfo)this.stackItems[i].clone();
                ++i;
            }
        }
        return result;
    }

    public int numberOfDiffentStackItems() {
        if (this.prevFrame == null) {
            return this.numberOfStackItems;
        }
        return this.numberOfStackItems - this.prevFrame.numberOfStackItems;
    }

    public int numberOfDifferentLocals() {
        if (this.numberOfDifferentLocals != -1) {
            return this.numberOfDifferentLocals;
        }
        if (this.prevFrame == null) {
            this.numberOfDifferentLocals = 0;
            return 0;
        }
        VerificationTypeInfo[] prevLocals = this.prevFrame.locals;
        VerificationTypeInfo[] currentLocals = this.locals;
        int prevLocalsLength = prevLocals == null ? 0 : prevLocals.length;
        int currentLocalsLength = currentLocals == null ? 0 : currentLocals.length;
        int prevNumberOfLocals = this.prevFrame.getNumberOfLocals();
        int currentNumberOfLocals = this.getNumberOfLocals();
        int result = 0;
        if (prevNumberOfLocals == 0) {
            if (currentNumberOfLocals != 0) {
                result = currentNumberOfLocals;
                int counter = 0;
                int i = 0;
                while (i < currentLocalsLength && counter < currentNumberOfLocals) {
                    if (currentLocals[i] != null) {
                        switch (currentLocals[i].id()) {
                            case 7: 
                            case 8: {
                                ++i;
                            }
                        }
                        ++counter;
                    } else {
                        this.numberOfDifferentLocals = result = Integer.MAX_VALUE;
                        return result;
                    }
                    ++i;
                }
            }
        } else if (currentNumberOfLocals == 0) {
            int counter = 0;
            result = -prevNumberOfLocals;
            int i = 0;
            while (i < prevLocalsLength && counter < prevNumberOfLocals) {
                if (prevLocals[i] != null) {
                    switch (prevLocals[i].id()) {
                        case 7: 
                        case 8: {
                            ++i;
                        }
                    }
                    ++counter;
                } else {
                    this.numberOfDifferentLocals = result = Integer.MAX_VALUE;
                    return result;
                }
                ++i;
            }
        } else {
            VerificationTypeInfo currentLocal;
            int indexInPrevLocals = 0;
            int indexInCurrentLocals = 0;
            int currentLocalsCounter = 0;
            int prevLocalsCounter = 0;
            while (indexInCurrentLocals < currentLocalsLength && currentLocalsCounter < currentNumberOfLocals) {
                currentLocal = currentLocals[indexInCurrentLocals];
                if (currentLocal != null) {
                    ++currentLocalsCounter;
                    switch (currentLocal.id()) {
                        case 7: 
                        case 8: {
                            ++indexInCurrentLocals;
                        }
                    }
                }
                if (indexInPrevLocals >= prevLocalsLength || prevLocalsCounter >= prevNumberOfLocals) {
                    if (currentLocal != null) {
                        ++result;
                    } else {
                        this.numberOfDifferentLocals = result = Integer.MAX_VALUE;
                        return result;
                    }
                    ++indexInCurrentLocals;
                    break;
                }
                VerificationTypeInfo prevLocal = prevLocals[indexInPrevLocals];
                if (prevLocal != null) {
                    ++prevLocalsCounter;
                    switch (prevLocal.id()) {
                        case 7: 
                        case 8: {
                            ++indexInPrevLocals;
                        }
                    }
                }
                if (this.equals(prevLocal, currentLocal) && indexInPrevLocals == indexInCurrentLocals) {
                    if (result != 0) {
                        this.numberOfDifferentLocals = result = Integer.MAX_VALUE;
                        return result;
                    }
                } else {
                    this.numberOfDifferentLocals = result = Integer.MAX_VALUE;
                    return result;
                }
                ++indexInPrevLocals;
                ++indexInCurrentLocals;
            }
            if (currentLocalsCounter < currentNumberOfLocals) {
                while (indexInCurrentLocals < currentLocalsLength && currentLocalsCounter < currentNumberOfLocals) {
                    currentLocal = currentLocals[indexInCurrentLocals];
                    if (currentLocal == null) {
                        this.numberOfDifferentLocals = result = Integer.MAX_VALUE;
                        return result;
                    }
                    ++result;
                    ++currentLocalsCounter;
                    switch (currentLocal.id()) {
                        case 7: 
                        case 8: {
                            ++indexInCurrentLocals;
                        }
                    }
                    ++indexInCurrentLocals;
                }
            } else if (prevLocalsCounter < prevNumberOfLocals) {
                result = -result;
                while (indexInPrevLocals < prevLocalsLength && prevLocalsCounter < prevNumberOfLocals) {
                    VerificationTypeInfo prevLocal = prevLocals[indexInPrevLocals];
                    if (prevLocal == null) {
                        this.numberOfDifferentLocals = result = Integer.MAX_VALUE;
                        return result;
                    }
                    --result;
                    ++prevLocalsCounter;
                    switch (prevLocal.id()) {
                        case 7: 
                        case 8: {
                            ++indexInPrevLocals;
                        }
                    }
                    ++indexInPrevLocals;
                }
            }
        }
        this.numberOfDifferentLocals = result;
        return result;
    }

    public int getNumberOfLocals() {
        if (this.numberOfLocals != -1) {
            return this.numberOfLocals;
        }
        int result = 0;
        int length = this.locals == null ? 0 : this.locals.length;
        int i = 0;
        while (i < length) {
            if (this.locals[i] != null) {
                switch (this.locals[i].id()) {
                    case 7: 
                    case 8: {
                        ++i;
                    }
                }
                ++result;
            }
            ++i;
        }
        this.numberOfLocals = result;
        return result;
    }

    public int getOffsetDelta() {
        if (this.prevFrame == null) {
            return this.pc;
        }
        return this.prevFrame.pc == -1 ? this.pc : this.pc - this.prevFrame.pc - 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.printFrame(buffer, this);
        return String.valueOf(buffer);
    }

    private void printFrame(StringBuffer buffer, StackMapFrame frame) {
        String pattern = "[pc : {0} locals: {1} stack items: {2}\n{3}\n{4}\n]";
        int localsLength = frame.locals == null ? 0 : frame.locals.length;
        buffer.append(MessageFormat.format(pattern, Integer.toString(frame.pc), Integer.toString(frame.getNumberOfLocals()), Integer.toString(frame.numberOfStackItems), this.print(frame.locals, localsLength), this.print(frame.stackItems, frame.numberOfStackItems)));
        StackMapFrame next = frame.nextFrame;
        if (next != null) {
            buffer.append('\n');
            this.printFrame(buffer, next);
        }
    }

    private String print(VerificationTypeInfo[] infos, int length) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        if (infos != null) {
            int i = 0;
            while (i < length) {
                if (i != 0) {
                    buffer.append(',');
                }
                if (infos[i] == null) {
                    buffer.append("top");
                } else {
                    switch (infos[i].tag) {
                        case 5: {
                            buffer.append("null");
                            break;
                        }
                        case 6: {
                            buffer.append("uninitialized_this");
                            break;
                        }
                        case 0: {
                            buffer.append("top");
                            break;
                        }
                        case 8: {
                            buffer.append("uninitialized(").append(infos[i].readableName()).append(")");
                            break;
                        }
                        default: {
                            buffer.append(infos[i].readableName());
                        }
                    }
                }
                ++i;
            }
        }
        buffer.append(']');
        return String.valueOf(buffer);
    }

    public void setTopOfStack(TypeBinding typeBinding) {
        this.stackItems[this.numberOfStackItems - 1].setBinding(typeBinding);
    }

    public void initializeReceiver() {
        if (this.numberOfStackItems > 0) {
            this.stackItems[this.numberOfStackItems - 1].tag = 7;
        }
    }

    public void removeLocals(int resolvedPosition) {
        if (this.locals == null) {
            return;
        }
        if (resolvedPosition < this.locals.length) {
            this.locals[resolvedPosition] = null;
        }
    }

    public void putLocal(int resolvedPosition, VerificationTypeInfo info) {
        if (this.locals == null) {
            this.locals = new VerificationTypeInfo[resolvedPosition + 1];
            this.locals[resolvedPosition] = info;
        } else {
            int length = this.locals.length;
            if (resolvedPosition >= length) {
                this.locals = new VerificationTypeInfo[resolvedPosition + 1];
                System.arraycopy(this.locals, 0, this.locals, 0, length);
            }
            this.locals[resolvedPosition] = info;
        }
    }

    public void replaceWithElementType() {
        VerificationTypeInfo info = this.stackItems[this.numberOfStackItems - 1];
        try {
            VerificationTypeInfo info2 = (VerificationTypeInfo)info.clone();
            info2.replaceWithElementType();
            this.stackItems[this.numberOfStackItems - 1] = info2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
    }

    public int getIndexOfDifferentLocals(int differentLocalsCount) {
        int i = this.locals.length - 1;
        while (i >= 0) {
            VerificationTypeInfo currentLocal = this.locals[i];
            if (currentLocal != null && --differentLocalsCount == 0) {
                return i;
            }
            --i;
        }
        return 0;
    }

    private boolean equals(VerificationTypeInfo info, VerificationTypeInfo info2) {
        if (info == null) {
            return info2 == null;
        }
        if (info2 == null) {
            return false;
        }
        return info.equals(info2);
    }
}

