/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment;

import java.lang.reflect.InvocationTargetException;
import javax.resource.spi.ResourceAdapter;
import org.jboss.deployment.DeploymentException;
import org.jboss.resource.deployment.ConfigPropertyHandler;
import org.jboss.resource.deployment.DummyResourceAdapter;
import org.jboss.resource.metadata.ConfigPropertyMetaData;
import org.jboss.resource.metadata.ConnectorMetaData;

public class ResourceAdapterFactory {
    public static final String DUMMY_RA_CLASS = DummyResourceAdapter.class.getName();

    public static ResourceAdapter createResourceAdapter(ConnectorMetaData cmd) throws Exception {
        Class<?> raClass;
        String className = cmd.getRAClass();
        if (className == null) {
            if (cmd.getVersion().equals("1.0")) {
                className = DUMMY_RA_CLASS;
            } else {
                throw new IllegalArgumentException("No resource adapter class name specified");
            }
        }
        if (!ResourceAdapter.class.isAssignableFrom(raClass = Thread.currentThread().getContextClassLoader().loadClass(className))) {
            throw new DeploymentException(raClass.getName() + " is not a resource adapter class");
        }
        ResourceAdapter result = (ResourceAdapter)raClass.newInstance();
        ConfigPropertyHandler configPropertyHandler = new ConfigPropertyHandler(result, raClass, "ResourceAdapter: ");
        for (ConfigPropertyMetaData cpmd : cmd.getProperties()) {
            try {
                configPropertyHandler.handle(cpmd);
            }
            catch (InvocationTargetException e) {
                DeploymentException.rethrowAsDeploymentException((String)("Error for resource adapter class " + raClass.getName() + " setting property " + cmd), (Throwable)e.getTargetException());
            }
            catch (Throwable t) {
                DeploymentException.rethrowAsDeploymentException((String)("Error for resource adapter class " + raClass.getName() + " accessing property setter " + cmd), (Throwable)t);
            }
        }
        return result;
    }
}

