/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HtmlErrorListener;
import com.meterware.httpunit.HttpUnitOptions;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.StringTokenizer;

class JTidyPrintWriter
extends PrintWriter {
    private static final NumberFormat INTEGER_FORMAT = DecimalFormat.getNumberInstance();
    private int _line = -1;
    private int _column = -1;
    private String _msg = "";
    private boolean _error = false;
    private boolean _logged = false;
    private URL _url;

    JTidyPrintWriter(URL pageURL) {
        super(System.out);
        this._url = pageURL;
    }

    public void print(boolean b) {
        this.print(String.valueOf(b));
    }

    public void print(char c) {
        this.print(String.valueOf(c));
    }

    public void print(char[] s) {
        this.print(String.valueOf(s));
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void print(float f) {
        this.print(String.valueOf(f));
    }

    public void print(int i) {
        this.print(String.valueOf(i));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(Object obj) {
        this.print(obj.toString());
    }

    public void print(String s) {
        if (s.startsWith("line")) {
            if (!this._logged && this._line > 0 && this._msg != null && this._msg.length() > 0) {
                this.log();
            }
            this._logged = false;
            StringTokenizer tok = new StringTokenizer(s);
            tok.nextToken();
            this._line = this.parseInteger(tok.nextToken());
            tok.nextToken();
            this._column = this.parseInteger(tok.nextToken());
        } else if (s.startsWith("Warning")) {
            this._error = false;
            this._msg = s;
        } else if (s.startsWith("Error")) {
            this._error = true;
            this._msg = s;
        } else {
            this._msg = this._msg + s;
        }
    }

    private int parseInteger(String integer) {
        try {
            return INTEGER_FORMAT.parse(integer).intValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException("Unable to parse integer [int: " + integer + ", error: " + e.getMessage());
        }
    }

    public void println() {
        if (!this._logged) {
            this.log();
        }
    }

    public void println(boolean x) {
        this.print(String.valueOf(x));
        this.println();
    }

    public void println(char c) {
        this.print(String.valueOf(c));
        this.println();
    }

    public void println(char[] c) {
        this.print(String.valueOf(c));
        this.println();
    }

    public void println(double d) {
        this.print(String.valueOf(d));
        this.println();
    }

    public void println(float f) {
        this.print(String.valueOf(f));
        this.println();
    }

    public void println(int i) {
        this.print(String.valueOf(i));
        this.println();
    }

    public void println(long l) {
        this.print(String.valueOf(l));
        this.println();
    }

    public void println(Object o) {
        this.print(o.toString());
        this.println();
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    private void log() {
        if (this._error) {
            this.reportError(this._msg, this._line, this._column);
        } else {
            this.reportWarning(this._msg, this._line, this._column);
        }
        this._logged = true;
        this._line = -1;
        this._column = -1;
        this._msg = "";
    }

    private void reportError(String msg, int line, int column) {
        Enumeration enumeration = HttpUnitOptions.getHtmlErrorListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((HtmlErrorListener)enumeration.nextElement()).error(this._url, msg, line, column);
        }
    }

    private void reportWarning(String msg, int line, int column) {
        Enumeration enumeration = HttpUnitOptions.getHtmlErrorListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((HtmlErrorListener)enumeration.nextElement()).warning(this._url, msg, line, column);
        }
    }
}

