/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.IllegalButtonPositionException;
import com.meterware.httpunit.IllegalNonFileParameterException;
import com.meterware.httpunit.IllegalRequestParameterException;
import com.meterware.httpunit.MultipartFormRequiredException;
import com.meterware.httpunit.ParameterHolder;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.UncheckedParameterHolder;
import com.meterware.httpunit.UploadFileSpec;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebRequestSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class WebRequest {
    private SubmitButton _button;
    static final String TOP_FRAME = "_top";
    private static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    private static final String SunJSSE_PROVIDER_CLASS = "com.sun.net.ssl.internal.ssl.Provider";
    private static final String SSL_PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    private final ParameterHolder _parameterHolder;
    private URL _urlBase;
    private String _urlString;
    private String _target = "_top";
    private Hashtable _headers;
    private boolean _httpsProtocolSupportEnabled;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$System;

    public void setHeaderField(String headerName, String headerValue) {
        this.getHeaderDictionary().put(headerName, headerValue);
    }

    public Dictionary getHeaders() {
        return (Dictionary)this.getHeaderDictionary().clone();
    }

    public URL getURL() throws MalformedURLException {
        if (this.getURLBase() == null || this.getURLString().indexOf(58) > 0) {
            this.validateProtocol(this.getURLString());
        }
        return new URL(this.getURLBase(), this.getURLString());
    }

    public String getTarget() {
        return this._target;
    }

    public abstract String getMethod();

    public String getQueryString() {
        return "";
    }

    public void setParameter(String name, String value) {
        this._parameterHolder.setParameter(name, value);
    }

    public void setParameter(String name, String[] values) {
        this._parameterHolder.setParameter(name, values);
    }

    public void setParameter(String parameterName, UploadFileSpec[] files) {
        if (!this.maySelectFile(parameterName)) {
            throw new IllegalNonFileParameterException(parameterName);
        }
        if (!this.isMimeEncoded()) {
            throw new MultipartFormRequiredException();
        }
        this._parameterHolder.setParameter(parameterName, files);
    }

    public void setImageButtonClickPosition(int x, int y) throws IllegalRequestParameterException {
        if (this._button == null) {
            throw new IllegalButtonPositionException();
        }
        this._parameterHolder.selectImageButtonPosition(this._button, x, y);
    }

    public boolean isFileParameter(String name) {
        return this._parameterHolder.isFileParameter(name);
    }

    public void selectFile(String parameterName, File file) {
        this.setParameter(parameterName, new UploadFileSpec[]{new UploadFileSpec(file)});
    }

    public void selectFile(String parameterName, File file, String contentType) {
        this.setParameter(parameterName, new UploadFileSpec[]{new UploadFileSpec(file, contentType)});
    }

    public void selectFile(String parameterName, String fileName, InputStream inputStream, String contentType) {
        this.setParameter(parameterName, new UploadFileSpec[]{new UploadFileSpec(fileName, inputStream, contentType)});
    }

    public Enumeration getParameterNames() {
        return new Vector<String>(Arrays.asList(this._parameterHolder.getParameterNames())).elements();
    }

    public String[] getRequestParameterNames() {
        return this._parameterHolder.getParameterNames();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        return values.length == 0 ? "" : values[0];
    }

    public String[] getParameterValues(String name) {
        return this._parameterHolder.getParameterValues(name);
    }

    public void removeParameter(String name) {
        this._parameterHolder.removeParameter(name);
    }

    public String toString() {
        return this.getMethod() + " request for " + this.getURLString();
    }

    protected WebRequest(String urlString) {
        this(null, urlString);
    }

    protected WebRequest(URL urlBase, String urlString) {
        this(urlBase, urlString, TOP_FRAME);
    }

    protected WebRequest(WebRequest baseRequest, String urlString, String target) throws MalformedURLException {
        this(baseRequest.getURL(), urlString, target);
    }

    protected WebRequest(URL urlBase, String urlString, String target) {
        this(urlBase, urlString, target, new UncheckedParameterHolder());
    }

    protected WebRequest(WebForm sourceForm, SubmitButton button, int x, int y) {
        this(sourceForm);
        if (button != null && button.isImageButton() && button.getName().length() > 0) {
            this._button = button;
            this._parameterHolder.selectImageButtonPosition(this._button, x, y);
        }
    }

    protected WebRequest(WebRequestSource requestSource) {
        this(requestSource.getBaseURL(), requestSource.getRelativeURL(), requestSource.getTarget(), WebRequest.newParameterHolder(requestSource));
        this.setHeaderField("Referer", requestSource.getBaseURL().toExternalForm());
    }

    private static ParameterHolder newParameterHolder(WebRequestSource requestSource) {
        if (HttpUnitOptions.getParameterValuesValidated()) {
            return requestSource;
        }
        return new UncheckedParameterHolder(requestSource);
    }

    private WebRequest(URL urlBase, String urlString, String target, ParameterHolder parameterHolder) {
        this._urlBase = urlBase;
        this._urlString = urlString;
        this._target = target;
        this._parameterHolder = parameterHolder;
    }

    protected boolean maySelectFile(String parameterName) {
        return this.isFileParameter(parameterName);
    }

    protected void setMimeEncoded(boolean mimeEncoded) {
        this._parameterHolder.setSubmitAsMime(mimeEncoded);
    }

    protected boolean isMimeEncoded() {
        return this._parameterHolder.isSubmitAsMime();
    }

    protected String getContentType() {
        return null;
    }

    protected final String getCharacterSet() {
        return this._parameterHolder.getCharacterSet();
    }

    protected void completeRequest(URLConnection connection) throws IOException {
    }

    protected void writeMessageBody(OutputStream stream) throws IOException {
    }

    protected final URL getURLBase() {
        return this._urlBase;
    }

    protected String getURLString() {
        String queryString = this.getQueryString();
        if (queryString.length() == 0) {
            return this._urlString;
        }
        return this._urlString + "?" + queryString;
    }

    protected final ParameterHolder getParameterHolder() {
        return this._parameterHolder;
    }

    Hashtable getHeaderDictionary() {
        if (this._headers == null) {
            this._headers = new Hashtable();
            if (this.getContentType() != null) {
                this._headers.put("Content-Type", this.getContentType());
            }
        }
        return this._headers;
    }

    private void validateProtocol(String urlString) {
        if (urlString.indexOf(58) <= 0) {
            throw new RuntimeException("No protocol specified in URL '" + urlString + "'");
        }
        String protocol = urlString.substring(0, urlString.indexOf(58));
        if (protocol.equalsIgnoreCase("http")) {
            return;
        }
        if (protocol.equalsIgnoreCase("https")) {
            this.validateHttpsProtocolSupport();
        }
    }

    void validateHttpsProtocolSupport() {
        if (!this._httpsProtocolSupportEnabled) {
            WebRequest.verifyHttpsSupport();
            this._httpsProtocolSupportEnabled = true;
        }
    }

    private static boolean hasProvider(Class providerClass) {
        Provider[] list = Security.getProviders();
        int i = 0;
        while (i < list.length) {
            if (list[i].getClass().equals(providerClass)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void verifyHttpsSupport() {
        if (System.getProperty("java.version").startsWith("1.1")) {
            throw new RuntimeException("https support requires Java 2");
        }
        try {
            Class<?> providerClass = Class.forName(SunJSSE_PROVIDER_CLASS);
            if (!WebRequest.hasProvider(providerClass)) {
                Security.addProvider((Provider)providerClass.newInstance());
            }
            WebRequest.registerSSLProtocolHandler();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("https support requires the Java Secure Sockets Extension. See http://java.sun.com/products/jsse");
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to enable https support. Make sure that you have installed JSSE as described in http://java.sun.com/products/jsse/install.html: " + e);
        }
    }

    private static void registerSSLProtocolHandler() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String list = System.getProperty(PROTOCOL_HANDLER_PKGS);
        Method setMethod = (class$java$lang$System == null ? (class$java$lang$System = WebRequest.class$("java.lang.System")) : class$java$lang$System).getMethod("setProperty", class$java$lang$String == null ? (class$java$lang$String = WebRequest.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = WebRequest.class$("java.lang.String")) : class$java$lang$String);
        if (list == null || list.length() == 0) {
            setMethod.invoke(null, (Object[])new String[]{PROTOCOL_HANDLER_PKGS, SSL_PROTOCOL_HANDLER});
        } else if (list.indexOf(SSL_PROTOCOL_HANDLER) < 0) {
            setMethod.invoke(null, (Object[])new String[]{PROTOCOL_HANDLER_PKGS, "com.sun.net.ssl.internal.www.protocol | " + list});
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TOP_FRAME = TOP_FRAME;
        PROTOCOL_HANDLER_PKGS = PROTOCOL_HANDLER_PKGS;
        SunJSSE_PROVIDER_CLASS = SunJSSE_PROVIDER_CLASS;
        SSL_PROTOCOL_HANDLER = SSL_PROTOCOL_HANDLER;
    }
}

