/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.parser;

import com.icesoft.faces.webapp.parser.UnknownJSFImplementationException;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImplementationUtil {
    protected static Log log = LogFactory.getLog((Class)ImplementationUtil.class);
    private static boolean isRI = false;
    private static boolean isMyFaces = false;
    private static boolean isJSF12 = false;
    private static String RI_MARKER = "com.sun.faces.application.ApplicationImpl";
    private static String MYFACES_MARKER = "org.apache.myfaces.application.ApplicationImpl";
    private static String JSF12_MARKER = "javax.faces.webapp.UIComponentELTag";
    private static String RI_COMPONENT_STACK_KEY = "javax.faces.webapp.COMPONENT_TAG_STACK";
    private static String MYFACES_COMPONENT_STACK_KEY = "javax.faces.webapp.UIComponentTag.COMPONENT_STACK";

    public static boolean isRI() {
        return isRI;
    }

    public static boolean isMyFaces() {
        return isMyFaces;
    }

    public static boolean isJSF12() {
        return isJSF12;
    }

    public static String getComponentStackKey() {
        String key = null;
        if (isRI) {
            key = RI_COMPONENT_STACK_KEY;
        } else if (isMyFaces) {
            key = MYFACES_COMPONENT_STACK_KEY;
        }
        if (key != null) {
            return key;
        }
        if (log.isFatalEnabled()) {
            log.fatal((Object)"cannot detect JSF implementation so cannot determine component stack key");
        }
        throw new UnknownJSFImplementationException("cannot determine component stack key");
    }

    public static List getComponentStack(PageContext pageContext) {
        List list = (List)pageContext.getAttribute(ImplementationUtil.getComponentStackKey(), 2);
        if (null == list) {
            list = (List)FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(ImplementationUtil.getComponentStackKey());
        }
        return list;
    }

    static {
        try {
            Class.forName(RI_MARKER);
            isRI = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            Class.forName(MYFACES_MARKER);
            isMyFaces = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("JSF-RI: " + isRI + "  MyFaces: " + isMyFaces));
        }
        try {
            Class.forName(JSF12_MARKER);
            isJSF12 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("JSF-12: " + isJSF12));
        }
    }
}

