/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.StringHelper;

public class TableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog(TableGenerator.class);
    public static final String TABLE_PARAM = "table_name";
    public static final String DEF_TABLE = "hibernate_sequences";
    public static final String VALUE_COLUMN_PARAM = "value_column_name";
    public static final String DEF_VALUE_COLUMN = "next_val";
    public static final String SEGMENT_COLUMN_PARAM = "segment_column_name";
    public static final String DEF_SEGMENT_COLUMN = "sequence_name";
    public static final String SEGMENT_VALUE_PARAM = "segment_value";
    public static final String DEF_SEGMENT_VALUE = "default";
    public static final String SEGMENT_LENGTH_PARAM = "segment_value_length";
    public static final int DEF_SEGMENT_LENGTH = 255;
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    private String tableName;
    private String valueColumnName;
    private String segmentColumnName;
    private String segmentValue;
    private int segmentValueLength;
    private int initialValue;
    private int incrementSize;
    private Type identifierType;
    private String query;
    private String insert;
    private String update;
    private Optimizer optimizer;
    private long accessCount = 0L;

    public String getTableName() {
        return this.tableName;
    }

    public String getSegmentColumnName() {
        return this.segmentColumnName;
    }

    public String getSegmentValue() {
        return this.segmentValue;
    }

    public int getSegmentValueLength() {
        return this.segmentValueLength;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public long getTableAccessCount() {
        return this.accessCount;
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.tableName = PropertiesHelper.getString(TABLE_PARAM, params, DEF_TABLE);
        if (this.tableName.indexOf(46) < 0) {
            String schemaName = params.getProperty("schema");
            String catalogName = params.getProperty("catalog");
            this.tableName = Table.qualify(catalogName, schemaName, this.tableName);
        }
        this.segmentColumnName = PropertiesHelper.getString(SEGMENT_COLUMN_PARAM, params, DEF_SEGMENT_COLUMN);
        this.segmentValue = params.getProperty(SEGMENT_VALUE_PARAM);
        if (StringHelper.isEmpty(this.segmentValue)) {
            log.debug((Object)("explicit segment value for id generator [" + this.tableName + '.' + this.segmentColumnName + "] suggested; using default [" + DEF_SEGMENT_VALUE + "]"));
            this.segmentValue = DEF_SEGMENT_VALUE;
        }
        this.segmentValueLength = PropertiesHelper.getInt(SEGMENT_LENGTH_PARAM, params, 255);
        this.valueColumnName = PropertiesHelper.getString(VALUE_COLUMN_PARAM, params, DEF_VALUE_COLUMN);
        this.initialValue = PropertiesHelper.getInt(INITIAL_PARAM, params, 1);
        this.incrementSize = PropertiesHelper.getInt(INCREMENT_PARAM, params, 1);
        this.identifierType = type;
        String query = "select " + this.valueColumnName + " from " + this.tableName + " tbl" + " where tbl." + this.segmentColumnName + "=?";
        HashMap<String, LockMode> lockMap = new HashMap<String, LockMode>();
        lockMap.put("tbl", LockMode.UPGRADE);
        this.query = dialect.applyLocksToSql(query, lockMap, CollectionHelper.EMPTY_MAP);
        this.update = "update " + this.tableName + " set " + this.valueColumnName + "=? " + " where " + this.valueColumnName + "=? and " + this.segmentColumnName + "=?";
        this.insert = "insert into " + this.tableName + " (" + this.segmentColumnName + ", " + this.valueColumnName + ") " + " values (?,?)";
        String defOptStrategy = this.incrementSize <= 1 ? "none" : "pooled";
        String optimizationStrategy = PropertiesHelper.getString(OPT_PARAM, params, defOptStrategy);
        this.optimizer = OptimizerFactory.buildOptimizer(optimizationStrategy, this.identifierType.getReturnedClass(), this.incrementSize);
    }

    public synchronized Serializable generate(final SessionImplementor session, Object obj) {
        return this.optimizer.generate(new AccessCallback(){

            public long getNextValue() {
                return ((Number)TableGenerator.this.doWorkInNewTransaction(session)).longValue();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable doWorkInCurrentTransaction(Connection conn, String sql) throws SQLException {
        int result;
        int rows;
        do {
            Object var13_13;
            Object var11_12;
            sql = this.query;
            SQL.debug((Object)sql);
            PreparedStatement queryPS = conn.prepareStatement(this.query);
            try {
                try {
                    ResultSet queryRS;
                    block14: {
                        queryPS.setString(1, this.segmentValue);
                        queryRS = queryPS.executeQuery();
                        if (!queryRS.next()) {
                            Object var9_11;
                            Statement insertPS = null;
                            try {
                                result = this.initialValue;
                                sql = this.insert;
                                SQL.debug((Object)sql);
                                insertPS = conn.prepareStatement(this.insert);
                                insertPS.setString(1, this.segmentValue);
                                insertPS.setLong(2, result);
                                insertPS.execute();
                                var9_11 = null;
                                if (insertPS == null) break block14;
                            }
                            catch (Throwable throwable) {
                                var9_11 = null;
                                if (insertPS != null) {
                                    insertPS.close();
                                }
                                throw throwable;
                            }
                            insertPS.close();
                        } else {
                            result = queryRS.getInt(1);
                        }
                    }
                    queryRS.close();
                }
                catch (SQLException sqle) {
                    log.error((Object)"could not read or init a hi value", (Throwable)sqle);
                    throw sqle;
                }
                var11_12 = null;
            }
            catch (Throwable throwable) {
                var11_12 = null;
                queryPS.close();
                throw throwable;
            }
            queryPS.close();
            sql = this.update;
            SQL.debug((Object)sql);
            PreparedStatement updatePS = conn.prepareStatement(this.update);
            try {
                try {
                    long newValue = this.optimizer.applyIncrementSizeToSourceValues() ? (long)(result + this.incrementSize) : (long)(result + 1);
                    updatePS.setLong(1, newValue);
                    updatePS.setLong(2, result);
                    updatePS.setString(3, this.segmentValue);
                    rows = updatePS.executeUpdate();
                }
                catch (SQLException sqle) {
                    log.error((Object)("could not update hi value in: " + this.tableName), (Throwable)sqle);
                    throw sqle;
                }
                var13_13 = null;
            }
            catch (Throwable throwable) {
                var13_13 = null;
                updatePS.close();
                throw throwable;
            }
            updatePS.close();
        } while (rows == 0);
        ++this.accessCount;
        return new Integer(result);
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{new StringBuffer().append(dialect.getCreateTableString()).append(' ').append(this.tableName).append(" ( ").append(this.segmentColumnName).append(' ').append(dialect.getTypeName(12, this.segmentValueLength, 0, 0)).append(",  ").append(this.valueColumnName).append(' ').append(dialect.getTypeName(-5)).append(" ) ").toString()};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer sqlDropString = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sqlDropString.append("if exists ");
        }
        sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sqlDropString.append(" if exists");
        }
        return new String[]{sqlDropString.toString()};
    }

    public Object generatorKey() {
        return this.tableName;
    }
}

