/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.jboss.remoting.serialization.SerializationStreamFactory;
import org.jboss.remoting.transport.socket.SocketWrapper;

public class ClientSocketWrapper
extends SocketWrapper {
    private ObjectInputStream in;
    private ObjectOutputStream out;

    public ClientSocketWrapper(Socket socket) throws IOException {
        super(socket);
        this.createStreams(socket, null);
    }

    public ClientSocketWrapper(Socket socket, Map metadata, Integer timeout) throws Exception {
        super(socket, timeout);
        this.createStreams(socket, metadata);
    }

    protected void createStreams(Socket socket, Map metadata) throws IOException {
        String serializationType = "java";
        if (metadata != null) {
            String serializationTypeParam = (String)metadata.get("serializationtype");
            if (serializationTypeParam == null || serializationTypeParam.length() == 0) {
                serializationTypeParam = (String)metadata.get("serializationType");
            }
            if (serializationTypeParam != null && serializationTypeParam.length() > 0) {
                serializationType = serializationTypeParam;
            }
        }
        this.out = this.createOutputStream(serializationType, socket);
        this.in = this.createInputStream(serializationType, socket);
    }

    protected ObjectInputStream createInputStream(String serializationType, Socket socket) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(socket.getInputStream());
        ObjectInputStream oin = SerializationStreamFactory.getManagerInstance(serializationType).createInput(bin, null);
        return oin;
    }

    protected ObjectOutputStream createOutputStream(String serializationType, Socket socket) throws IOException {
        BufferedOutputStream bout = new BufferedOutputStream(socket.getOutputStream());
        ObjectOutputStream oout = SerializationStreamFactory.getManagerInstance(serializationType).createOutput(bout);
        return oout;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void checkConnection() throws IOException {
        boolean ACK = true;
        this.out.reset();
        this.out.writeByte(1);
        this.out.flush();
        this.in.readByte();
    }
}

