/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp1307;

import java.util.List;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.annotation.ejb.RemoteBinding;


/**
 * SimpleSLSB
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
@Stateless
@Remote (SLSBRemote.class)
@RemoteBinding(jndiBinding = SLSBRemote.JNDI_NAME)
public class SimpleSLSB implements SLSBRemote
{

   @PersistenceContext (unitName="jbpapp1307-PU")
   private EntityManager emOne;
   
   public List<Entity1> getAllEntities()
   {
      List<Entity1> result = this.emOne.createNamedQuery(Entity1.FIND_ALL).getResultList();
      return result;
   }
   
   public Entity1 createNewEntity(String data)
   {
      Entity1 e1 = new Entity1();
      e1.setData(data);
      this.emOne.persist(e1);
      return e1;
   }
}
