/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.jboss.logging.Logger;

public abstract class SocketWrapper {
    private static final Logger log = Logger.getLogger((Class)SocketWrapper.class);
    public static final String MARSHALLER = "marshaller";
    public static final String UNMARSHALLER = "unmarshaller";
    public static final String TEMP_TIMEOUT = "temptimeout";
    public static final String WRITE_TIMEOUT = "writeTimeout";
    protected static final int CLOSING = 254;
    private static boolean trace = log.isTraceEnabled();
    protected Socket socket;
    private int timeout;

    protected SocketWrapper(Socket socket) {
        if (trace) {
            log.trace((Object)("constructing " + this.getClass().getName() + " instance for " + socket));
        }
        this.socket = socket;
    }

    protected SocketWrapper(Socket socket, Integer timeoutInt) throws SocketException {
        if (trace) {
            log.trace((Object)("constructing " + this.getClass().getName() + " instance for " + socket + ", using timeout " + timeoutInt));
        }
        this.socket = socket;
        if (timeoutInt != null) {
            this.timeout = timeoutInt;
            this.setTimeout(this.timeout);
        }
    }

    public void setTimeout(int timeout) throws SocketException {
        if (trace) {
            log.trace((Object)(this + " setting timeout to " + timeout));
        }
        this.timeout = timeout;
        if (this.socket != null) {
            this.socket.setSoTimeout(timeout);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void close() throws IOException {
        OutputStream out;
        InputStream in = this.getInputStream();
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                log.debug((Object)"unable to close input stream");
            }
        }
        if ((out = this.getOutputStream()) != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                log.debug((Object)"unable to close output stream");
            }
        }
        if (this.socket != null) {
            log.trace((Object)(this + " closing socket"));
            this.socket.close();
            log.trace((Object)(this + " closed socket"));
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract void checkConnection() throws IOException;

    protected void finalize() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                log.debug((Object)(this + " failed to close socket"), (Throwable)e);
            }
        }
    }
}

