/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.ConfigureException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionConfiguration;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.EvictionTimerTask;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.eviction.RegionNameConflictException;
import org.jboss.cache.optimistic.FqnComparator;
import org.jboss.cache.xml.XmlHelper;
import org.jgroups.View;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RegionManager {
    public static final int CAPACITY = 200000;
    public static final Fqn DEFAULT_REGION = new Fqn("_default_");
    private static final Log log_ = LogFactory.getLog((Class)RegionManager.class);
    private final Map regionMap_ = new ConcurrentHashMap();
    private int longestFqn = 0;
    private Timer evictionThread_;
    private EvictionTimerTask evictionTimerTask_ = new EvictionTimerTask();
    private int evictionThreadWakeupIntervalSeconds_;
    private TreeCache cache_;
    private EvictionPolicy policy_;

    public int getEvictionThreadWakeupIntervalSeconds() {
        return this.evictionThreadWakeupIntervalSeconds_;
    }

    public Region createRegion(String fqn, EvictionAlgorithm algorithm) throws RegionNameConflictException {
        return this.createRegion(Fqn.fromString(fqn), algorithm);
    }

    public Region createRegion(Fqn fqn, EvictionAlgorithm algorithm) throws RegionNameConflictException {
        EvictionConfiguration configuration;
        if (this.policy_ == null) {
            throw new RuntimeException("Deprecated API not properly setup for use. The RegionManager must be constructed with a single Policy");
        }
        try {
            configuration = (EvictionConfiguration)this.policy_.getEvictionConfigurationClass().newInstance();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate EvictionConfigurationClass", e);
        }
        Region region = new Region(fqn, this.policy_, configuration);
        this.addRegion(fqn, region);
        this.evictionTimerTask_.addRegionToProcess(region);
        return region;
    }

    private void addRegion(Fqn fqn, Region region) throws RegionNameConflictException {
        this.checkConflict(fqn);
        this.regionMap_.put(fqn, region);
        this.longestFqn = Math.max(this.longestFqn, fqn.size());
    }

    public Region createRegion(String fqn, Element regionConfig) throws RegionNameConflictException {
        return this.createRegion(Fqn.fromString(fqn), regionConfig);
    }

    public Region createRegion(Fqn fqn, Element regionConfig) throws RegionNameConflictException {
        EvictionPolicy policy = this.createEvictionPolicy(regionConfig);
        EvictionConfiguration config = this.configureEvictionPolicy(policy, regionConfig);
        String temp = regionConfig.getAttribute("eventQueueSize");
        int eventQueueSize = 0;
        if (!"".equals(temp)) {
            eventQueueSize = Integer.parseInt(temp);
        }
        return this.createRegion(fqn, policy, config, eventQueueSize);
    }

    public Region createRegion(String fqn, EvictionPolicy policy, EvictionConfiguration config) throws RegionNameConflictException {
        return this.createRegion(Fqn.fromString(fqn), policy, config);
    }

    public Region createRegion(Fqn fqn, EvictionPolicy policy, EvictionConfiguration config) throws RegionNameConflictException {
        return this.createRegion(fqn, policy, config, 0);
    }

    public Region createRegion(Fqn fqn, EvictionPolicy policy, EvictionConfiguration config, int eventQueueSize) throws RegionNameConflictException {
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("createRegion(): creating region for fqn- " + fqn));
        }
        Region region = new Region(fqn, policy, config);
        if (eventQueueSize > 0) {
            region.setEventQueueSize(eventQueueSize);
        }
        this.addRegion(fqn, region);
        this.evictionTimerTask_.addRegionToProcess(region);
        return region;
    }

    public void configure(TreeCache cache) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)"Configuring the eviction region manager");
        }
        this.cache_ = cache;
        String evictionClass = this.cache_.getEvictionPolicyClass();
        if (evictionClass != null && evictionClass.length() != 0) {
            try {
                this.policy_ = (EvictionPolicy)RegionManager.loadClass(evictionClass).newInstance();
                this.policy_.configure(this.cache_);
                this.cache_.setEvictionPolicyProvider(this.policy_);
            }
            catch (Exception e) {
                log_.warn((Object)("Default Policy with class name " + evictionClass + " could not be loaded by the classloader"));
            }
        }
        EvictionTreeCacheListener listener = new EvictionTreeCacheListener();
        this.cache_.setEvictionListener(listener);
        Element elem = this.cache_.getEvictionPolicyConfig();
        String temp = XmlHelper.getAttr(elem, "wakeUpIntervalSeconds", "attribute", "name");
        this.evictionThreadWakeupIntervalSeconds_ = temp == null ? 5 : Integer.parseInt(temp);
        if (this.evictionThreadWakeupIntervalSeconds_ <= 0) {
            this.evictionThreadWakeupIntervalSeconds_ = 5;
        }
        NodeList list = elem.getElementsByTagName("region");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String name = element.getAttribute("name");
            try {
                this.createRegion(name, element);
                continue;
            }
            catch (RegionNameConflictException e) {
                throw new RuntimeException("Illegal region name specified for eviction policy " + name + " exception: " + e);
            }
        }
    }

    public void removeRegion(String fqn) {
        this.removeRegion(Fqn.fromString(fqn));
    }

    public boolean removeRegion(Fqn fqn) {
        Region region = (Region)this.regionMap_.remove(fqn);
        this.evictionTimerTask_.removeRegionToProcess(region);
        return region != null;
    }

    public boolean hasRegion(String myFqn) {
        return this.hasRegion(Fqn.fromString(myFqn));
    }

    public boolean hasRegion(Fqn fqn) {
        return this.regionMap_.containsKey(fqn);
    }

    public Region getRegion(String myFqn) {
        return this.getRegion(Fqn.fromString(myFqn));
    }

    public Region getRegion(Fqn fqn) {
        Region region;
        if (fqn.size() > this.longestFqn) {
            fqn = fqn.getFqnChild(0, this.longestFqn);
        }
        while (!fqn.isRoot()) {
            region = (Region)this.regionMap_.get(fqn);
            if (region != null) {
                return region;
            }
            fqn = fqn.getParent();
        }
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("getRegion(): user-specified region not found: " + fqn + " will use the global default region"));
        }
        if ((region = (Region)this.regionMap_.get(DEFAULT_REGION)) == null) {
            throw new RuntimeException("RegionManager.getRegion(): Default region (" + DEFAULT_REGION + ") is not configured!" + " You will need to define it in your EvictionPolicyConfig.");
        }
        return region;
    }

    public Region[] getRegions() {
        TreeSet s = new TreeSet(new RegionComparator());
        Iterator i = this.regionMap_.values().iterator();
        while (i.hasNext()) {
            s.add(i.next());
        }
        return s.toArray(new Region[0]);
    }

    public void checkConflict(String myFqn) throws RegionNameConflictException {
        this.checkConflict(Fqn.fromString(myFqn));
    }

    public void checkConflict(Fqn fqn) throws RegionNameConflictException {
        for (int i = 0; i <= fqn.size(); ++i) {
            Fqn child = fqn.getFqnChild(i);
            if (!this.regionMap_.containsKey(child)) continue;
            throw new RegionNameConflictException("RegionManager.checkConflict(): new region fqn " + fqn + " is in conflict with existing region fqn " + child);
        }
    }

    public void markNodeCurrentlyInUse(Fqn fqn, long timeout) {
        Region region = this.getRegion(fqn);
        EvictedEventNode markUse = new EvictedEventNode(fqn, 5);
        markUse.setInUseTimeout(timeout);
        region.putNodeEvent(markUse);
    }

    public void unmarkNodeCurrentlyInUse(Fqn fqn) {
        Region region = this.getRegion(fqn);
        EvictedEventNode markNoUse = new EvictedEventNode(fqn, 6);
        region.putNodeEvent(markNoUse);
    }

    final void setTreeCache(TreeCache cache) {
        this.cache_ = cache;
    }

    private EvictionConfiguration configureEvictionPolicy(EvictionPolicy policy, Element regionConfig) {
        try {
            EvictionConfiguration configuration = (EvictionConfiguration)policy.getEvictionConfigurationClass().newInstance();
            configuration.parseXMLConfig(regionConfig);
            return configuration;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (ConfigureException e) {
            throw new RuntimeException("Error configuring Eviction Policy", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Eviction configuration class is not properly loaded in classloader", e);
        }
    }

    private EvictionPolicy createEvictionPolicy(Element regionConfig) {
        String evictionClass = regionConfig.getAttribute("policyClass");
        if (!(evictionClass != null && evictionClass.length() != 0 || (evictionClass = this.cache_.getEvictionPolicyClass()) != null && evictionClass.length() != 0)) {
            throw new RuntimeException("There is no Eviction Policy Class specified on the region or for the entire cache!");
        }
        try {
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("Creating policy " + evictionClass));
            }
            EvictionPolicy policy = (EvictionPolicy)RegionManager.loadClass(evictionClass).newInstance();
            policy.configure(this.cache_);
            return policy;
        }
        catch (Exception e) {
            throw new RuntimeException("Eviction class is not properly loaded in classloader", e);
        }
    }

    public static boolean isUsingNewStyleConfiguration(Element evictionRegionConfigElem) {
        if (evictionRegionConfigElem == null) {
            return false;
        }
        NodeList list = evictionRegionConfigElem.getElementsByTagName("region");
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            String evictionClass;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || (evictionClass = (element = (Element)node).getAttribute("policyClass")) == null || evictionClass.trim().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return super.toString() + " regions=" + this.regionMap_;
    }

    private static Class loadClass(String classname) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl.loadClass(classname);
    }

    static class RegionComparator
    implements Comparator {
        RegionComparator() {
        }

        public int compare(Object o1, Object o2) {
            Region r1 = (Region)o1;
            Region r2 = (Region)o2;
            Fqn f1 = r1.getFqnObject();
            Fqn f2 = r2.getFqnObject();
            if (f1.equals(DEFAULT_REGION)) {
                return -1;
            }
            if (f2.equals(DEFAULT_REGION)) {
                return 1;
            }
            return -FqnComparator.INSTANCE.compare(f1, f2);
        }
    }

    class EvictionTreeCacheListener
    implements TreeCacheListener {
        EvictionTreeCacheListener() {
        }

        public void nodeCreated(Fqn fqn) {
        }

        public void nodeRemoved(Fqn fqn) {
        }

        public void nodeLoaded(Fqn fqn) {
        }

        public void nodeEvicted(Fqn fqn) {
        }

        public void nodeModified(Fqn fqn) {
        }

        public void nodeVisited(Fqn fqn) {
        }

        public void cacheStarted(TreeCache cache) {
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"Starting eviction timer");
            }
            RegionManager.this.evictionThread_ = new Timer();
            RegionManager.this.evictionThread_.schedule((TimerTask)RegionManager.this.evictionTimerTask_, RegionManager.this.getEvictionThreadWakeupIntervalSeconds() * 1000, (long)(RegionManager.this.getEvictionThreadWakeupIntervalSeconds() * 1000));
        }

        public void cacheStopped(TreeCache cache) {
            if (log_.isDebugEnabled()) {
                log_.info((Object)"Stopping eviction timer ... ");
            }
            if (RegionManager.this.evictionThread_ != null) {
                RegionManager.this.evictionThread_.cancel();
            }
            RegionManager.this.evictionThread_ = null;
        }

        public void viewChange(View new_view) {
        }
    }
}

