/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.util.Iterator;
import java.util.LinkedList;
import org.drools.common.DefaultFactHandle;
import org.drools.common.PropagationContextImpl;
import org.drools.leaps.ConflictResolver;
import org.drools.leaps.LeapsFactHandle;
import org.drools.leaps.LeapsRuleHandle;
import org.drools.leaps.LeapsTuple;
import org.drools.leaps.LeapsWorkingMemory;
import org.drools.leaps.RuleTable;
import org.drools.leaps.Token;
import org.drools.leaps.util.Table;
import org.drools.leaps.util.TableIterator;

class FactTable
extends Table {
    private static final long serialVersionUID = 5964698708240814905L;
    private final RuleTable rules;
    private boolean reseededStack = false;
    private LinkedList tuples;

    public FactTable(ConflictResolver conflictResolver) {
        super(conflictResolver.getFactConflictResolver());
        this.rules = new RuleTable(conflictResolver.getRuleConflictResolver());
        this.tuples = new LinkedList();
    }

    public void addRule(LeapsWorkingMemory leapsWorkingMemory, LeapsRuleHandle leapsRuleHandle) {
        if (!this.rules.contains(leapsRuleHandle)) {
            this.rules.add(leapsRuleHandle);
            this.checkAndAddFactsToStack(leapsWorkingMemory);
        }
    }

    public void removeRule(LeapsWorkingMemory leapsWorkingMemory, LeapsRuleHandle leapsRuleHandle) {
        this.rules.remove(leapsRuleHandle);
        LinkedList<LeapsTuple> linkedList = new LinkedList<LeapsTuple>();
        Iterator iterator = this.getTuplesIterator();
        while (iterator.hasNext()) {
            LeapsTuple leapsTuple = (LeapsTuple)iterator.next();
            if (leapsRuleHandle.getLeapsRule().getRule() == leapsTuple.getLeapsRule().getRule()) continue;
            linkedList.add(leapsTuple);
        }
        this.tuples = linkedList;
    }

    private void checkAndAddFactsToStack(LeapsWorkingMemory leapsWorkingMemory) {
        if (this.reseededStack) {
            this.setReseededStack(false);
            PropagationContextImpl propagationContextImpl = new PropagationContextImpl(leapsWorkingMemory.nextPropagationIdCounter(), 0, null, null);
            DefaultFactHandle defaultFactHandle = new DefaultFactHandle(leapsWorkingMemory.getIdLastFireAllAt(), new Object());
            TableIterator tableIterator = this.iteratorFromPositionToTableStart(defaultFactHandle, defaultFactHandle);
            while (tableIterator.hasNext()) {
                LeapsFactHandle leapsFactHandle = (LeapsFactHandle)tableIterator.next();
                leapsWorkingMemory.pushTokenOnStack(leapsFactHandle, new Token(leapsWorkingMemory, leapsFactHandle, propagationContextImpl));
            }
        }
    }

    public void setReseededStack(boolean bl) {
        this.reseededStack = bl;
    }

    public Iterator getRulesIterator() {
        return this.rules.iterator();
    }

    public String toString() {
        DefaultFactHandle defaultFactHandle;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            defaultFactHandle = (LeapsFactHandle)iterator.next();
            stringBuffer.append("\n" + defaultFactHandle + "[" + defaultFactHandle.getObject() + "]");
        }
        stringBuffer.append("\nTuples :");
        iterator = this.tuples.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n" + iterator.next());
        }
        stringBuffer.append("\nRules :");
        iterator = this.rules.iterator();
        while (iterator.hasNext()) {
            defaultFactHandle = (LeapsRuleHandle)iterator.next();
            stringBuffer.append("\n\t" + ((LeapsRuleHandle)defaultFactHandle).getLeapsRule().getRule().getName() + "[dominant - " + ((LeapsRuleHandle)defaultFactHandle).getDominantPosition() + "]");
        }
        return stringBuffer.toString();
    }

    protected Iterator getTuplesIterator() {
        return this.tuples.iterator();
    }

    protected void addTuple(LeapsTuple leapsTuple) {
        this.tuples.add(leapsTuple);
    }
}

