/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.common.ObjectInputStreamWithLoader;
import org.drools.rule.EvalCondition;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueConstraint;
import org.drools.rule.Rule;
import org.drools.spi.Consequence;
import org.drools.spi.EvalExpression;
import org.drools.spi.PredicateExpression;
import org.drools.spi.ReturnValueExpression;
import org.drools.util.KeyStoreHelper;

public class PackageCompilationData
implements Externalizable {
    private static final long serialVersionUID = -4351259299237235523L;
    private Map invokerLookups = new HashMap();
    private Object AST;
    private Map store = new HashMap();
    private transient PackageClassLoader classLoader;
    private transient ClassLoader parentClassLoader;

    public PackageCompilationData() {
        this(null);
    }

    public PackageCompilationData(ClassLoader classLoader) {
        this.init(classLoader);
    }

    private void init(ClassLoader classLoader) {
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.parentClassLoader = classLoader;
        this.classLoader = new PackageClassLoader(this.parentClassLoader);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        KeyStoreHelper keyStoreHelper = new KeyStoreHelper();
        objectOutput.writeBoolean(keyStoreHelper.isSigned());
        if (keyStoreHelper.isSigned()) {
            objectOutput.writeObject(keyStoreHelper.getPvtKeyAlias());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.store);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutput.writeObject(byArray);
        if (keyStoreHelper.isSigned()) {
            this.sign(objectOutput, keyStoreHelper, byArray);
        }
        objectOutput.writeObject(this.AST);
        byteArrayOutputStream = new ByteArrayOutputStream();
        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.invokerLookups);
        byArray = byteArrayOutputStream.toByteArray();
        objectOutput.writeObject(byArray);
        if (keyStoreHelper.isSigned()) {
            this.sign(objectOutput, keyStoreHelper, byArray);
        }
    }

    private void sign(ObjectOutput objectOutput, KeyStoreHelper keyStoreHelper, byte[] byArray) {
        try {
            objectOutput.writeObject(keyStoreHelper.signDataWithPrivateKey(byArray));
        }
        catch (Exception exception) {
            throw new RuntimeDroolsException("Error signing object store: " + exception.getMessage(), exception);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.init(null);
        KeyStoreHelper keyStoreHelper = new KeyStoreHelper();
        boolean bl = objectInput.readBoolean();
        if (keyStoreHelper.isSigned() != bl) {
            throw new RuntimeDroolsException("This environment is configured to work with " + (keyStoreHelper.isSigned() ? "signed" : "unsigned") + " serialized objects, but the given object is " + (bl ? "signed" : "unsigned") + ". Deserialization aborted.");
        }
        String string = null;
        if (bl) {
            string = (String)objectInput.readObject();
            if (keyStoreHelper.getPubKeyStore() == null) {
                throw new RuntimeDroolsException("The package was serialized with a signature. Please configure a public keystore with the public key to check the signature. Deserialization aborted.");
            }
        }
        byte[] byArray = (byte[])objectInput.readObject();
        if (bl) {
            this.checkSignature(objectInput, keyStoreHelper, byArray, string);
        }
        this.store = (Map)new ObjectInputStream(new ByteArrayInputStream(byArray)).readObject();
        this.AST = objectInput.readObject();
        byArray = (byte[])objectInput.readObject();
        if (bl) {
            this.checkSignature(objectInput, keyStoreHelper, byArray, string);
        }
        ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader(new ByteArrayInputStream(byArray), this.classLoader);
        this.invokerLookups = (Map)objectInputStreamWithLoader.readObject();
    }

    private void checkSignature(ObjectInput objectInput, KeyStoreHelper keyStoreHelper, byte[] byArray, String string) throws ClassNotFoundException, IOException {
        byte[] byArray2 = (byte[])objectInput.readObject();
        try {
            if (!keyStoreHelper.checkDataWithPublicKey(string, byArray, byArray2)) {
                throw new RuntimeDroolsException("Signature does not match serialized package. This is a security violation. Deserialisation aborted.");
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeDroolsException("Invalid key checking signature: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new RuntimeDroolsException("Error accessing Key Store: " + keyStoreException.getMessage(), keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeDroolsException("No algorithm available: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new RuntimeDroolsException("Signature Exception: " + signatureException.getMessage(), signatureException);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public byte[] read(String string) {
        byte[] byArray = null;
        if (this.store != null) {
            return (byte[])this.store.get(string.replace('.', '/') + ".class");
        }
        return byArray;
    }

    public void write(String string, byte[] byArray) throws RuntimeDroolsException {
        if (this.store.put(string.replace('.', '/') + ".class", byArray) != null) {
            this.reload();
        } else {
            try {
                this.wire(string);
            }
            catch (Exception exception) {
                throw new RuntimeDroolsException(exception);
            }
        }
    }

    public void remove(String string) throws RuntimeDroolsException {
        this.invokerLookups.remove(string);
        if (this.store.remove(string.replace('.', '/') + ".class") != null) {
            this.reload();
        }
    }

    public String[] list() {
        if (this.store == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.store.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            arrayList.add(string.replace('/', '.').substring(0, string.length() - 6));
        }
        return arrayList.toArray(new String[this.store.size()]);
    }

    public void reload() throws RuntimeDroolsException {
        this.classLoader = new PackageClassLoader(this.parentClassLoader);
        try {
            Iterator iterator = this.invokerLookups.keySet().iterator();
            while (iterator.hasNext()) {
                this.wire((String)iterator.next());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeDroolsException(classNotFoundException);
        }
        catch (InstantiationError instantiationError) {
            throw new RuntimeDroolsException(instantiationError);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeDroolsException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeDroolsException(instantiationException);
        }
    }

    public void clear() {
        this.store.clear();
        this.invokerLookups.clear();
        this.AST = null;
        this.reload();
    }

    public void wire(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object v = this.invokerLookups.get(string);
        this.wire(string, v);
    }

    public void wire(String string, Object object) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class clazz = this.classLoader.findClass(string);
        if (object instanceof ReturnValueConstraint) {
            ((ReturnValueConstraint)object).setReturnValueExpression((ReturnValueExpression)clazz.newInstance());
        } else if (object instanceof PredicateConstraint) {
            ((PredicateConstraint)object).setPredicateExpression((PredicateExpression)clazz.newInstance());
        } else if (object instanceof EvalCondition) {
            ((EvalCondition)object).setEvalExpression((EvalExpression)clazz.newInstance());
        } else if (object instanceof Rule) {
            ((Rule)object).setConsequence((Consequence)clazz.newInstance());
        }
    }

    public String toString() {
        return this.getClass().getName() + this.store.toString();
    }

    public void putInvoker(String string, Object object) {
        this.invokerLookups.put(string, object);
    }

    public void putAllInvokers(Map map) {
        this.invokerLookups.putAll(map);
    }

    public Map getInvokers() {
        return this.invokerLookups;
    }

    public void removeInvoker(String string) {
        this.invokerLookups.remove(string);
    }

    public Object getAST() {
        return this.AST;
    }

    public void setAST(Object object) {
        this.AST = object;
    }

    public class PackageClassLoader
    extends ClassLoader {
        public PackageClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class fastFindClass(String string) {
            byte[] byArray;
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null && (byArray = PackageCompilationData.this.read(string)) != null) {
                return this.defineClass(string, byArray, 0, byArray.length);
            }
            return clazz;
        }

        protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class<?> clazz = this.fastFindClass(string);
            if (clazz == null) {
                ClassLoader classLoader = this.getParent();
                if (classLoader != null) {
                    clazz = classLoader.loadClass(string);
                } else {
                    throw new ClassNotFoundException(string);
                }
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            Class clazz = this.fastFindClass(string);
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
            return clazz;
        }

        public InputStream getResourceAsStream(String string) {
            byte[] byArray = (byte[])PackageCompilationData.this.store.get(string);
            if (byArray != null) {
                return new ByteArrayInputStream(byArray);
            }
            InputStream inputStream = this.getParent().getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = super.getResourceAsStream(string);
            }
            return inputStream;
        }
    }
}

