/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFXObject;

public class PDFResources
extends PDFObject {
    protected Map fonts = new HashMap();
    protected List xObjects = null;
    protected List patterns = new ArrayList();
    protected List shadings = new ArrayList();

    public PDFResources(int number) {
        super(number);
    }

    public void addFont(PDFFont font) {
        this.fonts.put(font.getName(), font);
    }

    public void addShading(PDFShading theShading) {
        this.shadings.add(theShading);
    }

    public void addPattern(PDFPattern thePattern) {
        this.patterns.add(thePattern);
    }

    public void setXObjects(List xObjects) {
        this.xObjects = xObjects;
    }

    public byte[] toPDF() {
        StringBuffer p = new StringBuffer(this.number + " " + this.generation + " obj\n<< \n");
        if (!this.fonts.isEmpty()) {
            p.append("/Font << ");
            Iterator fontIterator = this.fonts.keySet().iterator();
            while (fontIterator.hasNext()) {
                String fontName = (String)fontIterator.next();
                p.append("/" + fontName + " " + ((PDFFont)this.fonts.get(fontName)).referencePDF() + " ");
            }
            p.append(">> \n");
        }
        PDFShading currentShading = null;
        if (!this.shadings.isEmpty()) {
            p.append("/Shading << ");
            for (int currentShadingNumber = 0; currentShadingNumber < this.shadings.size(); ++currentShadingNumber) {
                currentShading = (PDFShading)this.shadings.get(currentShadingNumber);
                p.append("/" + currentShading.getName() + " " + currentShading.referencePDF() + " ");
            }
            p.append(">> \n");
        }
        currentShading = null;
        PDFPattern currentPattern = null;
        if (!this.patterns.isEmpty()) {
            p.append("/Pattern << ");
            for (int currentPatternNumber = 0; currentPatternNumber < this.patterns.size(); ++currentPatternNumber) {
                currentPattern = (PDFPattern)this.patterns.get(currentPatternNumber);
                p.append("/" + currentPattern.getName() + " " + currentPattern.referencePDF() + " ");
            }
            p.append(">> \n");
        }
        currentPattern = null;
        p.append("/ProcSet [ /PDF /ImageC /Text ] ");
        if (!this.xObjects.isEmpty()) {
            p = p.append("/XObject <<");
            for (int i = 1; i <= this.xObjects.size(); ++i) {
                p = p.append("/Im" + i + " " + ((PDFXObject)this.xObjects.get(i - 1)).referencePDF() + " \n");
            }
            p = p.append(" >>\n");
        }
        p = p.append(">> \nendobj\n");
        try {
            return p.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ue) {
            return p.toString().getBytes();
        }
    }
}

