/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.Text;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.core.soap.DocumentFragmentImpl;
import org.jboss.ws.core.soap.NodeListImpl;
import org.jboss.ws.core.soap.SOAPDocument;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.jboss.ws.core.soap.TextImpl;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl
implements Node {
    private static Logger log = Logger.getLogger(NodeImpl.class);
    protected SOAPElementImpl soapParent;
    protected org.w3c.dom.Node domNode;
    private List<NodeImpl> soapChildren = new ArrayList<NodeImpl>();
    private Map<String, Object> userData;

    NodeImpl(org.w3c.dom.Node node) {
        if (node instanceof NodeImpl) {
            throw new IllegalArgumentException("Copy constructor should be used");
        }
        this.domNode = node;
        if (DOMUtils.hasChildElements((org.w3c.dom.Node)node)) {
            throw new IllegalArgumentException("Node cannot have child elements");
        }
    }

    NodeImpl(NodeImpl node) {
        this.soapParent = node.soapParent;
        this.domNode = node.domNode;
        for (NodeImpl childNode : node.soapChildren) {
            childNode.soapParent = (SOAPElementImpl)this;
            this.soapChildren.add(childNode);
        }
    }

    public void detachNode() {
        org.w3c.dom.Node domParent = this.domNode.getParentNode();
        if (domParent != null) {
            domParent.removeChild(this.domNode);
        }
        if (this.soapParent != null) {
            this.soapParent.soapChildren.remove(this);
        }
        this.soapParent = null;
    }

    public SOAPElement getParentElement() {
        return this.soapParent;
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        if (this.soapParent != null) {
            this.detachNode();
        }
        this.soapParent = (SOAPElementImpl)parent;
    }

    public String getValue() {
        if (this instanceof Text) {
            throw new WSException("javax.xml.soap.Text should take care of this");
        }
        String nodeValue = null;
        org.w3c.dom.Node child = this.getFirstChild();
        if (child instanceof org.w3c.dom.Text) {
            nodeValue = ((org.w3c.dom.Text)child).getNodeValue();
        }
        return nodeValue;
    }

    public void setValue(String value) {
        if (this instanceof Text) {
            throw new WSException("javax.xml.soap.Text should take care of this");
        }
        org.w3c.dom.Node child = this.getFirstChild();
        if (child instanceof org.w3c.dom.Text) {
            ((org.w3c.dom.Text)child).setNodeValue(value);
        }
        if (child == null) {
            child = this.domNode.getOwnerDocument().createTextNode(value);
            this.appendChild((org.w3c.dom.Node)((Object)new TextImpl(child)));
        }
    }

    public void recycleNode() {
    }

    private List<NodeImpl> convertDocumentFragment(DocumentFragment docFragment) throws DOMException {
        ArrayList<NodeImpl> list = new ArrayList<NodeImpl>();
        try {
            SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
            block7: for (org.w3c.dom.Node node = docFragment.getFirstChild(); node != null; node = node.getNextSibling()) {
                switch (node.getNodeType()) {
                    case 1: {
                        SOAPElementImpl soapChild = (SOAPElementImpl)soapFactory.createElement((Element)node);
                        list.add(soapChild);
                        continue block7;
                    }
                    case 3: {
                        TextImpl text = new TextImpl(node);
                        list.add(text);
                        continue block7;
                    }
                    case 4: {
                        TextImpl text = new TextImpl(node);
                        list.add(text);
                        continue block7;
                    }
                }
            }
        }
        catch (SOAPException ex) {
            throw new DOMException(11, "Could not convert a document fragment to a node");
        }
        return list;
    }

    public String getNodeName() {
        return this.domNode.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.domNode.getNodeValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.domNode.setNodeValue(nodeValue);
    }

    public short getNodeType() {
        return this.domNode.getNodeType();
    }

    public org.w3c.dom.Node getParentNode() {
        this.assertSOAPParent();
        return this.soapParent;
    }

    public NodeList getChildNodes() {
        return new NodeListImpl(this.soapChildren);
    }

    public org.w3c.dom.Node getFirstChild() {
        NodeImpl child = null;
        org.w3c.dom.Node domChild = this.domNode.getFirstChild();
        if (domChild != null) {
            child = this.soapChildren.get(0);
            if (domChild != child.domNode) {
                throw new WSException("Inconsistent node, child lists not synchronized");
            }
        }
        return child;
    }

    public org.w3c.dom.Node getLastChild() {
        NodeImpl child = null;
        org.w3c.dom.Node domChild = this.domNode.getLastChild();
        if (domChild != null) {
            child = this.soapChildren.get(this.soapChildren.size() - 1);
            if (domChild != child.domNode) {
                throw new WSException("Inconsistent node, child lists not synchronized");
            }
        }
        return child;
    }

    public org.w3c.dom.Node getPreviousSibling() {
        this.assertSOAPParent();
        NodeImpl sibling = null;
        if (this.soapParent != null) {
            List<NodeImpl> children = this.soapParent.soapChildren;
            for (int i = 0; i < children.size(); ++i) {
                NodeImpl node = children.get(i);
                if (node != this || i <= 0) continue;
                sibling = children.get(i - 1);
                break;
            }
            if (sibling != null && sibling.domNode != this.domNode.getPreviousSibling()) {
                throw new WSException("Inconsistent node, child lists not synchronized");
            }
        }
        return sibling;
    }

    public org.w3c.dom.Node getNextSibling() {
        this.assertSOAPParent();
        NodeImpl sibling = null;
        if (this.soapParent != null) {
            List<NodeImpl> children = this.soapParent.soapChildren;
            for (int i = 0; i < children.size(); ++i) {
                NodeImpl node = children.get(i);
                if (node != this || i + 1 >= children.size()) continue;
                sibling = children.get(i + 1);
                break;
            }
            if (sibling != null && sibling.domNode != this.domNode.getNextSibling()) {
                throw new WSException("Inconsistent node, child lists not synchronized");
            }
        }
        return sibling;
    }

    public NamedNodeMap getAttributes() {
        return this.domNode.getAttributes();
    }

    public Document getOwnerDocument() {
        if (this.soapParent == null) {
            return new SOAPDocument();
        }
        return this.soapParent.getOwnerDocument();
    }

    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        newChild = this.convertDOMNode(newChild);
        refChild = this.convertDOMNode(refChild);
        if (newChild instanceof DocumentFragment) {
            List<NodeImpl> list = this.convertDocumentFragment((DocumentFragment)newChild);
            for (NodeImpl node : list) {
                this.insertBefore((org.w3c.dom.Node)((Object)node), refChild);
            }
            return newChild;
        }
        int index = this.soapChildren.indexOf(refChild);
        if (index < 0) {
            throw new IllegalArgumentException("Cannot find refChild in list of javax.xml.soap.Node children");
        }
        NodeImpl soapNewNode = (NodeImpl)((Object)newChild);
        soapNewNode.detachNode();
        NodeImpl soapRefNode = (NodeImpl)((Object)refChild);
        this.domNode.insertBefore(soapNewNode.domNode, soapRefNode.domNode);
        this.soapChildren.add(index, soapNewNode);
        soapNewNode.soapParent = (SOAPElementImpl)this;
        return newChild;
    }

    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) throws DOMException {
        newChild = this.convertDOMNode(newChild);
        oldChild = this.convertDOMNode(oldChild);
        if (newChild instanceof DocumentFragment) {
            this.insertBefore(newChild, oldChild);
            ((NodeImpl)((Object)oldChild)).detachNode();
            return newChild;
        }
        int index = this.soapChildren.indexOf(oldChild);
        if (index < 0) {
            throw new DOMException(8, "Cannot find oldChild in list of javax.xml.soap.Node children");
        }
        NodeImpl soapNewNode = (NodeImpl)((Object)newChild);
        NodeImpl soapOldNode = (NodeImpl)((Object)oldChild);
        soapNewNode.detachNode();
        if (soapNewNode.domNode != soapOldNode.domNode) {
            this.domNode.replaceChild(soapNewNode.domNode, soapOldNode.domNode);
        }
        this.soapChildren.remove(index);
        this.soapChildren.add(index, soapNewNode);
        soapNewNode.soapParent = soapOldNode.soapParent;
        soapOldNode.soapParent = null;
        return newChild;
    }

    public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldChild) throws DOMException {
        int index = this.soapChildren.indexOf(oldChild = this.convertDOMNode(oldChild));
        if (index < 0) {
            throw new DOMException(8, "Cannot find oldChild in list of javax.xml.soap.Node children");
        }
        NodeImpl soapOldNode = (NodeImpl)((Object)oldChild);
        this.domNode.removeChild(soapOldNode.domNode);
        this.soapChildren.remove(index);
        soapOldNode.soapParent = null;
        return oldChild;
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) throws DOMException {
        if ((newChild = this.convertDOMNode(newChild)) instanceof DocumentFragment) {
            List<NodeImpl> list = this.convertDocumentFragment((DocumentFragment)newChild);
            for (NodeImpl node : list) {
                this.appendChild((org.w3c.dom.Node)((Object)node));
            }
            return newChild;
        }
        if (!(this instanceof SOAPElementImpl)) {
            throw new DOMException(15, "Cannot append child to this node: " + this);
        }
        NodeImpl soapNode = (NodeImpl)((Object)newChild);
        soapNode.detachNode();
        this.domNode.appendChild(soapNode.domNode);
        soapNode.soapParent = (SOAPElementImpl)this;
        this.soapChildren.add(soapNode);
        return newChild;
    }

    public boolean hasChildNodes() {
        return this.domNode.hasChildNodes();
    }

    public org.w3c.dom.Node cloneNode(boolean deep) {
        return this.domNode.cloneNode(deep);
    }

    public void normalize() {
        this.domNode.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.domNode.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.domNode.getNamespaceURI();
    }

    public String getPrefix() {
        return this.domNode.getPrefix();
    }

    public void setPrefix(String prefix) throws DOMException {
        this.domNode.setPrefix(prefix);
    }

    public String getLocalName() {
        return this.domNode.getLocalName();
    }

    public boolean hasAttributes() {
        return this.domNode.hasAttributes();
    }

    public int hashCode() {
        return this.domNode.hashCode();
    }

    public String toString() {
        return super.toString() + "[" + this.domNode.toString() + "]";
    }

    private org.w3c.dom.Node convertDOMNode(org.w3c.dom.Node node) {
        Object retNode;
        if (node instanceof NodeImpl) {
            retNode = node;
        } else if (node instanceof DocumentFragment) {
            retNode = new DocumentFragmentImpl((DocumentFragment)node);
        } else if (node instanceof org.w3c.dom.Text) {
            retNode = new TextImpl(node);
        } else if (node instanceof Comment) {
            retNode = new TextImpl(node);
        } else if (node instanceof Element) {
            try {
                retNode = new SOAPFactoryImpl().createElement((Element)node);
            }
            catch (SOAPException ex) {
                throw new DOMException(9, "CAnnot convert to SOAP element: " + node);
            }
        } else {
            throw new DOMException(9, "Operation not supported on this type of node: " + node);
        }
        return retNode;
    }

    private void assertSOAPParent() {
        org.w3c.dom.Node domParent = this.domNode.getParentNode();
        if (domParent != null && this.soapParent == null) {
            throw new WSException("Inconsistent node, has a DOM parent but no SOAP parent [" + this + "] " + DOMWriter.printNode((org.w3c.dom.Node)((Object)this), (boolean)false));
        }
        if (domParent != null && this.soapParent != null && domParent != this.soapParent.domNode) {
            throw new WSException("Inconsistent node, SOAP parent is not identical with DOM parent [" + this + "] " + DOMWriter.printNode((org.w3c.dom.Node)((Object)this), (boolean)false));
        }
    }

    public short compareDocumentPosition(org.w3c.dom.Node other) throws DOMException {
        throw new NotImplementedException("compareDocumentPosition");
    }

    public String getBaseURI() {
        throw new NotImplementedException("getBaseURI");
    }

    public Object getFeature(String feature, String version) {
        throw new NotImplementedException("getFeature");
    }

    public String getTextContent() throws DOMException {
        return this.domNode.getTextContent();
    }

    public Object getUserData(String key) {
        if (this.userData != null) {
            return this.userData.get(key);
        }
        return null;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new NotImplementedException("isDefaultNamespace");
    }

    public boolean isEqualNode(org.w3c.dom.Node arg) {
        return this.domNode.isEqualNode(arg);
    }

    public boolean isSameNode(org.w3c.dom.Node other) {
        throw new NotImplementedException("isSameNode");
    }

    public String lookupNamespaceURI(String prefix) {
        throw new NotImplementedException("lookupNamespaceURI");
    }

    public String lookupPrefix(String namespaceURI) {
        throw new NotImplementedException("lookupPrefix");
    }

    public void setTextContent(String textContent) throws DOMException {
        NodeList nodes = this.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            this.removeChild(nodes.item(i));
        }
        if (textContent != null && textContent.length() > 0) {
            org.w3c.dom.Text node = this.domNode.getOwnerDocument().createTextNode(textContent);
            this.appendChild(node);
        }
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        return this.userData.put(key, data);
    }
}

