/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPFaultException;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.extensions.security.AuthorizeOperation;
import org.jboss.ws.extensions.security.EncodingOperation;
import org.jboss.ws.extensions.security.EncryptionOperation;
import org.jboss.ws.extensions.security.InvalidSecurityHeaderException;
import org.jboss.ws.extensions.security.OperationDescription;
import org.jboss.ws.extensions.security.QNameTarget;
import org.jboss.ws.extensions.security.RequireEncryptionOperation;
import org.jboss.ws.extensions.security.RequireOperation;
import org.jboss.ws.extensions.security.RequireSignatureOperation;
import org.jboss.ws.extensions.security.RequireTimestampOperation;
import org.jboss.ws.extensions.security.SecurityDecoder;
import org.jboss.ws.extensions.security.SecurityEncoder;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.SendUsernameOperation;
import org.jboss.ws.extensions.security.SignatureOperation;
import org.jboss.ws.extensions.security.Target;
import org.jboss.ws.extensions.security.TimestampOperation;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.WsuIdTarget;
import org.jboss.ws.extensions.security.nonce.DefaultNonceFactory;
import org.jboss.ws.extensions.security.nonce.NonceFactory;
import org.jboss.ws.extensions.security.nonce.NonceGenerator;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.wsse.Authenticate;
import org.jboss.ws.metadata.wsse.Authorize;
import org.jboss.ws.metadata.wsse.Config;
import org.jboss.ws.metadata.wsse.Encrypt;
import org.jboss.ws.metadata.wsse.Operation;
import org.jboss.ws.metadata.wsse.Port;
import org.jboss.ws.metadata.wsse.RequireEncryption;
import org.jboss.ws.metadata.wsse.RequireSignature;
import org.jboss.ws.metadata.wsse.RequireTimestamp;
import org.jboss.ws.metadata.wsse.Requires;
import org.jboss.ws.metadata.wsse.Sign;
import org.jboss.ws.metadata.wsse.Timestamp;
import org.jboss.ws.metadata.wsse.Username;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecurityDispatcher {
    private static Logger log = Logger.getLogger(WSSecurityDispatcher.class);

    private static List<Target> convertTargets(List<org.jboss.ws.metadata.wsse.Target> targets) {
        if (targets == null) {
            return null;
        }
        ArrayList<Target> newList = new ArrayList<Target>(targets.size());
        for (org.jboss.ws.metadata.wsse.Target target : targets) {
            if ("qname".equals(target.getType())) {
                QNameTarget qnameTarget = new QNameTarget(QName.valueOf(target.getValue()), target.isContentOnly());
                newList.add(qnameTarget);
                continue;
            }
            if (!"wsuid".equals(target.getType())) continue;
            newList.add(new WsuIdTarget(target.getValue()));
        }
        return newList;
    }

    private static Config getConfig(WSSecurityConfiguration config, String portName, String opName) {
        Port port = config.getPorts().get(portName);
        if (port == null) {
            return config.getDefaultConfig();
        }
        Operation operation = port.getOperations().get(opName);
        if (operation == null) {
            Config portConfig = port.getDefaultConfig();
            return portConfig == null ? config.getDefaultConfig() : portConfig;
        }
        return operation.getConfig();
    }

    private static CommonSOAPFaultException convertToFault(WSSecurityException e) {
        return new CommonSOAPFaultException(e.getFaultCode(), e.getFaultString());
    }

    public static void handleInbound(CommonMessageContext ctx) throws SOAPException, SOAPFaultException {
        Element secHeaderElement;
        WSSecurityConfiguration config = WSSecurityDispatcher.getSecurityConfig(ctx);
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
        Config actualConfig = WSSecurityDispatcher.getActualConfig(config, null);
        SOAPHeader soapHeader = soapMessage.getSOAPHeader();
        QName secQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        Element element = secHeaderElement = soapHeader != null ? Util.findElement((Element)soapHeader, secQName) : null;
        if (secHeaderElement == null) {
            if (soapMessage.getSOAPBody().getFault() != null) {
                return;
            }
            OperationMetaData opMetaData = ctx.getOperationMetaData();
            if (opMetaData == null) {
                EndpointMetaData epMetaData = ctx.getEndpointMetaData();
                opMetaData = soapMessage.getOperationMetaData(epMetaData);
            }
            String operation = null;
            String port = null;
            if (opMetaData != null) {
                operation = opMetaData.getQName().toString();
                port = opMetaData.getEndpointMetaData().getPortName().getLocalPart();
            }
            if (WSSecurityDispatcher.hasRequirements(config, operation, port)) {
                throw WSSecurityDispatcher.convertToFault(new InvalidSecurityHeaderException("This service requires <wsse:Security>, which is missing."));
            }
        }
        try {
            Config operationConfig = WSSecurityDispatcher.getConfig(ctx, config, soapMessage);
            if (secHeaderElement != null) {
                WSSecurityDispatcher.decodeHeader(ctx, config, operationConfig, soapMessage, secHeaderElement);
            }
            WSSecurityDispatcher.authorize(operationConfig);
        }
        catch (WSSecurityException e) {
            if (e.isInternalError()) {
                log.error((Object)"Internal error occured handling inbound message:", (Throwable)e);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Returning error to sender: " + e.getMessage()));
            }
            throw WSSecurityDispatcher.convertToFault(e);
        }
    }

    private static void decodeHeader(CommonMessageContext ctx, WSSecurityConfiguration configuration, Config operationConfig, SOAPMessageImpl message, Element secHeaderElement) throws WSSecurityException, SOAPException {
        OperationMetaData opMetaData;
        SecurityStore securityStore = new SecurityStore(configuration.getKeyStoreURL(), configuration.getKeyStoreType(), configuration.getKeyStorePassword(), configuration.getKeyPasswords(), configuration.getTrustStoreURL(), configuration.getTrustStoreType(), configuration.getTrustStorePassword());
        NonceFactory factory = Util.loadFactory(NonceFactory.class, configuration.getNonceFactory(), DefaultNonceFactory.class);
        Authenticate authenticate = null;
        if (operationConfig != null) {
            authenticate = operationConfig.getAuthenticate();
        }
        SecurityDecoder decoder = new SecurityDecoder(securityStore, factory, configuration.getTimestampVerification(), authenticate);
        decoder.decode((Document)message.getSOAPPart(), secHeaderElement);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Decoded Message:\n" + DOMWriter.printNode((Node)message.getSOAPPart(), (boolean)true)));
        }
        if ((opMetaData = ctx.getOperationMetaData()) == null) {
            EndpointMetaData epMetaData = ctx.getEndpointMetaData();
            opMetaData = message.getOperationMetaData(epMetaData);
        }
        String operation = null;
        String port = null;
        if (opMetaData != null) {
            operation = opMetaData.getQName().toString();
            port = opMetaData.getEndpointMetaData().getPortName().getLocalPart();
        }
        List<OperationDescription<RequireOperation>> operations = WSSecurityDispatcher.buildRequireOperations(configuration, operation, port);
        decoder.verify(operations);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Verification is successful");
        }
        decoder.complete();
    }

    private static void authorize(Config config) throws WSSecurityException {
        Authorize authorize;
        if (config != null && (authorize = config.getAuthorize()) != null) {
            AuthorizeOperation authorizeOp = new AuthorizeOperation(authorize);
            authorizeOp.process();
        }
    }

    private static Config getConfig(CommonMessageContext ctx, WSSecurityConfiguration configuration, SOAPMessageImpl message) throws SOAPException {
        OperationMetaData opMetaData = ctx.getOperationMetaData();
        if (opMetaData == null) {
            EndpointMetaData epMetaData = ctx.getEndpointMetaData();
            opMetaData = message.getOperationMetaData(epMetaData);
        }
        String operation = null;
        String port = null;
        if (opMetaData != null) {
            operation = opMetaData.getQName().toString();
            port = opMetaData.getEndpointMetaData().getPortName().getLocalPart();
        }
        return WSSecurityDispatcher.getConfig(configuration, port, operation);
    }

    private static WSSecurityConfiguration getSecurityConfig(CommonMessageContext ctx) {
        WSSecurityConfiguration config = ctx.getEndpointMetaData().getServiceMetaData().getSecurityConfiguration();
        if (config == null) {
            throw new WSException("Cannot obtain security configuration from message context");
        }
        return config;
    }

    private static Config getActualConfig(WSSecurityConfiguration configuration, Config operationConfig) {
        CommonMessageContext ctx;
        if (operationConfig == null && (ctx = MessageContextAssociation.peekMessageContext()) != null) {
            EndpointMetaData epMetaData = ctx.getEndpointMetaData();
            QName port = epMetaData.getPortName();
            OperationMetaData opMetaData = ctx.getOperationMetaData();
            if (opMetaData == null) {
                SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
                try {
                    opMetaData = soapMessage.getOperationMetaData(epMetaData);
                }
                catch (SOAPException e) {
                    throw new WebServiceException("Error while looking for the operation meta data: " + (Object)((Object)e));
                }
            }
            if (opMetaData != null) {
                operationConfig = WSSecurityDispatcher.selectOperationConfig(configuration, port, opMetaData.getQName());
            }
        }
        return operationConfig != null ? operationConfig : configuration.getDefaultConfig();
    }

    private static Config selectOperationConfig(WSSecurityConfiguration configuration, QName portName, QName opName) {
        Port port = configuration.getPorts().get(portName != null ? portName.getLocalPart() : null);
        if (port == null) {
            return configuration.getDefaultConfig();
        }
        Operation operation = port.getOperations().get(opName != null ? opName.toString() : null);
        if (operation == null) {
            Config portConfig = port.getDefaultConfig();
            return portConfig == null ? configuration.getDefaultConfig() : portConfig;
        }
        return operation.getConfig();
    }

    private static boolean hasRequirements(WSSecurityConfiguration config, String operation, String port) {
        Config operationConfig = WSSecurityDispatcher.getConfig(config, port, operation);
        return operationConfig != null && operationConfig.getRequires() != null;
    }

    private static List<OperationDescription<RequireOperation>> buildRequireOperations(WSSecurityConfiguration config, String operation, String port) {
        RequireEncryption requireEncryption;
        RequireSignature requireSignature;
        Config operationConfig = WSSecurityDispatcher.getConfig(config, port, operation);
        if (operationConfig == null) {
            return null;
        }
        Requires requires = operationConfig.getRequires();
        if (requires == null) {
            return null;
        }
        ArrayList<OperationDescription<RequireOperation>> operations = new ArrayList<OperationDescription<RequireOperation>>();
        RequireTimestamp requireTimestamp = requires.getRequireTimestamp();
        if (requireTimestamp != null) {
            operations.add(new OperationDescription<RequireTimestampOperation>(RequireTimestampOperation.class, null, requireTimestamp.getMaxAge(), null, null));
        }
        if ((requireSignature = requires.getRequireSignature()) != null) {
            List<Target> targets = WSSecurityDispatcher.convertTargets(requireSignature.getTargets());
            operations.add(new OperationDescription<RequireSignatureOperation>(RequireSignatureOperation.class, targets, null, null, null));
        }
        if ((requireEncryption = requires.getRequireEncryption()) != null) {
            List<Target> targets = WSSecurityDispatcher.convertTargets(requireEncryption.getTargets());
            operations.add(new OperationDescription<RequireEncryptionOperation>(RequireEncryptionOperation.class, targets, null, null, null));
        }
        return operations;
    }

    public static void handleOutbound(CommonMessageContext ctx) throws SOAPException, SOAPFaultException {
        Encrypt encrypt;
        Sign sign;
        WSSecurityConfiguration config = WSSecurityDispatcher.getSecurityConfig(ctx);
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)ctx.getSOAPMessage();
        EndpointMetaData epMetaData = ctx.getEndpointMetaData();
        String port = epMetaData.getPortName().getLocalPart();
        String opName = null;
        OperationMetaData opMetaData = ctx.getOperationMetaData();
        if (opMetaData != null) {
            opName = opMetaData.getQName().toString();
        }
        Config opConfig = WSSecurityDispatcher.getConfig(config, port, opName);
        log.debug((Object)("WS-Security config: " + opConfig));
        if (opConfig == null) {
            return;
        }
        ArrayList<OperationDescription<EncodingOperation>> operations = new ArrayList<OperationDescription<EncodingOperation>>();
        Timestamp timestamp = opConfig.getTimestamp();
        if (timestamp != null) {
            operations.add(new OperationDescription<TimestampOperation>(TimestampOperation.class, null, null, timestamp.getTtl(), null));
        }
        NonceGenerator nonceGenerator = null;
        Username username = opConfig.getUsername();
        if (username != null) {
            Object user = ctx.get("javax.xml.rpc.security.auth.username");
            Object pass = ctx.get("javax.xml.rpc.security.auth.password");
            if (user == null && pass == null) {
                user = ctx.get("javax.xml.ws.security.auth.username");
                pass = ctx.get("javax.xml.ws.security.auth.password");
            }
            if (user != null && pass != null) {
                operations.add(new OperationDescription<SendUsernameOperation>(SendUsernameOperation.class, null, user.toString(), pass.toString(), null, username.isDigestPassword(), username.isUseNonce(), username.isUseCreated()));
                ctx.put("org.jboss.ws.authType", (Object)"org.jboss.ws.authType.wsse");
            }
            NonceFactory factory = Util.loadFactory(NonceFactory.class, config.getNonceFactory(), DefaultNonceFactory.class);
            nonceGenerator = factory.getGenerator();
        }
        if ((sign = opConfig.getSign()) != null) {
            List<Target> targets = WSSecurityDispatcher.convertTargets(sign.getTargets());
            if (sign.isIncludeTimestamp()) {
                if (timestamp == null) {
                    operations.add(new OperationDescription<TimestampOperation>(TimestampOperation.class, null, null, null, null));
                }
                if (targets != null && targets.size() > 0) {
                    targets.add(new WsuIdTarget("timestamp"));
                }
            }
            operations.add(new OperationDescription<SignatureOperation>(SignatureOperation.class, targets, sign.getAlias(), null, null));
        }
        if ((encrypt = opConfig.getEncrypt()) != null) {
            List<Target> targets = WSSecurityDispatcher.convertTargets(encrypt.getTargets());
            operations.add(new OperationDescription<EncryptionOperation>(EncryptionOperation.class, targets, encrypt.getAlias(), null, encrypt.getAlgorithm()));
        }
        if (operations.size() == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Encoding Message:\n" + DOMWriter.printNode((Node)soapMessage.getSOAPPart(), (boolean)true)));
        }
        try {
            SecurityStore securityStore = new SecurityStore(config.getKeyStoreURL(), config.getKeyStoreType(), config.getKeyStorePassword(), config.getKeyPasswords(), config.getTrustStoreURL(), config.getTrustStoreType(), config.getTrustStorePassword(), nonceGenerator);
            SecurityEncoder encoder = new SecurityEncoder(operations, securityStore);
            encoder.encode((Document)soapMessage.getSOAPPart());
        }
        catch (WSSecurityException e) {
            if (e.isInternalError()) {
                log.error((Object)"Internal error occured handling outbound message:", (Throwable)e);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Returning error to sender: " + e.getMessage()));
            }
            throw WSSecurityDispatcher.convertToFault(e);
        }
    }
}

