/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.annotation.ejb.Depends;
import org.jboss.ejb3.injection.pojo.InjectionHelper;
import org.jboss.ejb3.injection.pojo.PojoInjector;
import org.jboss.mx.util.MBeanProxyExt;

public class DependsInjector
implements PojoInjector {
    public void inject(Method m, Annotation annotation, Object pojo) {
        InjectionHelper.checkMethodSignature(m, annotation);
        Depends ref = (Depends)annotation;
        Class<?> type = m.getParameterTypes()[0];
        Object obj = this.getDependency(ref, type);
        try {
            m.invoke(pojo, obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object getDependency(Depends ref, Class type) {
        Object value;
        if (ref.value().length > 1) {
            throw new RuntimeException("Cannot inject multiple dependencies");
        }
        ObjectName on = null;
        try {
            on = new ObjectName(ref.value()[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (type.equals(ObjectName.class)) {
            value = on;
        } else {
            MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
            value = MBeanProxyExt.create((Class)type, (ObjectName)on, (MBeanServer)server);
        }
        return value;
    }

    public void inject(Field f, Annotation annotation, Object pojo) {
        Depends ref = (Depends)annotation;
        Class<?> type = f.getType();
        Object obj = this.getDependency(ref, type);
        try {
            f.setAccessible(true);
            f.set(pojo, obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

