/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.naming.InitialContext;
import org.jboss.naming.NamingContextFactory;

public class StatelessHandleImpl
implements Handle {
    static final long serialVersionUID = 3811452873535097661L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("jndiName", String.class), new ObjectStreamField("jndiEnv", Hashtable.class)};
    public String jndiName;
    private Hashtable jndiEnv;

    public StatelessHandleImpl() {
    }

    public StatelessHandleImpl(String jndiName) {
        this.jndiName = jndiName;
        this.jndiEnv = (Hashtable)NamingContextFactory.lastInitialContextEnv.get();
    }

    public EJBObject getEJBObject() throws RemoteException {
        try {
            InitialContext ic = null;
            ic = this.jndiEnv != null ? new InitialContext(this.jndiEnv) : new InitialContext();
            Proxy proxy = (Proxy)ic.lookup(this.jndiName);
            return (EJBObject)proxy;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RemoteException("Error during getEJBObject", t);
        }
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = ois.readFields();
        this.jndiName = (String)getField.get("jndiName", null);
        this.jndiEnv = (Hashtable)getField.get("jndiEnv", null);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        putField.put("jndiName", this.jndiName);
        putField.put("jndiEnv", this.jndiEnv);
        oos.writeFields();
    }
}

