/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.MappingException;
import cirrus.hibernate.cache.CacheConcurrencyStrategy;
import cirrus.hibernate.helpers.JoinedIterator;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.map.Collection;
import cirrus.hibernate.map.Component;
import cirrus.hibernate.map.ManyToOne;
import cirrus.hibernate.map.OneToOne;
import cirrus.hibernate.map.Property;
import cirrus.hibernate.map.Root;
import cirrus.hibernate.map.RootClass;
import cirrus.hibernate.map.Subclass;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.map.Value;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PersistentClass {
    private final Class persistentClass;
    private final String className;
    private final String discriminatorValue;
    private final ArrayList properties = new ArrayList();
    private Table table;
    private final ArrayList subclasses = new ArrayList();
    private final ArrayList subclassProperties = new ArrayList();
    private final ArrayList subclassTables = new ArrayList();
    private Class proxyInterface;

    protected PersistentClass(Node node) throws MappingException {
        Node discriminatorNode;
        NamedNodeMap atts = node.getAttributes();
        this.className = atts.getNamedItem("name").getNodeValue();
        try {
            this.persistentClass = ReflectHelper.classForName(this.className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("persistent class not found", cnfe);
        }
        Node proxyNode = atts.getNamedItem("proxy");
        if (proxyNode != null) {
            try {
                this.proxyInterface = ReflectHelper.classForName(proxyNode.getNodeValue());
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException(cnfe);
            }
        }
        this.discriminatorValue = (discriminatorNode = atts.getNamedItem("discriminator-value")) == null ? this.className : discriminatorNode.getNodeValue();
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    protected void addSubclass(Subclass subclass) {
        this.subclasses.add(subclass);
    }

    protected void propertiesFromXML(Node node, Root root) throws MappingException {
        NodeList list = node.getChildNodes();
        String path = StringHelper.unqualify(this.className);
        Table table = this.getTable();
        int i = 0;
        while (i < list.getLength()) {
            Node subnode = list.item(i);
            String name = subnode.getNodeName();
            String propertyName = Property.getPropertyName(subnode);
            Root.CollectionType collectType = Root.CollectionType.collectionTypeFromString(name);
            Value value = null;
            if (collectType != null) {
                Collection collection = collectType.create(subnode, path, this, root);
                root.addCollection(collection);
                value = new Value(subnode, path, true, table, root);
            } else if ("many-to-one".equals(name)) {
                value = new ManyToOne(subnode, path, propertyName, true, table, root);
            } else if ("one-to-one".equals(name)) {
                value = new OneToOne(subnode, this.getIdentifier(), path, true, table, root);
            } else if ("property".equals(name)) {
                value = new Value(subnode, "", propertyName, true, table, root);
            } else if ("collection".equals(name)) {
                value = new Value(subnode, "", propertyName, true, table, root);
            } else if ("component".equals(name)) {
                Class reflectedClass = ReflectHelper.getGetter(this.getPersistentClass(), propertyName).getReturnType();
                value = new Component(subnode, reflectedClass, path, this, true, table, root);
            } else if ("subclass".equals(name) || "joined-subclass".equals(name)) {
                Subclass subclass = new Subclass(this, list.item(i), this.getTable(), root);
                this.addSubclass(subclass);
                root.addPersistentClass(subclass);
            }
            if (value != null) {
                value.setTypeByReflection(this.persistentClass, propertyName);
                value.createForeignKeys(root, table);
                this.addProperty(new Property(subnode, value, root));
            }
            ++i;
        }
    }

    public boolean hasSubclasses() {
        return this.subclasses.size() > 0;
    }

    public int getSubclassSpan() {
        int n = this.subclasses.size();
        Iterator iter = this.subclasses.iterator();
        while (iter.hasNext()) {
            n += ((Subclass)iter.next()).getSubclassSpan();
        }
        return n;
    }

    public Iterator getSubclassIterator() {
        Iterator[] iters = new Iterator[this.subclasses.size() + 1];
        Iterator iter = this.subclasses.iterator();
        int i = 0;
        while (iter.hasNext()) {
            iters[i++] = ((Subclass)iter.next()).getSubclassIterator();
        }
        iters[i] = this.subclasses.iterator();
        return new JoinedIterator(iters);
    }

    public Iterator getDirectSubclasses() {
        return this.subclasses.iterator();
    }

    public void addProperty(Property p) {
        this.properties.add(p);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Iterator getPropertyIterator() {
        return this.properties.iterator();
    }

    public Table getTable() {
        return this.table;
    }

    public Class getPersistentClass() {
        return this.persistentClass;
    }

    public String getName() {
        return this.persistentClass.getName();
    }

    public abstract boolean isMutable();

    public abstract boolean hasIdentifierProperty();

    public abstract Property getIdentifierProperty();

    public abstract Value getIdentifier();

    public abstract Property getVersion();

    public abstract Value getDiscriminator();

    public abstract boolean isInherited();

    public abstract boolean isPolymorphic();

    public abstract boolean isVersioned();

    public abstract CacheConcurrencyStrategy getCache();

    public abstract PersistentClass getSuperclass();

    public abstract boolean isExplicitPolymorphism();

    public abstract Iterator getPropertyClosureIterator();

    public abstract Iterator getTableClosureIterator();

    protected void addSubclassProperty(Property p) {
        this.subclassProperties.add(p);
    }

    protected void addSubclassTable(Table table) {
        this.subclassTables.add(table);
    }

    public Iterator getSubclassPropertyClosureIterator() {
        return new JoinedIterator(new Iterator[]{this.getPropertyClosureIterator(), this.subclassProperties.iterator()});
    }

    public Iterator getSubclassTableClosureIterator() {
        return new JoinedIterator(new Iterator[]{this.getTableClosureIterator(), this.subclassTables.iterator()});
    }

    public Class getProxyInterface() {
        return this.proxyInterface;
    }

    public abstract boolean hasEmbeddedIdentifier();

    public abstract Class getPersister();

    public abstract Table getRootTable();

    public abstract RootClass getRootClass();

    public abstract Value getKey();
}

