/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.test;

import cirrus.hibernate.Environment;
import cirrus.hibernate.Session;
import cirrus.hibernate.connection.ConnectionProvider;
import cirrus.hibernate.connection.ConnectionProviderFactory;
import cirrus.hibernate.test.Simple;
import cirrus.hibernate.test.TestCase;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PerformanceTest
extends TestCase {
    static /* synthetic */ Class class$cirrus$hibernate$test$PerformanceTest;

    public PerformanceTest(String arg0) {
        super(arg0);
    }

    public void testPerformance() throws Exception {
        ConnectionProvider cp = ConnectionProviderFactory.newConnectionProvider(Environment.getProperties());
        int N = 2;
        while (N < 4000) {
            Simple[] simples = new Simple[N];
            Serializable[] ids = new Serializable[N];
            int i = 0;
            while (i < N) {
                simples[i] = new Simple();
                simples[i].init();
                simples[i].setCount(i);
                ids[i] = new Long(i);
                ++i;
            }
            Session s = TestCase.sessions.openSession();
            this.hibernate(s, simples, ids, N, "h0");
            s.close();
            Connection c = cp.getConnection();
            this.directJDBC(c, simples, ids, N, "j0");
            cp.closeConnection(c);
            s = TestCase.sessions.openSession();
            long time = System.currentTimeMillis();
            this.hibernate(s, simples, ids, N, "h1");
            long hiber = System.currentTimeMillis() - time;
            s.close();
            c = cp.getConnection();
            time = System.currentTimeMillis();
            this.directJDBC(c, simples, ids, N, "j1");
            long jdbc = System.currentTimeMillis() - time;
            cp.closeConnection(c);
            s = TestCase.sessions.openSession();
            time = System.currentTimeMillis();
            this.hibernate(s, simples, ids, N, "h2");
            hiber += System.currentTimeMillis() - time;
            s.close();
            c = cp.getConnection();
            time = System.currentTimeMillis();
            this.directJDBC(c, simples, ids, N, "j2");
            cp.closeConnection(c);
            System.out.println("Objects: " + N + " - Hibernate: " + hiber + "ms / Direct JDBC: " + (jdbc += System.currentTimeMillis() - time) + "ms / Ratio: " + (float)hiber / (float)jdbc);
            N *= 2;
        }
    }

    private void hibernate(Session s, Simple[] simples, Serializable[] ids, int N, String runname) throws Exception {
        int i = 0;
        while (i < N) {
            s.save(simples[i], ids[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < N) {
            simples[0].setName("A Different Name!" + i2 + N + runname);
            ++i2;
        }
        this.assertTrue(s.delete("from s in class cirrus.hibernate.test.Simple") == N, "assertion");
        s.flush();
        s.connection().commit();
    }

    private void directJDBC(Connection c, Simple[] simples, Serializable[] ids, int N, String runname) throws SQLException {
        PreparedStatement insert = c.prepareStatement("insert into Simple ( name, address, count_, date_, other, id_ ) values ( ?, ?, ?, ?, ?, ? )");
        PreparedStatement delete = c.prepareStatement("delete from Simple where id_ = ?");
        PreparedStatement select = c.prepareStatement("SELECT s.id_, s.name, s.address, s.count_, s.date_, s.other FROM Simple s");
        PreparedStatement update = c.prepareStatement("update Simple set name = ?, address = ?, count_ = ?, date_ = ?, other = ? where id_ = ?");
        int i = 0;
        while (i < N) {
            insert.setString(1, simples[i].getName());
            insert.setString(2, simples[i].getAddress());
            insert.setInt(3, simples[i].getCount());
            insert.setDate(4, (Date)simples[i].getDate());
            insert.setNull(5, -5);
            insert.setLong(6, (Long)ids[i]);
            insert.executeUpdate();
            ++i;
        }
        int i2 = 0;
        while (i2 < N) {
            update.setString(1, "A Different Name!" + i2 + N + runname);
            update.setString(2, simples[i2].getAddress());
            update.setInt(3, simples[i2].getCount());
            update.setDate(4, (Date)simples[i2].getDate());
            update.setNull(5, -5);
            update.setLong(6, (Long)ids[i2]);
            update.executeUpdate();
            ++i2;
        }
        ResultSet rs = select.executeQuery();
        Long[] keys = new Long[N];
        int j = 0;
        while (rs.next()) {
            keys[j++] = new Long(rs.getLong(1));
            rs.getString(2);
            rs.getString(3);
            rs.getInt(4);
            rs.getDate(5);
            rs.getLong(6);
        }
        rs.close();
        int i3 = 0;
        while (i3 < N) {
            delete.setLong(1, keys[i3]);
            delete.executeUpdate();
            ++i3;
        }
        c.commit();
    }

    public static Test suite() throws Exception {
        TestCase.exportSchema(new String[]{"Simple.hbm.xml"});
        return new TestSuite(class$cirrus$hibernate$test$PerformanceTest == null ? (class$cirrus$hibernate$test$PerformanceTest = PerformanceTest.class$("cirrus.hibernate.test.PerformanceTest")) : class$cirrus$hibernate$test$PerformanceTest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

